/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.on.plugins.tomcat.TomcatUserDatabaseComponent;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatGroupComponent
extends MBeanResourceComponent<TomcatUserDatabaseComponent>
implements DeleteResourceFacet {
    public static final String CONFIG_DESCRIPTION = "description";
    public static final String CONFIG_GROUP_NAME = "groupname";
    public static final String CONFIG_ROLES = "roles";
    public static final String PLUGIN_CONFIG_NAME = "name";
    public static final String RESOURCE_TYPE_NAME = "Tomcat Group";
    private static final Pattern PATTERN_ROLE_NAME = Pattern.compile("rolename=(.*),");

    public Configuration loadResourceConfiguration() {
        Configuration configuration = super.loadResourceConfiguration();
        try {
            this.resetConfig(CONFIG_ROLES, PATTERN_ROLE_NAME, configuration);
        }
        catch (Exception e) {
            log.error((Object)"Failed to reset role property value", (Throwable)e);
        }
        return configuration;
    }

    private void resetConfig(String property, Pattern pattern, Configuration configuration) {
        EmsAttribute attribute = this.getEmsBean().getAttribute(property);
        Object valueObject = attribute.refresh();
        String[] vals = (String[])valueObject;
        if (vals.length > 0) {
            String delim = "";
            StringBuilder sb = new StringBuilder();
            Matcher matcher = pattern.matcher("");
            for (String val : vals) {
                matcher.reset(val);
                matcher.find();
                sb.append(delim);
                sb.append(matcher.group(1));
                delim = "\n";
            }
            configuration.put((Property)new PropertySimple(property, (Object)sb.toString()));
        } else {
            configuration.put((Property)new PropertySimple(property, null));
        }
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration reportConfiguration = report.getConfiguration();
        PropertySimple newRoles = reportConfiguration.getSimple(CONFIG_ROLES);
        this.resetConfig(CONFIG_ROLES, PATTERN_ROLE_NAME, reportConfiguration);
        PropertySimple currentRoles = reportConfiguration.getSimple(CONFIG_ROLES);
        reportConfiguration.remove(CONFIG_ROLES);
        super.updateResourceConfiguration(report);
        reportConfiguration.put((Property)newRoles);
        if (ConfigurationUpdateStatus.SUCCESS != report.getStatus()) {
            return;
        }
        try {
            this.consolidateSettings(newRoles, currentRoles, "addRole", "removeRole", "role");
        }
        catch (Exception e) {
            newRoles.setErrorMessageFromThrowable((Throwable)e);
            report.setErrorMessage("Failed setting resource configuration - see property error messages for details");
            log.info((Object)"Failure setting Tomcat User Roles configuration value", (Throwable)e);
        }
    }

    private void consolidateSettings(PropertySimple newVals, PropertySimple currentVals, String addOp, String removeOp, String arg) throws Exception {
        String currentValsLongString = currentVals.getStringValue();
        String newValsLongString = newVals.getStringValue();
        StringTokenizer tokenizer = null;
        Configuration opConfig = null;
        if (null != newValsLongString) {
            tokenizer = new StringTokenizer(newValsLongString, "\n");
            opConfig = new Configuration();
            while (tokenizer.hasMoreTokens()) {
                String newVal = tokenizer.nextToken().trim();
                if (null != currentValsLongString && currentValsLongString.contains(newVal)) continue;
                opConfig.put((Property)new PropertySimple(arg, (Object)newVal));
                try {
                    this.invokeOperation(addOp, opConfig);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not add " + arg + "=" + newVal + ". Please check spelling/existence.");
                }
            }
        }
        if (null != currentValsLongString) {
            tokenizer = new StringTokenizer(currentValsLongString, "\n");
            while (tokenizer.hasMoreTokens()) {
                String currentVal = tokenizer.nextToken().trim();
                if (null != newValsLongString && newValsLongString.contains(currentVal)) continue;
                opConfig.put((Property)new PropertySimple(arg, (Object)currentVal));
                try {
                    this.invokeOperation(removeOp, opConfig);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not remove " + arg + "=" + currentVal + ". Please check spelling/existence.");
                }
            }
        }
    }

    public void deleteResource() throws Exception {
        Configuration opConfig = new Configuration();
        ResourceContext resourceContext = this.getResourceContext();
        PropertySimple nameProperty = resourceContext.getPluginConfiguration().getSimple(PLUGIN_CONFIG_NAME);
        String name = nameProperty.getStringValue();
        nameProperty = new PropertySimple(CONFIG_GROUP_NAME, (Object)name.substring(1, name.length() - 1));
        opConfig.put((Property)nameProperty);
        ((TomcatUserDatabaseComponent)resourceContext.getParentResourceComponent()).invokeOperation("removeGroup", opConfig);
    }
}

