/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatVHostComponent;
import org.jboss.on.plugins.tomcat.helper.TomcatApplicationDeployer;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.clientapi.server.plugin.content.util.JarContentFileInfo;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.content.version.PackageVersions;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatWarComponent
extends MBeanResourceComponent<TomcatVHostComponent>
implements ContentFacet,
DeleteResourceFacet {
    private static final String METRIC_PREFIX_APPLICATION = "Application.";
    private static final String METRIC_PREFIX_SERVLET = "Servlet.";
    private static final String METRIC_PREFIX_SESSION = "Session.";
    private static final String METRIC_PREFIX_VHOST = "VHost.";
    private static final String METRIC_RESPONSE_TIME = "ResponseTime";
    private static final String METRIC_MAX_SERVLET_TIME = "Servlet.MaxResponseTime";
    private static final String METRIC_MIN_SERVLET_TIME = "Servlet.MinResponseTime";
    private static final String METRIC_AVG_SERVLET_TIME = "Servlet.AvgResponseTime";
    private static final String METRIC_NUM_SERVLET_REQUESTS = "Servlet.NumRequests";
    private static final String METRIC_NUM_SERVLET_ERRORS = "Servlet.NumErrors";
    private static final String METRIC_TOTAL_TIME = "Servlet.TotalTime";
    private static final String TRAIT_EXPLODED = "Application.exploded";
    private static final String TRAIT_VHOST_NAMES = "VHost.name";
    private static final String QUERY_TEMPLATE_SERVLET = "Catalina:j2eeType=Servlet,J2EEApplication=none,J2EEServer=none,WebModule=%WEBMODULE%,name=%name%";
    private static final String QUERY_TEMPLATE_SESSION = "Catalina:type=Manager,host=%HOST%,path=%PATH%";
    private static final String QUERY_TEMPLATE_HOST = "Catalina:type=Manager,path=%PATH%,host=%host%";
    protected static final String PROPERTY_NAME = "name";
    protected static final String PROPERTY_CONTEXT_ROOT = "contextRoot";
    protected static final String PROPERTY_FILENAME = "filename";
    protected static final String PROPERTY_RESPONSE_TIME_LOG_FILE = "responseTimeLogFile";
    protected static final String PROPERTY_RESPONSE_TIME_URL_EXCLUDES = "responseTimeUrlExcludes";
    protected static final String PROPERTY_RESPONSE_TIME_URL_TRANSFORMS = "responseTimeUrlTransforms";
    protected static final String PROPERTY_VHOST = "vHost";
    protected static final String RESOURCE_TYPE_NAME = "Tomcat Web Application (WAR)";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String BACKUP_FILE_EXTENSION = ".rej";
    private static final String PKG_TYPE_FILE = "file";
    private static final String ARCHITECTURE = "noarch";
    private PackageVersions versions;
    private EmsBean webModuleMBean;
    private ResponseTimeLogParser logParser;

    public AvailabilityType getAvailability() {
        AvailabilityType availability;
        if (null == this.webModuleMBean) {
            this.webModuleMBean = this.getWebModuleMBean();
        }
        if (null != this.webModuleMBean) {
            int state;
            try {
                state = (Integer)this.webModuleMBean.getAttribute("state").refresh();
            }
            catch (Exception e) {
                state = 0;
            }
            AvailabilityType availabilityType = availability = 1 == state ? AvailabilityType.UP : AvailabilityType.DOWN;
            if (AvailabilityType.DOWN == availability) {
                this.webModuleMBean = null;
            }
        } else {
            availability = AvailabilityType.DOWN;
        }
        return availability;
    }

    public void start(ResourceContext<TomcatVHostComponent> resourceContext) {
        super.start(resourceContext);
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        this.webModuleMBean = this.getWebModuleMBean();
        ResponseTimeConfiguration responseTimeConfig = new ResponseTimeConfiguration(pluginConfig);
        File logFile = responseTimeConfig.getLogFile();
        if (logFile != null) {
            this.logParser = new ResponseTimeLogParser(logFile);
            this.logParser.setExcludes(responseTimeConfig.getExcludes());
            this.logParser.setTransforms(responseTimeConfig.getTransforms());
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> schedules) {
        for (MeasurementScheduleRequest schedule : schedules) {
            String metricName = schedule.getName();
            try {
                MeasurementDataTrait trait;
                MeasurementDataNumeric metric;
                Double value;
                if (metricName.equals(METRIC_RESPONSE_TIME)) {
                    if (this.logParser != null) {
                        try {
                            CallTimeData callTimeData = new CallTimeData(schedule);
                            this.logParser.parseLog(callTimeData);
                            report.addData(callTimeData);
                        }
                        catch (Exception e) {
                            this.log.error((Object)"Failed to retrieve HTTP call-time data.", (Throwable)e);
                        }
                        continue;
                    }
                    this.log.error((Object)("The 'ResponseTime' metric is enabled for WAR resource '" + this.getApplicationName() + "', but no value is defined for the '" + PROPERTY_RESPONSE_TIME_LOG_FILE + "' connection property."));
                    continue;
                }
                if (metricName.startsWith(METRIC_PREFIX_SERVLET)) {
                    value = this.getServletMetric(metricName);
                    metric = new MeasurementDataNumeric(schedule, value);
                    report.addData(metric);
                    continue;
                }
                if (metricName.startsWith(METRIC_PREFIX_SESSION)) {
                    value = this.getSessionMetric(metricName);
                    metric = new MeasurementDataNumeric(schedule, value);
                    report.addData(metric);
                    continue;
                }
                if (metricName.startsWith(METRIC_PREFIX_VHOST)) {
                    if (!metricName.equals(TRAIT_VHOST_NAMES)) continue;
                    List<EmsBean> beans = this.getVHosts();
                    String value2 = "";
                    Iterator<EmsBean> iter = beans.iterator();
                    while (iter.hasNext()) {
                        EmsBean eBean = iter.next();
                        value2 = value2 + eBean.getBeanName().getKeyProperty("host");
                        if (!iter.hasNext()) continue;
                        value2 = value2 + ",";
                    }
                    trait = new MeasurementDataTrait(schedule, value2);
                    report.addData(trait);
                    continue;
                }
                if (metricName.startsWith(METRIC_PREFIX_APPLICATION)) {
                    if (!metricName.equals(TRAIT_EXPLODED)) continue;
                    Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
                    String filename = pluginConfig.getSimpleValue(PROPERTY_FILENAME, null);
                    boolean exploded = new File(filename).isDirectory();
                    trait = new MeasurementDataTrait(schedule, exploded ? "yes" : "no");
                    report.addData(trait);
                    continue;
                }
                this.log.warn((Object)("Unexpected Tomcat WAR metric schedule: " + metricName));
            }
            catch (Exception e) {
                this.log.debug((Object)("Failed to gather Tomcat WAR metric: " + metricName + ", " + e));
            }
        }
    }

    private Double getSessionMetric(String metricName) {
        EmsConnection jmxConnection = this.getEmsConnection();
        String servletMBeanNames = QUERY_TEMPLATE_SESSION;
        Configuration config = this.getResourceContext().getPluginConfiguration();
        servletMBeanNames = servletMBeanNames.replace("%PATH%", config.getSimpleValue(PROPERTY_CONTEXT_ROOT, ""));
        servletMBeanNames = servletMBeanNames.replace("%HOST%", config.getSimpleValue(PROPERTY_VHOST, ""));
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(servletMBeanNames);
        List mBeans = jmxConnection.queryBeans(queryUtility.getTranslatedQuery());
        String property = metricName.substring(METRIC_PREFIX_SESSION.length());
        Double ret = Double.NaN;
        if (mBeans.size() > 0) {
            EmsBean eBean = (EmsBean)mBeans.get(0);
            eBean.refreshAttributes();
            EmsAttribute att = eBean.getAttribute(property);
            if (att != null) {
                Integer i = (Integer)att.getValue();
                ret = (double)i;
            }
        }
        return ret;
    }

    private Double getServletMetric(String metricName) {
        EmsConnection jmxConnection = this.getEmsConnection();
        String servletMBeanNames = QUERY_TEMPLATE_SERVLET;
        Configuration config = this.getResourceContext().getPluginConfiguration();
        servletMBeanNames = servletMBeanNames.replace("%WEBMODULE%", config.getSimpleValue(PROPERTY_NAME, ""));
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(servletMBeanNames);
        List mBeans = jmxConnection.queryBeans(queryUtility.getTranslatedQuery());
        long min = Long.MAX_VALUE;
        long max = 0L;
        long processingTime = 0L;
        int requestCount = 0;
        int errorCount = 0;
        for (EmsBean mBean : mBeans) {
            Integer i;
            Long l;
            EmsAttribute att;
            mBean.refreshAttributes();
            if (metricName.equals(METRIC_MIN_SERVLET_TIME)) {
                att = mBean.getAttribute("minTime");
                l = (Long)att.getValue();
                if (l >= min) continue;
                min = l;
                continue;
            }
            if (metricName.equals(METRIC_MAX_SERVLET_TIME)) {
                att = mBean.getAttribute("maxTime");
                l = (Long)att.getValue();
                if (l <= max) continue;
                max = l;
                continue;
            }
            if (metricName.equals(METRIC_AVG_SERVLET_TIME)) {
                att = mBean.getAttribute("processingTime");
                l = (Long)att.getValue();
                processingTime += l.longValue();
                att = mBean.getAttribute("requestCount");
                Integer i2 = (Integer)att.getValue();
                requestCount += i2.intValue();
                continue;
            }
            if (metricName.equals(METRIC_NUM_SERVLET_REQUESTS)) {
                att = mBean.getAttribute("requestCount");
                i = (Integer)att.getValue();
                requestCount += i.intValue();
                continue;
            }
            if (metricName.equals(METRIC_NUM_SERVLET_ERRORS)) {
                att = mBean.getAttribute("errorCount");
                i = (Integer)att.getValue();
                errorCount += i.intValue();
                continue;
            }
            if (!metricName.equals(METRIC_TOTAL_TIME)) continue;
            att = mBean.getAttribute("processingTime");
            l = (Long)att.getValue();
            processingTime += l.longValue();
        }
        Double result = metricName.equals(METRIC_AVG_SERVLET_TIME) ? Double.valueOf(requestCount > 0 ? (double)processingTime / (double)requestCount : Double.NaN) : (metricName.equals(METRIC_MIN_SERVLET_TIME) ? Double.valueOf(min != Long.MAX_VALUE ? (double)min : Double.NaN) : (metricName.equals(METRIC_MAX_SERVLET_TIME) ? Double.valueOf(max != 0L ? (double)max : Double.NaN) : (metricName.equals(METRIC_NUM_SERVLET_ERRORS) ? Double.valueOf(errorCount) : (metricName.equals(METRIC_NUM_SERVLET_REQUESTS) ? Double.valueOf(requestCount) : (metricName.equals(METRIC_TOTAL_TIME) ? Double.valueOf(processingTime) : Double.valueOf(Double.NaN))))));
        return result;
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        WarOperation operation = this.getOperation(name);
        if (name.equalsIgnoreCase("start")) {
            this.webModuleMBean = this.getWebModuleMBean();
        }
        if (null == this.webModuleMBean) {
            throw new IllegalStateException("Could not find MBean for WAR '" + this.getApplicationName() + "'.");
        }
        EmsOperation mbeanOperation = this.webModuleMBean.getOperation(name);
        if (mbeanOperation == null) {
            throw new IllegalStateException("Operation [" + name + "] not found on bean [" + this.webModuleMBean.getBeanName() + "]");
        }
        Object[] paramValues = new Object[]{};
        mbeanOperation.invoke(paramValues);
        int state = (Integer)this.webModuleMBean.getAttribute("state").refresh();
        int expectedState = TomcatWarComponent.getExpectedPostExecutionState(operation);
        if (state != expectedState) {
            throw new Exception("Failed to " + name + " webapp (value of the 'state' attribute of MBean '" + this.webModuleMBean.getBeanName() + "' is " + state + ", not " + expectedState + ").");
        }
        return new OperationResult();
    }

    private static int getExpectedPostExecutionState(WarOperation operation) {
        int expectedState;
        switch (operation) {
            case START: 
            case RELOAD: {
                expectedState = 1;
                break;
            }
            case STOP: {
                expectedState = 0;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operation: " + (Object)((Object)operation));
            }
        }
        return expectedState;
    }

    private WarOperation getOperation(String name) {
        try {
            return WarOperation.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid operation name: " + name);
        }
    }

    @Nullable
    private EmsBean getWebModuleMBean() {
        String webModuleMBeanName = this.getWebModuleMBeanName();
        EmsBean result = null;
        if (webModuleMBeanName != null) {
            ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(webModuleMBeanName);
            List mBeans = this.getEmsConnection().queryBeans(queryUtility.getTranslatedQuery());
            if (mBeans.size() == 1) {
                result = (EmsBean)mBeans.get(0);
            }
        }
        return result;
    }

    @Nullable
    private String getWebModuleMBeanName() {
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        String name = pluginConfig.getSimpleValue(PROPERTY_NAME, null);
        String webModuleMBeanName = "Catalina:j2eeType=WebModule,J2EEApplication=none,J2EEServer=none,name=" + name;
        return webModuleMBeanName;
    }

    private List<EmsBean> getVHosts() {
        EmsConnection emsConnection = this.getEmsConnection();
        String query = QUERY_TEMPLATE_HOST;
        query = query.replace("%PATH%", this.getResourceContext().getPluginConfiguration().getSimpleValue(PROPERTY_CONTEXT_ROOT, ""));
        ObjectNameQueryUtility queryUtil = new ObjectNameQueryUtility(query);
        List mBeans = emsConnection.queryBeans(queryUtil.getTranslatedQuery());
        return mBeans;
    }

    private String getApplicationName() {
        String resourceKey = this.getResourceContext().getResourceKey();
        String appName = resourceKey.substring(resourceKey.lastIndexOf(61) + 1);
        return appName;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        File tempFile;
        if (packages.size() != 1) {
            DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("When deploying WAR files only one can be updated at a time.");
            return response;
        }
        ResourcePackageDetails packageDetails = packages.iterator().next();
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        File appFile = new File(pluginConfig.getSimple(PROPERTY_FILENAME).getStringValue());
        if (!appFile.exists()) {
            return this.failApplicationDeployment("Could not find application to update at location: " + appFile, packageDetails);
        }
        boolean isExploded = appFile.isDirectory();
        try {
            tempFile = this.writeAppBitsToTempFile(appFile, contentServices, packageDetails);
        }
        catch (Exception e) {
            return this.failApplicationDeployment("Error writing new application bits to temporary file - cause: " + e, packageDetails);
        }
        File backupFile = null;
        try {
            backupFile = this.deleteApp(pluginConfig, appFile, true);
        }
        catch (Exception e) {
            if (appFile.exists()) {
                return this.failApplicationDeployment("Error undeploying existing app - cause: " + e, packageDetails);
            }
            this.log.warn((Object)("Failed to create app backup but proceeding with redeploy of " + appFile.getPath() + ": " + e));
        }
        try {
            this.moveTempFileToDeployLocation(tempFile, appFile, isExploded);
        }
        catch (Exception e) {
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            try {
                FileUtils.purge((File)appFile, (boolean)true);
                this.moveTempFileToDeployLocation(backupFile, appFile, isExploded);
                errorMessage = errorMessage + " ***** ROLLED BACK TO ORIGINAL APPLICATION FILE. *****";
            }
            catch (Exception e1) {
                errorMessage = errorMessage + " ***** FAILED TO ROLLBACK TO ORIGINAL APPLICATION FILE. *****: " + ThrowableUtil.getAllMessages((Throwable)e1);
            }
            return this.failApplicationDeployment(errorMessage, packageDetails);
        }
        this.deleteBackupOfOriginalFile(backupFile);
        this.persistApplicationVersion(packageDetails, appFile);
        DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.SUCCESS);
        DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(packageDetails.getKey(), ContentResponseResult.SUCCESS);
        response.addPackageResponse(packageResponse);
        return response;
    }

    private void moveTempFileToDeployLocation(File tempFile, File appFile, boolean isExploded) throws IOException {
        BufferedInputStream tempIs = null;
        if (isExploded) {
            tempIs = new BufferedInputStream(new FileInputStream(tempFile));
            appFile.mkdir();
            ZipUtil.unzipFile((InputStream)tempIs, (File)appFile);
        } else {
            tempFile.renameTo(appFile);
        }
    }

    private File backupAppBitsToTempFile(File appFile) throws Exception {
        File tempDir = this.getResourceContext().getTemporaryDirectory();
        File tempFile = new File(tempDir.getAbsolutePath(), appFile.getName() + System.currentTimeMillis());
        if (tempFile.exists()) {
            this.log.warn((Object)("Existing temporary file found and will be deleted at: " + tempFile));
            tempFile.delete();
        }
        try {
            ZipUtil.zipFileOrDirectory((File)appFile, (File)tempFile);
        }
        catch (IOException e) {
            this.log.error((Object)("Error backing up app " + appFile.getPath() + " to " + tempFile), (Throwable)e);
            if (tempFile.exists()) {
                tempFile.delete();
            }
            throw e;
        }
        finally {
            if (!tempFile.exists()) {
                this.log.error((Object)("Temporary file for application update not written to: " + tempFile));
                throw new Exception();
            }
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeAppBitsToTempFile(File file, ContentServices contentServices, ResourcePackageDetails packageDetails) throws Exception {
        File tempDir = this.getResourceContext().getTemporaryDirectory();
        File tempFile = new File(tempDir.getAbsolutePath(), file.getName() + System.currentTimeMillis());
        if (tempFile.exists()) {
            this.log.warn((Object)("Existing temporary file found and will be deleted at: " + tempFile));
            tempFile.delete();
        }
        OutputStream tempOutputStream = null;
        try {
            tempOutputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            contentServices.downloadPackageBits(this.getResourceContext().getContentContext(), packageDetails.getKey(), tempOutputStream, true);
        }
        finally {
            if (tempOutputStream != null) {
                try {
                    tempOutputStream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Error closing temporary output stream", (Throwable)e);
                }
            }
        }
        if (!tempFile.exists()) {
            this.log.error((Object)("Temporary file for application update not written to: " + tempFile));
            throw new Exception();
        }
        return tempFile;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        HashSet<ResourcePackageDetails> packages = new HashSet<ResourcePackageDetails>();
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String fullFileName = pluginConfiguration.getSimpleValue(PROPERTY_FILENAME, null);
        if (fullFileName == null) {
            throw new IllegalStateException("Plugin configuration does not contain the full file name of the WAR file.");
        }
        File file = new File(fullFileName);
        if (file.exists()) {
            String fileName = new File(fullFileName).getName();
            PackageVersions versions = this.loadApplicationVersions();
            String version = versions.getVersion(fileName);
            if (null == version) {
                JarContentFileInfo info = new JarContentFileInfo(file);
                version = info.getVersion("1.0");
                versions.putVersion(fileName, version);
                versions.saveToDisk();
            }
            PackageDetailsKey key = new PackageDetailsKey(fileName, version, PKG_TYPE_FILE, ARCHITECTURE);
            ResourcePackageDetails details = new ResourcePackageDetails(key);
            details.setFileName(fileName);
            details.setLocation(file.getPath());
            if (!file.isDirectory()) {
                details.setFileSize(Long.valueOf(file.length()));
            }
            details.setFileCreatedDate(null);
            packages.add(details);
        }
        return packages;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        throw new UnsupportedOperationException("Cannot remove the package backing a WAR resource.");
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        File packageFile = new File(packageDetails.getName());
        try {
            File fileToSend;
            if (packageFile.isDirectory()) {
                fileToSend = File.createTempFile("jopr-tomcat", ".zip");
                ZipUtil.zipFileOrDirectory((File)packageFile, (File)fileToSend);
            } else {
                fileToSend = packageFile;
            }
            return new BufferedInputStream(new FileInputStream(fileToSend));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve package bits for " + packageDetails, e);
        }
    }

    private DeployPackagesResponse failApplicationDeployment(String errorMessage, ResourcePackageDetails packageDetails) {
        DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
        DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(packageDetails.getKey(), ContentResponseResult.FAILURE);
        packageResponse.setErrorMessage(errorMessage);
        response.addPackageResponse(packageResponse);
        return response;
    }

    private void persistApplicationVersion(ResourcePackageDetails packageDetails, File appFile) {
        String packageName = appFile.getName();
        PackageVersions versions = this.loadApplicationVersions();
        versions.putVersion(packageName, packageDetails.getVersion());
    }

    private void deleteBackupOfOriginalFile(File backupOfOriginalFile) {
        try {
            FileUtils.purge((File)backupOfOriginalFile, (boolean)true);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to delete backup of original file: " + backupOfOriginalFile));
        }
    }

    public TomcatVHostComponent getParentResourceComponent() {
        return (TomcatVHostComponent)this.getResourceContext().getParentResourceComponent();
    }

    private PackageVersions loadApplicationVersions() {
        if (this.versions == null) {
            ResourceType resourceType = this.getResourceContext().getResourceType();
            String pluginName = resourceType.getPlugin();
            File dataDirectoryFile = this.getResourceContext().getDataDirectory();
            if (!dataDirectoryFile.exists()) {
                dataDirectoryFile.mkdir();
            }
            String dataDirectory = dataDirectoryFile.getAbsolutePath();
            this.log.debug((Object)("Creating application versions store with plugin name [" + pluginName + "] and data directory [" + dataDirectory + "]"));
            this.versions = new PackageVersions(pluginName, dataDirectory);
            this.versions.loadFromDisk();
        }
        return this.versions;
    }

    public void deleteResource() throws Exception {
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String fullFileName = pluginConfiguration.getSimple(PROPERTY_FILENAME).getStringValue();
        File file = new File(fullFileName);
        if (!file.exists()) {
            this.log.warn((Object)("Could not delete web application files (perhaps removed manually?). Proceeding with resource removal for: " + fullFileName));
        } else {
            this.deleteApp(pluginConfiguration, file, false);
        }
    }

    /*
     * Loose catch block
     */
    private File deleteApp(Configuration pluginConfiguration, File appFile, boolean keepBackup) throws Exception {
        File associatedWarFile2222;
        String contextRoot;
        File backupFile;
        block21: {
            backupFile = null;
            contextRoot = pluginConfiguration.getSimple(PROPERTY_CONTEXT_ROOT).getStringValue();
            this.invokeOperation("stop", null);
            this.getParentResourceComponent().undeployWar(contextRoot);
            if (keepBackup) {
                try {
                    backupFile = this.backupAppBitsToTempFile(appFile);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to create backup while deleting app " + appFile.getPath()));
                }
            }
            Object var8_9 = null;
            associatedWarFile2222 = null;
            if (!appFile.isDirectory()) break block21;
            associatedWarFile2222 = new File(appFile.getAbsolutePath() + ".war");
        }
        try {
            if (null != associatedWarFile2222 && associatedWarFile2222.exists()) {
                FileUtils.purge((File)associatedWarFile2222, (boolean)true);
            }
        }
        catch (IOException e2) {
            this.log.warn((Object)("Failed to delete file [" + associatedWarFile2222 + "]."), (Throwable)e2);
        }
        try {
            FileUtils.purge((File)appFile, (boolean)true);
        }
        catch (IOException e2) {
            this.log.error((Object)("Failed to delete file [" + appFile + "]."), (Throwable)e2);
            throw e2;
        }
        {
            catch (TomcatApplicationDeployer.DeployerException e) {
                this.log.warn((Object)("Failed to undeploy WAR (may have been undeployed manually). Proceeding with resource delete for  [" + contextRoot + "]."), (Throwable)e);
                Object var8_10 = null;
                File associatedWarFile2222 = null;
                if (appFile.isDirectory()) {
                    associatedWarFile2222 = new File(appFile.getAbsolutePath() + ".war");
                }
                try {
                    if (null != associatedWarFile2222 && associatedWarFile2222.exists()) {
                        FileUtils.purge((File)associatedWarFile2222, (boolean)true);
                    }
                }
                catch (IOException e2) {
                    this.log.warn((Object)("Failed to delete file [" + associatedWarFile2222 + "]."), (Throwable)e2);
                }
                try {
                    FileUtils.purge((File)appFile, (boolean)true);
                }
                catch (IOException e2) {
                    this.log.error((Object)("Failed to delete file [" + appFile + "]."), (Throwable)e2);
                    throw e2;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to undeploy WAR [" + contextRoot + "]."), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            File associatedWarFile2222 = null;
            if (appFile.isDirectory()) {
                associatedWarFile2222 = new File(appFile.getAbsolutePath() + ".war");
            }
            try {
                if (null != associatedWarFile2222 && associatedWarFile2222.exists()) {
                    FileUtils.purge((File)associatedWarFile2222, (boolean)true);
                }
            }
            catch (IOException e2) {
                this.log.warn((Object)("Failed to delete file [" + associatedWarFile2222 + "]."), (Throwable)e2);
            }
            try {
                FileUtils.purge((File)appFile, (boolean)true);
            }
            catch (IOException e2) {
                this.log.error((Object)("Failed to delete file [" + appFile + "]."), (Throwable)e2);
                throw e2;
            }
            throw throwable;
        }
        return backupFile;
    }

    private static interface WarMBeanState {
        public static final int STOPPED = 0;
        public static final int STARTED = 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WarOperation {
        START,
        STOP,
        RELOAD;

    }
}

