/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatVHostComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatWarDiscoveryComponent
extends MBeanResourceDiscoveryComponent<TomcatVHostComponent> {
    public static final String PLUGIN_CONFIG_NAME = "name";
    private static final List<String> EMS_ATTRIBUTE_DOC_BASE = Arrays.asList("docBase");
    private static final List<String> EMS_ATTRIBUTE_PATH = Arrays.asList("path");
    private static final Pattern PATTERN_NAME = Pattern.compile("//(.*)(/.*)");
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<TomcatVHostComponent> context) {
        TomcatVHostComponent parentComponent;
        Set resources = super.discoverResources(context);
        HashSet<DiscoveredResourceDetails> result = new HashSet<DiscoveredResourceDetails>();
        TomcatVHostComponent applicationServerComponent = parentComponent = (TomcatVHostComponent)context.getParentResourceComponent();
        String deployDirectoryPath = applicationServerComponent.getConfigurationPath().getPath();
        String parentHost = parentComponent.getName();
        Matcher m = PATTERN_NAME.matcher("");
        for (DiscoveredResourceDetails resource : resources) {
            Configuration pluginConfiguration = resource.getPluginConfiguration();
            String name = pluginConfiguration.getSimpleValue(PLUGIN_CONFIG_NAME, "");
            m.reset(name);
            if (m.matches()) {
                String host = m.group(1);
                if (!host.equalsIgnoreCase(parentHost)) continue;
                EmsConnection connection = ((TomcatVHostComponent)context.getParentResourceComponent()).getEmsConnection();
                EmsBean warBean = connection.getBean(resource.getResourceKey());
                String contextRoot = (String)((EmsAttribute)warBean.refreshAttributes(EMS_ATTRIBUTE_PATH).get(0)).getValue();
                String docBase = (String)((EmsAttribute)warBean.refreshAttributes(EMS_ATTRIBUTE_DOC_BASE).get(0)).getValue();
                File docBaseFile = new File(docBase);
                String filename = docBaseFile.isAbsolute() ? docBase : deployDirectoryPath + File.separator + docBase;
                try {
                    filename = new File(filename).getCanonicalPath();
                }
                catch (IOException e) {
                    this.log.warn((Object)("Unexpected discovered web application path: " + filename));
                }
                pluginConfiguration.put((Property)new PropertySimple("vHost", (Object)host));
                pluginConfiguration.put((Property)new PropertySimple("contextRoot", (Object)contextRoot));
                pluginConfiguration.put((Property)new PropertySimple("filename", (Object)filename));
                pluginConfiguration.put((Property)new PropertySimple("responseTimeLogFile", (Object)this.getResponseTimeLogFile(parentComponent.getInstallationPath(), host, contextRoot)));
                resource.setResourceName(resource.getResourceName().replace("{contextRoot}", "".equals(contextRoot) ? docBase : contextRoot));
                result.add(resource);
                continue;
            }
            this.log.warn((Object)("Skipping discovered web application with unexpected name: " + name));
        }
        return result;
    }

    private Set<DiscoveredResourceDetails> discoverFileSystem(ResourceDiscoveryContext<TomcatVHostComponent> context) {
        TomcatVHostComponent parentComponent;
        Configuration defaultConfiguration = context.getDefaultPluginConfiguration();
        TomcatVHostComponent applicationServerComponent = parentComponent = (TomcatVHostComponent)context.getParentResourceComponent();
        String deployDirectoryPath = applicationServerComponent.getConfigurationPath().getPath();
        File deployDirectory = new File(deployDirectoryPath);
        String extension = defaultConfiguration.getSimple("extension").getStringValue();
        ApplicationFileFilter filter = new ApplicationFileFilter(extension);
        File[] files = deployDirectory.listFiles(filter);
        ResourceType resourceType = context.getResourceType();
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>(files.length);
        for (File file : files) {
            String resourceKey;
            String objectName = resourceKey = this.determineResourceKey(defaultConfiguration, file.getName());
            String resourceName = file.getName();
            String description = defaultConfiguration.getSimple("descriptionTemplate").getStringValue();
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, "", description, null, null);
            Configuration resourcePluginConfiguration = resource.getPluginConfiguration();
            resourcePluginConfiguration.put((Property)new PropertySimple(PLUGIN_CONFIG_NAME, (Object)resourceName));
            resourcePluginConfiguration.put((Property)new PropertySimple("objectName", (Object)objectName));
            resourcePluginConfiguration.put((Property)new PropertySimple("filename", (Object)file.getAbsolutePath()));
            resources.add(resource);
        }
        return resources;
    }

    private String determineResourceKey(Configuration defaultConfiguration, String fileName) {
        String template = defaultConfiguration.getSimple("objectName").getStringValue();
        String resourceKey = template.replaceAll("%name%", fileName);
        return resourceKey;
    }

    private String getResponseTimeLogFile(File installPath, String vHost, String contextRoot) {
        String result;
        File logsDir = new File(installPath, "logs/rt");
        String rtLogFileName = (this.isLocalhost(vHost) ? "" : vHost) + (this.isRoot(contextRoot) ? "/ROOT" : contextRoot) + RT_LOG_FILE_NAME_SUFFIX;
        rtLogFileName = rtLogFileName.substring(1);
        rtLogFileName = rtLogFileName.replace('/', '_');
        File rtLogFile = new File(logsDir, rtLogFileName);
        try {
            result = rtLogFile.getCanonicalPath();
        }
        catch (IOException e) {
            result = rtLogFile.getPath();
        }
        return result;
    }

    private boolean isLocalhost(String vHost) {
        return "localhost".equals(vHost) || "127.0.0.1".equals(vHost);
    }

    private boolean isRoot(String contextRoot) {
        return "/".equals(contextRoot);
    }

    private static class ApplicationFileFilter
    implements FilenameFilter {
        private String applicationExtension;

        private ApplicationFileFilter(String applicationExtension) {
            this.applicationExtension = applicationExtension;
        }

        public boolean accept(File dir, String name) {
            boolean result = name.endsWith(this.applicationExtension);
            return result;
        }
    }
}

