/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat.helper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.helper.EmsUtility;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;

public class TomcatApplicationDeployer {
    public static final String DEPLOYER_BEAN = "Catalina:type=Deployer,host=localhost";
    private final Log log = LogFactory.getLog(this.getClass());
    private EmsOperation deployOperation;
    private EmsOperation undeployOperation;

    public TomcatApplicationDeployer(EmsConnection connection) throws NoSuchMethodException {
        EmsBean mainDeployer = connection.getBean(DEPLOYER_BEAN);
        if (mainDeployer == null) {
            throw new IllegalStateException("MBean named [Catalina:type=Deployer,host=localhost] does not exist.");
        }
        connection.getConnectionProvider().getConnectionSettings().getClassPathEntries();
        this.deployOperation = EmsUtility.getOperation(mainDeployer, "addServiced", String.class);
        this.undeployOperation = EmsUtility.getOperation(mainDeployer, "removeServiced", String.class);
    }

    public void deploy(String contextPath) throws DeployerException {
        this.log.debug((Object)("Servicing " + contextPath + "..."));
        try {
            this.deployOperation.invoke(new Object[]{contextPath});
        }
        catch (RuntimeException e) {
            throw new DeployerException("Failed to service " + contextPath, e);
        }
    }

    public void undeploy(String contextPath) throws DeployerException {
        this.log.debug((Object)("Undeploying " + contextPath + "..."));
        try {
            this.undeployOperation.invoke(new Object[]{contextPath});
        }
        catch (RuntimeException e) {
            throw new DeployerException("Failed to undeploy " + contextPath, e);
        }
    }

    public class DeployerException
    extends Exception {
        DeployerException(String message) {
            super(message);
        }

        DeployerException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

