/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatConnectorComponent
extends MBeanResourceComponent<TomcatServerComponent> {
    public static final String PLUGIN_CONFIG_ADDRESS = "address";
    public static final String PLUGIN_CONFIG_PORT = "port";
    public static final String PLUGIN_CONFIG_PROTOCOL = "protocol";
    public static final String PLUGIN_CONFIG_SCHEME = "scheme";
    public static final String UNKNOWN = "?";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public AvailabilityType getAvailability() {
        ObjectNameQueryUtility queryUtility;
        Configuration config = this.getResourceContext().getPluginConfiguration();
        String scheme = config.getSimpleValue(PLUGIN_CONFIG_SCHEME, "");
        String port = config.getSimpleValue(PLUGIN_CONFIG_PORT, "");
        String objectName = "Catalina:type=GlobalRequestProcessor,name=" + scheme + "-" + port;
        EmsConnection connection = this.getEmsConnection();
        List beans = connection.queryBeans((queryUtility = new ObjectNameQueryUtility(objectName)).getTranslatedQuery());
        return beans.isEmpty() ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    public void start(ResourceContext<TomcatServerComponent> context) {
        if (UNKNOWN.equals(context.getPluginConfiguration().getSimple(PLUGIN_CONFIG_SCHEME).getStringValue())) {
            throw new InvalidPluginConfigurationException("The connector is not listening for requests on the configured port. This is most likely due to the configured port being in use at Tomcat startup. In some cases (AJP connectors) Tomcat will assign an open port. This happens most often when there are multiple Tomcat servers running on the same platform. Check your Tomcat configurations for conflicts.");
        }
        super.start(context);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        this.getEmsConnection();
        for (MeasurementScheduleRequest request : requests) {
            String name = request.getName();
            name = this.getAttributeName(name);
            String beanName = name.substring(0, name.lastIndexOf(58));
            String attributeName = name.substring(name.lastIndexOf(58) + 1);
            try {
                EmsBean eBean = this.loadBean(beanName);
                if (eBean == null) {
                    this.log.warn((Object)("Bean " + beanName + " not found, skipping ..."));
                    continue;
                }
                EmsAttribute attribute = eBean.getAttribute(attributeName);
                Object valueObject = attribute.refresh();
                Number value = (Number)valueObject;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(value.doubleValue())));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to obtain measurement [" + name + "]"), (Throwable)e);
            }
        }
    }

    protected String getAttributeName(String property) {
        String theProperty = property;
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String address = pluginConfiguration.getSimple(PLUGIN_CONFIG_ADDRESS).getStringValue();
        String port = pluginConfiguration.getSimple(PLUGIN_CONFIG_PORT).getStringValue();
        String scheme = pluginConfiguration.getSimple(PLUGIN_CONFIG_SCHEME).getStringValue();
        theProperty = theProperty.replace("%address%", address);
        theProperty = theProperty.replace("%port%", port);
        theProperty = theProperty.replace("%scheme%", scheme);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finding metrics for: " + theProperty));
        }
        return theProperty;
    }
}

