/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.jboss.on.plugins.tomcat.TomcatServerOperationsDelegate;
import org.jboss.on.plugins.tomcat.helper.TomcatConfig;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.PlatformComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDiscoveryComponent
implements ResourceDiscoveryComponent<PlatformComponent> {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String UNKNOWN_PORT = "Unknown Port";
    public static final String UNKNOWN_VERSION = "Unknown Version";
    public static final String PROPERTY_CATALINA_BASE = "-Dcatalina.base=";
    public static final String PROPERTY_CATALINA_HOME = "-Dcatalina.home=";
    private static final String PRODUCT_NAME_EWS = "Tomcat";
    private static final String PRODUCT_NAME_APACHE = "Tomcat";
    private static final String PRODUCT_DESCRIPTION_EWS = "Tomcat Web Application Server";
    private static final String PRODUCT_DESCRIPTION_APACHE = "Tomcat Web Application Server";
    private static final Pattern TOMCAT_5_5_AND_LATER_VERSION_PATTERN = Pattern.compile(".*Server number:.*");
    private static final Pattern TOMCAT_5_0_AND_EARLIER_VERSION_PATTERN = Pattern.compile(".*Version:.*");
    private static final Pattern TOMCAT_MANAGER_URL_PATTERN = Pattern.compile(".*//(.*):(\\d+)/.*");
    private static final Pattern EWS_RPM_INSTALL_PATTERN = Pattern.compile("tomcat[5\\-5|6\\-6].*\\.ep5\\.*");
    private static final Pattern EWS_ZIP_INSTALL_PATTERN = Pattern.compile(".*ews.*tomcat[5-9]");
    public static final String EWS_TOMCAT_6 = "tomcat6";
    public static final String EWS_TOMCAT_5 = "tomcat5";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PlatformComponent> context) {
        this.log.debug((Object)"Discovering Tomcat servers...");
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult autoDiscoveryResult : autoDiscoveryResults) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Discovered potential Tomcat process: " + autoDiscoveryResult));
            }
            try {
                DiscoveredResourceDetails resource = this.parseTomcatProcess(context, autoDiscoveryResult);
                if (resource == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Verified Tomcat process: " + autoDiscoveryResult));
                }
                resources.add(resource);
            }
            catch (Exception e) {
                this.log.error((Object)("Error creating discovered resource for process: " + autoDiscoveryResult), (Throwable)e);
            }
        }
        List contextPluginConfigurations = context.getPluginConfigurations();
        for (Configuration pluginConfiguration : contextPluginConfigurations) {
            Object processInfo = null;
            DiscoveredResourceDetails resource = this.parsePluginConfig(context, pluginConfiguration);
            if (resource != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Verified Tomcat configuration: " + pluginConfiguration));
            }
            resources.add(resource);
        }
        return resources;
    }

    private DiscoveredResourceDetails parseTomcatProcess(ResourceDiscoveryContext<PlatformComponent> context, ProcessScanResult autoDiscoveryResult) {
        ProcessInfo processInfo = autoDiscoveryResult.getProcessInfo();
        Object[] commandLine = processInfo.getCommandLine();
        if (null == processInfo.getExecutable()) {
            this.log.debug((Object)("Ignoring Tomcat instance (agent may not be owner) with following command line: " + Arrays.toString(commandLine)));
            return null;
        }
        if (!this.isStandalone((String[])commandLine)) {
            this.log.debug((Object)("Ignoring embedded Tomcat instance with following command line: " + Arrays.toString(commandLine)));
            return null;
        }
        String installationPath = this.determineInstallationPath(processInfo);
        SystemInfo systemInfo = context.getSystemInformation();
        String hostname = systemInfo.getHostname();
        TomcatConfig tomcatConfig = this.parseTomcatConfig(installationPath);
        String resourceVersion = this.determineVersion(installationPath, systemInfo);
        boolean isEWS = TomcatDiscoveryComponent.isEWS(installationPath);
        String productName = isEWS ? "Tomcat" : "Tomcat";
        String productDescription = (isEWS ? "Tomcat Web Application Server" : "Tomcat Web Application Server") + (hostname == null ? "" : " (" + hostname + ")");
        String resourceName = productName + " (" + (tomcatConfig.getAddress() == null ? "" : tomcatConfig.getAddress() + ":") + tomcatConfig.getPort() + ")";
        String resourceKey = installationPath;
        Configuration pluginConfiguration = new Configuration();
        this.populatePluginConfiguration(pluginConfiguration, installationPath, (String[])commandLine);
        DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), resourceKey, resourceName, resourceVersion, productDescription, pluginConfiguration, processInfo);
        return resource;
    }

    private DiscoveredResourceDetails parsePluginConfig(ResourceDiscoveryContext<PlatformComponent> context, Configuration pluginConfiguration) {
        String installationPath = pluginConfiguration.getSimpleValue("installationPath", "invalid");
        File installDir = new File(installationPath);
        SystemInfo systemInfo = context.getSystemInformation();
        String hostname = systemInfo.getHostname();
        String version = UNKNOWN_VERSION;
        String port = UNKNOWN_PORT;
        String address = null;
        if (!installDir.isDirectory()) {
            this.log.info((Object)("Manually added Tomcat Server directory does not exist locally. Assuming remote Tomcat Server: " + installationPath));
            Matcher matcher = TOMCAT_MANAGER_URL_PATTERN.matcher(pluginConfiguration.getSimpleValue("connectorAddress", null));
            if (matcher.find()) {
                address = hostname = matcher.group(1);
                port = matcher.group(2);
            }
        } else {
            TomcatConfig tomcatConfig = this.parseTomcatConfig(installationPath);
            version = this.determineVersion(installationPath, systemInfo);
            address = tomcatConfig.getAddress();
            hostname = systemInfo.getHostname();
            port = tomcatConfig.getPort();
        }
        boolean isEWS = TomcatDiscoveryComponent.isEWS(installationPath);
        String productName = isEWS ? "Tomcat" : "Tomcat";
        String productDescription = (isEWS ? "Tomcat Web Application Server" : "Tomcat Web Application Server") + (hostname == null ? "" : " (" + hostname + ")");
        String resourceName = productName + " (" + (address == null ? "" : address + ":") + port + ")";
        String resourceKey = installationPath;
        this.populatePluginConfiguration(pluginConfiguration, installationPath, null);
        DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), resourceKey, resourceName, version, productDescription, pluginConfiguration, null);
        return resource;
    }

    private boolean isStandalone(String[] commandLine) {
        for (String item : commandLine) {
            if (!item.contains("catalina.home")) continue;
            return true;
        }
        return false;
    }

    private static boolean isEWS(String installationPath) {
        boolean isEws;
        boolean bl = isEws = null != installationPath && EWS_ZIP_INSTALL_PATTERN.matcher(installationPath.toLowerCase()).matches();
        if (!isEws) {
            // empty if block
        }
        return isEws;
    }

    public static boolean isEWSTomcat5(String installationPath) {
        return null != installationPath && installationPath.endsWith(EWS_TOMCAT_5);
    }

    public static boolean isEWSTomcat6(String installationPath) {
        return null != installationPath && installationPath.endsWith(EWS_TOMCAT_6);
    }

    private String determineInstallationPath(ProcessInfo processInfo) {
        String cwdPath = null;
        String result = null;
        if (null != processInfo.getExecutable() && (cwdPath = processInfo.getCurrentWorkingDirectory()).endsWith("bin")) {
            result = new File(cwdPath).getParent();
        }
        if (null == result) {
            result = this.determineInstallationPath(processInfo.getCommandLine());
        }
        return result;
    }

    private String determineInstallationPath(String[] cmdLine) {
        String result = null;
        for (int i = 0; i < cmdLine.length; ++i) {
            String line = cmdLine[i];
            if (line.startsWith(PROPERTY_CATALINA_HOME)) {
                result = line.substring(PROPERTY_CATALINA_HOME.length());
                break;
            }
            if (!line.startsWith(PROPERTY_CATALINA_BASE)) continue;
            result = line.substring(PROPERTY_CATALINA_BASE.length());
            break;
        }
        if (null != result) {
            try {
                result = new File(result).getCanonicalPath();
            }
            catch (IOException e) {
                this.log.warn((Object)("Unexpected standalone Tomcat installation path: " + result));
            }
        }
        return result;
    }

    private TomcatConfig parseTomcatConfig(String installationPath) {
        String configFileName = installationPath + File.separator + "conf" + File.separator + "server.xml";
        File configFile = new File(configFileName);
        TomcatConfig config = TomcatConfig.getConfig(configFile);
        return config;
    }

    private String determineVersion(String installationPath, SystemInfo systemInfo) {
        boolean isNix = File.separatorChar == '/';
        String versionScriptFileName = installationPath + File.separator + "bin" + File.separator + "version." + (isNix ? "sh" : "bat");
        File versionScriptFile = new File(versionScriptFileName);
        if (!versionScriptFile.exists()) {
            this.log.warn((Object)("Version script file not found in expected location: " + versionScriptFile));
            return UNKNOWN_VERSION;
        }
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((File)versionScriptFile);
        TomcatServerOperationsDelegate.setProcessExecutionEnvironment(processExecution, installationPath);
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(5000L);
        processExecution.setKillOnTimeout(true);
        ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
        String versionOutput = results.getCapturedOutput();
        String version = this.getVersionFromVersionScriptOutput(versionOutput);
        if (UNKNOWN_VERSION.equals(version)) {
            this.log.warn((Object)("Failed to determine Tomcat Server Version Given:\nVersionInfo:" + versionOutput + "\ninstallationPath: " + installationPath + "\nScript:" + versionScriptFileName + "\ntimeout=5000L"));
        }
        return version;
    }

    private String getVersionFromVersionScriptOutput(String versionOutput) {
        String version = UNKNOWN_VERSION;
        Matcher matcher = TOMCAT_5_5_AND_LATER_VERSION_PATTERN.matcher(versionOutput);
        if (matcher.find()) {
            String serverNumberString = matcher.group();
            String[] serverNumberParts = serverNumberString.split(":");
            version = serverNumberParts[1].trim();
        } else {
            matcher = TOMCAT_5_0_AND_EARLIER_VERSION_PATTERN.matcher(versionOutput);
            if (matcher.find()) {
                String serverNumberString = matcher.group();
                String[] serverNumberParts = serverNumberString.split("/");
                version = serverNumberParts[1].trim();
            }
        }
        return version;
    }

    private void populatePluginConfiguration(Configuration configuration, String installationPath, String[] commandLine) {
        String script;
        String scriptExtension;
        if (null == configuration.getSimpleValue("installationPath", null)) {
            configuration.put((Property)new PropertySimple("installationPath", (Object)installationPath));
        }
        String binPath = installationPath + File.separator + "bin" + File.separator;
        String string = scriptExtension = File.separatorChar == '/' ? ".sh" : ".bat";
        if (null == configuration.getSimpleValue("startScript", null)) {
            script = binPath + "startup" + scriptExtension;
            configuration.put((Property)new PropertySimple("startScript", (Object)script));
        }
        if (null == configuration.getSimpleValue("shutdownScript", null)) {
            script = binPath + "shutdown" + scriptExtension;
            configuration.put((Property)new PropertySimple("shutdownScript", (Object)script));
        }
        if (null == configuration.getSimpleValue("controlMethod", null)) {
            TomcatServerComponent.ControlMethod controlMethod = TomcatServerComponent.ControlMethod.SCRIPT;
            if (!new File(configuration.getSimpleValue("startScript", null)).exists() && (TomcatDiscoveryComponent.isEWSTomcat5(installationPath) || TomcatDiscoveryComponent.isEWSTomcat6(installationPath))) {
                controlMethod = TomcatServerComponent.ControlMethod.RPM;
            }
            configuration.put((Property)new PropertySimple("controlMethod", (Object)controlMethod.name()));
        }
        this.populateJMXConfiguration(configuration, commandLine);
    }

    private void populateJMXConfiguration(Configuration configuration, String[] commandLine) {
        if (null == commandLine) {
            return;
        }
        String portProp = "com.sun.management.jmxremote.port";
        String port = null;
        for (String argument : commandLine) {
            String cmdLineArg = "-D" + portProp + "=";
            if (!argument.startsWith(cmdLineArg)) continue;
            port = argument.substring(cmdLineArg.length());
            break;
        }
        configuration.put((Property)new PropertySimple("type", (Object)"org.mc4j.ems.connection.support.metadata.Tomcat55ConnectionTypeDescriptor"));
        if (null != port) {
            configuration.put((Property)new PropertySimple("connectorAddress", (Object)("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi")));
        }
    }
}

