/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.jboss.on.plugins.tomcat.TomcatServerOperationsDelegate;
import org.jboss.on.plugins.tomcat.helper.TomcatConfig;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;

public class TomcatDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String UNKNOWN_PORT = "Unknown Port";
    public static final String UNKNOWN_VERSION = "Unknown Version";
    public static final String PROPERTY_CATALINA_BASE = "-Dcatalina.base=";
    public static final String PROPERTY_CATALINA_HOME = "-Dcatalina.home=";
    private static final String PRODUCT_NAME = "Tomcat";
    private static final String PRODUCT_DESCRIPTION = "Tomcat Web Application Server";
    private static final Pattern TOMCAT_5_5_AND_LATER_VERSION_PATTERN = Pattern.compile(".*Server number:.*");
    private static final Pattern TOMCAT_5_0_AND_EARLIER_VERSION_PATTERN = Pattern.compile(".*Version:.*");
    private static final Pattern TOMCAT_MANAGER_URL_PATTERN = Pattern.compile(".*//(.*):(\\d+)/.*");
    private static final Pattern EWS_ZIP_INSTALL_PATTERN = Pattern.compile(".*ews.*tomcat[5-9]");
    public static final String EWS_TOMCAT_6 = "tomcat6";
    public static final String EWS_TOMCAT_5 = "tomcat5";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        this.log.debug((Object)"Discovering Tomcat servers...");
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult autoDiscoveryResult : autoDiscoveryResults) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Discovered potential Tomcat process: " + autoDiscoveryResult));
            }
            try {
                DiscoveredResourceDetails resource = this.parseTomcatProcess(context, autoDiscoveryResult);
                if (resource == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Verified Tomcat process: " + autoDiscoveryResult));
                }
                resources.add(resource);
            }
            catch (Exception e) {
                this.log.error((Object)("Error creating discovered resource for process: " + autoDiscoveryResult), (Throwable)e);
            }
        }
        return resources;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException {
        String catalinaHome = pluginConfig.getSimple("installationPath").getStringValue();
        try {
            catalinaHome = FileUtils.getCanonicalPath((String)catalinaHome);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to canonicalize catalina.home path [" + catalinaHome + "] - cause: " + e));
        }
        File catalinaHomeDir = new File(catalinaHome);
        String catalinaBase = pluginConfig.getSimple("catalinaBase").getStringValue();
        try {
            catalinaBase = FileUtils.getCanonicalPath((String)catalinaBase);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to canonicalize catalina.base path [" + catalinaBase + "] - cause: " + e));
        }
        SystemInfo systemInfo = discoveryContext.getSystemInformation();
        String hostname = systemInfo.getHostname();
        String version = UNKNOWN_VERSION;
        String port = UNKNOWN_PORT;
        String address = null;
        if (!catalinaHomeDir.isDirectory()) {
            this.log.info((Object)("Manually added Tomcat Server directory does not exist locally. Assuming remote Tomcat Server: " + catalinaHome));
            Matcher matcher = TOMCAT_MANAGER_URL_PATTERN.matcher(pluginConfig.getSimpleValue("connectorAddress", null));
            if (matcher.find()) {
                address = hostname = matcher.group(1);
                port = matcher.group(2);
            }
        } else {
            TomcatConfig tomcatConfig = this.parseTomcatConfig(catalinaBase);
            version = this.determineVersion(catalinaHome, catalinaBase, systemInfo);
            address = tomcatConfig.getAddress() != null ? tomcatConfig.getAddress() : hostname;
            if (tomcatConfig.getPort() != null) {
                port = tomcatConfig.getPort();
            }
        }
        String productDescription = PRODUCT_DESCRIPTION + (hostname == null ? "" : " (" + hostname + ")");
        String resourceName = null;
        resourceName = address + (port == null ? "" : ":" + port);
        String resourceKey = catalinaBase;
        this.populatePluginConfiguration(pluginConfig, catalinaHome, catalinaBase, null);
        DiscoveredResourceDetails resource = new DiscoveredResourceDetails(discoveryContext.getResourceType(), resourceKey, resourceName, version, productDescription, pluginConfig, null);
        this.log.debug((Object)("Verified manually-added Tomcat Resource with plugin config: " + pluginConfig));
        return resource;
    }

    private DiscoveredResourceDetails parseTomcatProcess(ResourceDiscoveryContext context, ProcessScanResult autoDiscoveryResult) {
        ProcessInfo processInfo = autoDiscoveryResult.getProcessInfo();
        Object[] commandLine = processInfo.getCommandLine();
        if (null == processInfo.getExecutable()) {
            this.log.debug((Object)("Ignoring Tomcat instance (agent may not be owner) with following command line: " + Arrays.toString(commandLine)));
            return null;
        }
        if (!this.isStandalone((String[])commandLine) && !this.isWindows(context)) {
            this.log.debug((Object)("Ignoring embedded Tomcat instance (catalina.home not found) with following command line: " + Arrays.toString(commandLine)));
            return null;
        }
        String catalinaHome = this.determineCatalinaHome((String[])commandLine);
        if (catalinaHome == null && this.isWindows(context)) {
            this.log.debug((Object)"catalina.home not found. Checking to see if this is an EWS installation.");
            catalinaHome = this.determineCatalinaHomeOnWindows(processInfo);
        }
        if (null == catalinaHome) {
            this.log.error((Object)("Ignoring Tomcat instance due to invalid setting of catalina.home in command line: " + Arrays.toString(commandLine)));
            return null;
        }
        String catalinaBase = this.determineCatalinaBase((String[])commandLine, catalinaHome);
        if (null == catalinaBase) {
            this.log.error((Object)("Ignoring Tomcat instance due to invalid setting of catalina.base in command line: " + Arrays.toString(commandLine)));
            return null;
        }
        SystemInfo systemInfo = context.getSystemInformation();
        String hostname = systemInfo.getHostname();
        TomcatConfig tomcatConfig = this.parseTomcatConfig(catalinaBase);
        tomcatConfig = this.applySystemProperties(tomcatConfig, (String[])commandLine);
        String resourceVersion = this.determineVersion(catalinaHome, catalinaBase, systemInfo);
        String productName = PRODUCT_NAME;
        String productDescription = PRODUCT_DESCRIPTION + (hostname == null ? "" : " (" + hostname + ")");
        String resourceName = productName + " (" + (tomcatConfig.getAddress() == null ? "" : tomcatConfig.getAddress() + ":") + tomcatConfig.getPort() + ")";
        String resourceKey = catalinaBase;
        Configuration pluginConfiguration = new Configuration();
        this.populatePluginConfiguration(pluginConfiguration, catalinaHome, catalinaBase, (String[])commandLine);
        DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), resourceKey, resourceName, resourceVersion, productDescription, pluginConfiguration, processInfo);
        return resource;
    }

    private boolean isWindows(ResourceDiscoveryContext context) {
        return context.getSystemInformation().getOperatingSystemType() == OperatingSystemType.WINDOWS;
    }

    private boolean isStandalone(String[] commandLine) {
        for (String item : commandLine) {
            if (!item.toLowerCase().contains("catalina.home")) continue;
            return true;
        }
        return false;
    }

    private String determineCatalinaHome(String[] cmdLine) {
        String result = null;
        for (int i = 0; i < cmdLine.length; ++i) {
            String line = cmdLine[i];
            if (!line.startsWith(PROPERTY_CATALINA_HOME)) continue;
            result = line.substring(PROPERTY_CATALINA_HOME.length());
            break;
        }
        if (null != result) {
            try {
                result = FileUtils.getCanonicalPath(result);
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    private String determineCatalinaHomeOnWindows(ProcessInfo processInfo) {
        File exePath = new File(processInfo.getName());
        File parentDir = exePath.getParentFile();
        File ewsDir = parentDir.getParentFile();
        File tomcatDir = new File(ewsDir, "share/apache-tomcat-6.0.24");
        if (tomcatDir.exists()) {
            this.log.debug((Object)("Detected EWS installation. catalina.home found at " + tomcatDir.getAbsolutePath()));
            return tomcatDir.getAbsolutePath();
        }
        return null;
    }

    private String determineCatalinaBase(String[] cmdLine, String catalinaHome) {
        String result = null;
        for (int i = 0; i < cmdLine.length; ++i) {
            String line = cmdLine[i];
            if (!line.startsWith(PROPERTY_CATALINA_BASE)) continue;
            result = line.substring(PROPERTY_CATALINA_BASE.length());
            break;
        }
        if (null == result) {
            result = catalinaHome;
        } else {
            try {
                result = FileUtils.getCanonicalPath((String)result);
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    private TomcatConfig parseTomcatConfig(String catalinaBase) {
        String configFileName = catalinaBase + File.separator + "conf" + File.separator + "server.xml";
        File configFile = new File(configFileName);
        TomcatConfig config = TomcatConfig.getConfig(configFile);
        return config;
    }

    private String determineVersion(String catalinaHome, String catalinaBase, SystemInfo systemInfo) {
        boolean isNix = File.separatorChar == '/';
        String versionScriptFileName = catalinaHome + File.separator + "bin" + File.separator + "version." + (isNix ? "sh" : "bat");
        File versionScriptFile = new File(versionScriptFileName);
        if (!versionScriptFile.exists()) {
            this.log.warn((Object)("Version script file not found in expected location: " + versionScriptFile));
            return UNKNOWN_VERSION;
        }
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((File)versionScriptFile);
        TomcatServerOperationsDelegate.setProcessExecutionEnvironment(processExecution, catalinaHome, catalinaBase);
        long timeout = 10000L;
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(timeout);
        processExecution.setKillOnTimeout(true);
        ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
        String versionOutput = results.getCapturedOutput();
        String version = this.getVersionFromVersionScriptOutput(versionOutput);
        if (UNKNOWN_VERSION.equals(version)) {
            this.log.warn((Object)("Failed to determine Tomcat Server Version Given:\nVersionInfo:" + versionOutput + "\ncatalinaHome: " + catalinaHome + "\nScript:" + versionScriptFileName + "\ntimeout=" + timeout));
        }
        return version;
    }

    private String getVersionFromVersionScriptOutput(String versionOutput) {
        String version = UNKNOWN_VERSION;
        Matcher matcher = TOMCAT_5_5_AND_LATER_VERSION_PATTERN.matcher(versionOutput);
        if (matcher.find()) {
            String serverNumberString = matcher.group();
            String[] serverNumberParts = serverNumberString.split(":");
            version = serverNumberParts[1].trim();
        } else {
            matcher = TOMCAT_5_0_AND_EARLIER_VERSION_PATTERN.matcher(versionOutput);
            if (matcher.find()) {
                String serverNumberString = matcher.group();
                String[] serverNumberParts = serverNumberString.split("/");
                version = serverNumberParts[1].trim();
            }
        }
        return version;
    }

    private void populatePluginConfiguration(Configuration configuration, String catalinaHome, String catalinaBase, String[] commandLine) {
        String script;
        String scriptExtension;
        if (null == configuration.getSimpleValue("installationPath", null)) {
            configuration.put((Property)new PropertySimple("installationPath", (Object)catalinaHome));
        }
        if (null == configuration.getSimpleValue("catalinaBase", null)) {
            configuration.put((Property)new PropertySimple("catalinaBase", (Object)catalinaBase));
        }
        String binPath = catalinaHome + File.separator + "bin" + File.separator;
        String string = scriptExtension = File.separatorChar == '/' ? ".sh" : ".bat";
        if (null == configuration.getSimpleValue("startScript", null)) {
            script = binPath + "startup" + scriptExtension;
            configuration.put((Property)new PropertySimple("startScript", (Object)script));
        }
        if (null == configuration.getSimpleValue("shutdownScript", null)) {
            script = binPath + "shutdown" + scriptExtension;
            configuration.put((Property)new PropertySimple("shutdownScript", (Object)script));
        }
        if (null == configuration.getSimpleValue("controlMethod", null)) {
            TomcatServerComponent.ControlMethod controlMethod = TomcatServerComponent.ControlMethod.SCRIPT;
            if (!new File(configuration.getSimpleValue("startScript", null)).exists() && TomcatDiscoveryComponent.isEWS(catalinaHome)) {
                controlMethod = TomcatServerComponent.ControlMethod.RPM;
            }
            configuration.put((Property)new PropertySimple("controlMethod", (Object)controlMethod.name()));
        }
        this.populateJMXConfiguration(configuration, commandLine);
    }

    private static boolean isEWS(String catalinaHome) {
        boolean isEws;
        boolean bl = isEws = null != catalinaHome && EWS_ZIP_INSTALL_PATTERN.matcher(catalinaHome.toLowerCase()).matches();
        if (!isEws) {
            // empty if block
        }
        return isEws;
    }

    public static boolean isEWSTomcat5(String catalinaHome) {
        return TomcatDiscoveryComponent.isEWS(catalinaHome) && catalinaHome.endsWith(EWS_TOMCAT_5);
    }

    public static boolean isEWSTomcat6(String catalinaHome) {
        return TomcatDiscoveryComponent.isEWS(catalinaHome) && catalinaHome.endsWith(EWS_TOMCAT_6);
    }

    private void populateJMXConfiguration(Configuration configuration, String[] commandLine) {
        if (null == commandLine) {
            return;
        }
        String portProp = "com.sun.management.jmxremote.port";
        String port = null;
        for (String argument : commandLine) {
            String cmdLineArg = "-D" + portProp + "=";
            if (!argument.startsWith(cmdLineArg)) continue;
            port = argument.substring(cmdLineArg.length());
            break;
        }
        configuration.put((Property)new PropertySimple("type", (Object)"org.mc4j.ems.connection.support.metadata.Tomcat55ConnectionTypeDescriptor"));
        if (null != port) {
            configuration.put((Property)new PropertySimple("connectorAddress", (Object)("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi")));
        }
    }

    private TomcatConfig applySystemProperties(TomcatConfig config, String[] commandLine) {
        String port = this.applySystemProperty(config.getPort(), commandLine);
        String address = this.applySystemProperty(config.getAddress(), commandLine);
        return new TomcatConfig(port, address);
    }

    private String applySystemProperty(String variable, String[] commandLine) {
        if (variable != null && variable.startsWith("${") && variable.endsWith("}")) {
            String variableName = variable.substring(2, variable.length() - 1);
            String envVarDefine = "-D" + variableName + "=";
            for (String commandLineArg : commandLine) {
                if (!commandLineArg.startsWith(envVarDefine)) continue;
                return commandLineArg.substring(envVarDefine.length());
            }
        }
        return variable;
    }
}

