/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.util.Set;
import org.jboss.on.plugins.tomcat.TomcatWarComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

public class TomcatDatasourceDiscoveryComponent
extends MBeanResourceDiscoveryComponent<TomcatWarComponent> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<TomcatWarComponent> discoveryContext) {
        String objectNameTemplate = "";
        Configuration defaultPluginConfig = discoveryContext.getDefaultPluginConfiguration();
        String host = discoveryContext.getParentResourceContext().getPluginConfiguration().getSimpleValue("vHost", null);
        String path = discoveryContext.getParentResourceContext().getPluginConfiguration().getSimpleValue("contextRoot", null);
        objectNameTemplate = defaultPluginConfig.getSimple("objectName").getStringValue();
        objectNameTemplate = objectNameTemplate.replace("%host%", host);
        objectNameTemplate = objectNameTemplate.replace("%path%", path);
        defaultPluginConfig.put((Property)new PropertySimple("objectName", (Object)objectNameTemplate));
        Set resources = super.performDiscovery(defaultPluginConfig, (JMXComponent)discoveryContext.getParentResourceComponent(), discoveryContext.getResourceType());
        if (resources.size() == 0) {
            objectNameTemplate = this.getDatasourceObjectName();
            objectNameTemplate = objectNameTemplate.replace("%host%", host);
            objectNameTemplate = objectNameTemplate.replace("%path%", path);
            defaultPluginConfig.put((Property)new PropertySimple("objectName", (Object)objectNameTemplate));
            resources = super.performDiscovery(defaultPluginConfig, (JMXComponent)discoveryContext.getParentResourceComponent(), discoveryContext.getResourceType());
        }
        for (DiscoveredResourceDetails detail : resources) {
            Configuration pluginConfiguration = detail.getPluginConfiguration();
            pluginConfiguration.put((Property)new PropertySimple("host", (Object)host));
            pluginConfiguration.put((Property)new PropertySimple("path", (Object)path));
            String resourceName = detail.getResourceName();
            detail.setResourceName(resourceName);
        }
        return resources;
    }

    private String getDatasourceObjectName() {
        return "Catalina:type=DataSource,context=%path%,host=%host%,class=javax.sql.DataSource,name=%name%";
    }
}

