/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat.helper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.helper.EmsUtility;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;

public class TomcatApplicationDeployer {
    private final Log log = LogFactory.getLog(this.getClass());
    private EmsOperation deployOperation;
    private EmsOperation undeployOperation;

    public TomcatApplicationDeployer(EmsConnection connection, String vhostName) throws NoSuchMethodException {
        String deployerBean = this.getDeployerBeanName(vhostName);
        EmsBean mainDeployer = connection.getBean(deployerBean);
        if (mainDeployer == null) {
            throw new IllegalStateException("MBean named [" + deployerBean + "] does not exist.");
        }
        connection.getConnectionProvider().getConnectionSettings().getClassPathEntries();
        this.deployOperation = EmsUtility.getOperation(mainDeployer, "addServiced", String.class);
        this.undeployOperation = EmsUtility.getOperation(mainDeployer, "removeServiced", String.class);
    }

    private String getDeployerBeanName(String vhostName) {
        return "Catalina:type=Deployer,host=" + (null == vhostName ? "localhost" : vhostName);
    }

    public void deploy(String contextPath) throws DeployerException {
        this.log.debug((Object)("Servicing " + contextPath + "..."));
        try {
            this.deployOperation.invoke(new Object[]{contextPath});
        }
        catch (RuntimeException e) {
            throw new DeployerException("Failed to service " + contextPath, e);
        }
    }

    public void undeploy(String contextPath) throws DeployerException {
        this.log.debug((Object)("Undeploying " + contextPath + "..."));
        try {
            this.undeployOperation.invoke(new Object[]{contextPath});
        }
        catch (RuntimeException e) {
            throw new DeployerException("Failed to undeploy " + contextPath, e);
        }
    }

    public class DeployerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        DeployerException(String message) {
            super(message);
        }

        DeployerException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

