/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerOperationsDelegate;
import org.jetbrains.annotations.NotNull;
import org.mc4j.ems.connection.ConnectionFactory;
import org.mc4j.ems.connection.EmsConnectException;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.JMXComponent;

public class TomcatServerComponent<T extends ResourceComponent<?>>
implements JMXComponent<T>,
MeasurementFacet,
OperationFacet {
    public static final String PLUGIN_CONFIG_CONTROL_METHOD = "controlMethod";
    public static final String PLUGIN_CONFIG_CATALINA_HOME_PATH = "installationPath";
    public static final String PLUGIN_CONFIG_CATALINA_BASE_PATH = "catalinaBase";
    public static final String PLUGIN_CONFIG_SCRIPT_PREFIX = "scriptPrefix";
    public static final String PLUGIN_CONFIG_SHUTDOWN_SCRIPT = "shutdownScript";
    public static final String PLUGIN_CONFIG_START_SCRIPT = "startScript";
    public static final String START_WAIT_MAX_PROP = "startWaitMax";
    public static final String STOP_WAIT_MAX_PROP = "stopWaitMax";
    private Log log = LogFactory.getLog(this.getClass());
    private EmsConnection connection;
    private int consecutiveConnectionErrors;
    private TomcatServerOperationsDelegate operationsDelegate;
    private ResourceContext<T> resourceContext;

    public EmsConnection getEmsConnection() {
        EmsConnection emsConnection;
        block2: {
            emsConnection = null;
            try {
                emsConnection = this.loadConnection();
            }
            catch (Exception e) {
                if (!this.log.isTraceEnabled()) break block2;
                this.log.debug((Object)("Component attempting to access a connection that could not be loaded:" + e.getMessage()));
            }
        }
        return emsConnection;
    }

    private synchronized EmsConnection loadConnection() throws Exception {
        if (this.connection == null) {
            try {
                Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
                ConnectionSettings connectionSettings = new ConnectionSettings();
                String connectionTypeDescriptorClass = pluginConfig.getSimple("type").getStringValue();
                PropertySimple serverUrl = pluginConfig.getSimple("connectorAddress");
                connectionSettings.initializeConnectionType((ConnectionTypeDescriptor)Class.forName(connectionTypeDescriptorClass).newInstance());
                if (null != serverUrl) {
                    connectionSettings.setServerUrl(serverUrl.getStringValue());
                }
                connectionSettings.setPrincipal(pluginConfig.getSimpleValue("principal", null));
                connectionSettings.setCredentials(pluginConfig.getSimpleValue("credentials", null));
                if (connectionSettings.getAdvancedProperties() == null) {
                    connectionSettings.setAdvancedProperties(new Properties());
                }
                ConnectionFactory connectionFactory = new ConnectionFactory();
                String catalinaHome = pluginConfig.getSimpleValue(PLUGIN_CONFIG_CATALINA_HOME_PATH, null);
                File libDir = this.getLibDir(catalinaHome);
                if (libDir != null) {
                    connectionSettings.setLibraryURI(libDir.getAbsolutePath());
                    connectionFactory.discoverServerClasses(connectionSettings);
                    connectionSettings.getControlProperties().setProperty("mc4j.ems.CopyJarsToTemp", String.valueOf(Boolean.TRUE));
                    File tempDir = this.resourceContext.getTemporaryDirectory();
                    if (!tempDir.exists()) {
                        tempDir.mkdirs();
                    }
                    connectionSettings.getControlProperties().setProperty("mc4j.ems.JarTempDir", tempDir.getAbsolutePath());
                    this.log.info((Object)("Loading connection [" + connectionSettings.getServerUrl() + "] with install path [" + connectionSettings.getLibraryURI() + "] and temp directory [" + tempDir.getAbsolutePath() + "]"));
                } else {
                    this.log.info((Object)("Loading connection [" + connectionSettings.getServerUrl() + "] ignoring remote install path [" + catalinaHome + "]"));
                }
                ConnectionProvider connectionProvider = connectionFactory.getConnectionProvider(connectionSettings);
                this.connection = connectionProvider.connect();
                this.connection.loadSynchronous(false);
                this.consecutiveConnectionErrors = 0;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Successfully made connection to the Tomcat Server for resource [" + this.resourceContext.getResourceKey() + "]"));
                }
            }
            catch (Exception e) {
                if (this.connection != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Connection created but an exception was thrown. Closing the connection.", (Throwable)e);
                    }
                    try {
                        this.connection.close();
                    }
                    catch (Exception e2) {
                        this.log.error((Object)("Error closing Tomcat EMS connection: " + e2));
                    }
                    this.connection = null;
                }
                if (0 == this.consecutiveConnectionErrors) {
                    this.log.warn((Object)("Could not connect to the Tomcat instance for resource [" + this.resourceContext.getResourceKey() + "] (enable debug logging for more info): " + e.getMessage()));
                }
                if (this.log.isDebugEnabled() && this.consecutiveConnectionErrors % 10 == 0) {
                    this.log.debug((Object)("Could not establish connection to the Tomcat instance [" + (this.consecutiveConnectionErrors + 1) + "] times for resource [" + this.resourceContext.getResourceKey() + "]"), (Throwable)e);
                }
                ++this.consecutiveConnectionErrors;
                throw e;
            }
        }
        return this.connection;
    }

    private File getLibDir(String catalinaHome) {
        if (catalinaHome != null) {
            File libDir = new File(catalinaHome, "lib");
            if (libDir.isDirectory()) {
                return libDir;
            }
            libDir = new File(catalinaHome, "server" + File.separator + "lib");
            if (libDir.isDirectory()) {
                return libDir;
            }
        }
        return null;
    }

    public Configuration getPluginConfiguration() {
        return this.resourceContext.getPluginConfiguration();
    }

    private void validatePluginConfiguration() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String principal = pluginConfig.getSimpleValue("principal", null);
        String credentials = pluginConfig.getSimpleValue("credentials", null);
        if (principal != null && credentials == null) {
            throw new InvalidPluginConfigurationException("If the 'principal' connection property is set, the 'credentials' connection property must also be set.");
        }
        if (credentials != null && principal == null) {
            throw new InvalidPluginConfigurationException("If the 'credentials' connection property is set, the 'principal' connection property must also be set.");
        }
    }

    public void start(ResourceContext<T> context) throws InvalidPluginConfigurationException, Exception {
        block2: {
            this.resourceContext = context;
            this.operationsDelegate = new TomcatServerOperationsDelegate(this, this.resourceContext.getSystemInformation());
            this.validatePluginConfiguration();
            try {
                this.loadConnection();
            }
            catch (Exception e) {
                Throwable cause;
                if (!(e instanceof EmsConnectException) || !((cause = e.getCause()) instanceof SecurityException)) break block2;
                throw new InvalidPluginConfigurationException("Invalid JMX credentials specified for connecting to this server.", (Throwable)e);
            }
        }
    }

    public void stop() {
        this.closeConnection();
    }

    private synchronized void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                this.log.error((Object)("Error closing Tomcat EMS connection: " + e));
            }
            this.connection = null;
        }
    }

    public AvailabilityType getAvailability() {
        AvailabilityType avail;
        try {
            EmsConnection connection = this.loadConnection();
            EmsBean bean = connection.getBean("Catalina:type=Server");
            bean.getAttribute("serverInfo").refresh();
            avail = AvailabilityType.UP;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("An exception occurred during availability check for Tomcat Server Resource with key [" + this.getResourceContext().getResourceKey() + "] and plugin config [" + this.getPluginConfiguration().getAllProperties() + "]."), (Throwable)e);
            }
            this.closeConnection();
            avail = AvailabilityType.DOWN;
        }
        return avail;
    }

    ResourceContext<T> getResourceContext() {
        return this.resourceContext;
    }

    public File getStartScriptPath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String script = pluginConfig.getSimpleValue(PLUGIN_CONFIG_START_SCRIPT, "");
        File scriptFile = this.resolvePathRelativeToHomeDir(script);
        return scriptFile;
    }

    public File getCatalinaHome() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        return new File(pluginConfig.getSimpleValue(PLUGIN_CONFIG_CATALINA_HOME_PATH, ""));
    }

    public File getCatalinaBase() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String base = pluginConfig.getSimpleValue(PLUGIN_CONFIG_CATALINA_BASE_PATH, null);
        return null != base ? new File(base) : this.getCatalinaHome();
    }

    public File getShutdownScriptPath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String script = pluginConfig.getSimpleValue(PLUGIN_CONFIG_SHUTDOWN_SCRIPT, "");
        File scriptFile = this.resolvePathRelativeToHomeDir(script);
        return scriptFile;
    }

    private File resolvePathRelativeToHomeDir(@NotNull String path) {
        return TomcatServerComponent.resolvePathRelativeToHomeDir(this.resourceContext.getPluginConfiguration(), path);
    }

    static File resolvePathRelativeToHomeDir(Configuration pluginConfig, String path) {
        File configDir = new File(path);
        if (!configDir.isAbsolute()) {
            String jbossHomeDir = TomcatServerComponent.getRequiredPropertyValue(pluginConfig, PLUGIN_CONFIG_CATALINA_HOME_PATH);
            configDir = new File(jbossHomeDir, path);
        }
        return configDir;
    }

    private static String getRequiredPropertyValue(Configuration config, String propName) {
        String propValue = config.getSimpleValue(propName, null);
        if (propValue == null) {
            throw new IllegalStateException("Required property '" + propName + "' is not set.");
        }
        return propValue;
    }

    void storeConfig() throws Exception {
        this.invokeOperation(SupportedOperations.STORECONFIG.name(), new Configuration());
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        SupportedOperations operation = Enum.valueOf(SupportedOperations.class, name.toUpperCase());
        this.addScriptsEnvironment(parameters);
        return this.operationsDelegate.invoke(operation, parameters);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest schedule : metrics) {
            String name = schedule.getName();
            int delimIndex = name.lastIndexOf(58);
            String beanName = name.substring(0, delimIndex);
            String attributeName = name.substring(delimIndex + 1);
            try {
                EmsConnection emsConnection = this.loadConnection();
                EmsBean bean = emsConnection.getBean(beanName);
                EmsAttribute attribute = bean.getAttribute(attributeName);
                Object valueObject = attribute.refresh();
                if (valueObject instanceof Number) {
                    Number value = (Number)valueObject;
                    report.addData(new MeasurementDataNumeric(schedule, Double.valueOf(value.doubleValue())));
                    continue;
                }
                report.addData(new MeasurementDataTrait(schedule, valueObject.toString()));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to obtain measurement [" + name + "]"), (Throwable)e);
            }
        }
    }

    private void addScriptsEnvironment(Configuration operationParameters) {
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        PropertyList startScriptEnv = pluginConfiguration.getList("startScriptEnvironment");
        PropertyList shutdownScriptEnv = pluginConfiguration.getList("shutdownScriptEnvironment");
        if (startScriptEnv != null) {
            operationParameters.put((Property)startScriptEnv);
        }
        if (shutdownScriptEnv != null) {
            operationParameters.put((Property)shutdownScriptEnv);
        }
    }

    public static enum ControlMethod {
        RPM,
        SCRIPT;

    }

    public static enum SupportedOperations {
        RESTART,
        SHUTDOWN,
        START,
        STORECONFIG;

    }
}

