/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.perfrunner;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.runners.model.FrameworkMethod;

class ParameterizedFrameworkMethod
extends FrameworkMethod {
    private final Integer[] params;

    public ParameterizedFrameworkMethod(Method method, int[] params) {
        super(method);
        this.params = new Integer[params.length];
        int i = 0;
        while (i < params.length) {
            this.params[i] = params[i];
            ++i;
        }
    }

    public Object invokeExplosively(Object target, Object ... ignored) throws Throwable {
        return super.invokeExplosively(target, (Object[])this.params);
    }

    public Integer[] getParameters() {
        return this.params;
    }

    public String toString() {
        return String.format("ParameterizedFrameworkMethod@%8x: %s", System.identityHashCode((Object)this), Arrays.toString((Object[])this.params));
    }
}

