/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.perfrunner;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.perfrunner.Varying;
import org.junit.runner.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PerfRunDescription {
    private static final Pattern methodNameValuesPattern = Pattern.compile("(.*)\\[([0-9, .e+-]*)\\]");
    private static final Pattern methodValuePattern = Pattern.compile("[0-9.e+-]+");
    private final String className;
    private final String methodName;
    private final List<Double> paramValues;
    private final List<Varying> varyingAnnotations;

    public PerfRunDescription(Description d) {
        this.className = d.getClassName();
        Matcher m = methodNameValuesPattern.matcher(d.getMethodName());
        if (!m.matches()) {
            throw new AssertionError((Object)("Unrecognized method name+value syntax in test description '" + d.getMethodName() + "'"));
        }
        this.methodName = m.group(1);
        String values = m.group(2);
        Matcher vm = methodValuePattern.matcher(values);
        ArrayList<Double> valueList = new ArrayList<Double>();
        while (vm.find()) {
            valueList.add(Double.valueOf(vm.group()));
        }
        this.paramValues = Collections.unmodifiableList(valueList);
        ArrayList<Varying> varyingAnnotations = new ArrayList<Varying>();
        for (Annotation a : d.getAnnotations()) {
            if (!(a instanceof Varying)) continue;
            varyingAnnotations.add((Varying)a);
        }
        this.varyingAnnotations = Collections.unmodifiableList(varyingAnnotations);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<Double> getParamValues() {
        return this.paramValues;
    }

    public List<Varying> getParamAnnotations() {
        return this.varyingAnnotations;
    }
}

