/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.perfrunner;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.perfrunner.ParameterizedFrameworkMethod;
import org.jboss.perfrunner.PerformanceReportBuilder;
import org.jboss.perfrunner.Varying;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfRunner
extends Suite {
    public PerfRunner(Class<?> klass) throws Throwable {
        super(klass, PerfRunner.createParameterizedRunners(klass));
    }

    private static List<Runner> createParameterizedRunners(Class<?> klass) throws InitializationError {
        ArrayList<Runner> children = new ArrayList<Runner>();
        children.add((Runner)new VaryingParametersTestRunner(klass));
        return children;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VaryingParametersTestRunner
    extends BlockJUnit4ClassRunner {
        private final PerformanceReportBuilder performanceReportBuilder = new PerformanceReportBuilder();

        VaryingParametersTestRunner(Class<?> type) throws InitializationError {
            super(type);
        }

        protected List<FrameworkMethod> computeTestMethods() {
            ArrayList<FrameworkMethod> testMethods = new ArrayList<FrameworkMethod>();
            for (FrameworkMethod targetMethod : this.getTestClass().getAnnotatedMethods(Test.class)) {
                Method m = targetMethod.getMethod();
                int paramCount = m.getParameterTypes().length;
                int[][] values = new int[paramCount][];
                int p = 0;
                while (p < paramCount) {
                    Varying varying = this.getSoleVaryingAnnotation(targetMethod.getMethod(), p);
                    values[p] = this.valuesOf(varying);
                    ++p;
                }
                int[] pointers = new int[paramCount];
                do {
                    int[] params = new int[paramCount];
                    int i = 0;
                    while (i < paramCount) {
                        params[i] = values[i][pointers[i]];
                        ++i;
                    }
                    testMethods.add(new ParameterizedFrameworkMethod(m, params));
                } while (this.countUp(pointers, values));
            }
            return testMethods;
        }

        protected void validateTestMethods(List<Throwable> errors) {
            List methods = this.getTestClass().getAnnotatedMethods(Test.class);
            for (FrameworkMethod fm : methods) {
                fm.validatePublicVoid(false, errors);
                Method m = fm.getMethod();
                int p = 0;
                while (p < m.getParameterTypes().length) {
                    try {
                        Class<?> ptype = m.getParameterTypes()[p];
                        if (ptype != Integer.TYPE) {
                            throw new InitializationError("Method " + m.getName() + " parameter " + p + " is of type " + ptype + ", but only int is supported.");
                        }
                        Varying varying = this.getSoleVaryingAnnotation(m, p);
                        int[] values = this.valuesOf(varying);
                        if (values.length == 0) {
                            throw new InitializationError("Method " + m.getName() + " parameter " + p + " has 0 possible variations");
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    ++p;
                }
            }
        }

        protected Description describeChild(FrameworkMethod method) {
            ParameterizedFrameworkMethod pmethod = (ParameterizedFrameworkMethod)method;
            ArrayList annotations = new ArrayList();
            Collections.addAll(annotations, method.getAnnotations());
            Annotation[][] annotationArray = method.getMethod().getParameterAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation[] paramAnnotation = annotationArray[n2];
                Collections.addAll(annotations, paramAnnotation);
                ++n2;
            }
            return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)(String.valueOf(this.testName(method)) + Arrays.toString((Object[])pmethod.getParameters())), (Annotation[])annotations.toArray(new Annotation[annotations.size()]));
        }

        public void run(RunNotifier notifier) {
            Description description = this.getDescription();
            try {
                try {
                    this.performanceReportBuilder.testRunStarted(description);
                    super.run(notifier);
                }
                catch (IOException e) {
                    throw new RuntimeException("PerfRunner report generation failed", e);
                }
            }
            finally {
                this.performanceReportBuilder.testRunFinished(null);
            }
        }

        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
            Description description = this.describeChild(method);
            this.performanceReportBuilder.testStarted(description);
            super.runChild(method, notifier);
            this.performanceReportBuilder.testFinished(description);
        }

        private boolean countUp(int[] pointers, int[][] values) {
            boolean carry;
            if (pointers.length == 0) {
                return false;
            }
            int pos = 0;
            do {
                carry = false;
                int n = pos;
                pointers[n] = pointers[n] + 1;
                if (pointers[pos] < values[pos].length) continue;
                pointers[pos] = 0;
                ++pos;
                carry = true;
            } while (pos < pointers.length && carry);
            return !carry;
        }

        private int[] valuesOf(Varying varying) {
            if (varying.to() < varying.from()) {
                throw new IllegalArgumentException("Illegal varying parameters: to < from (from=" + varying.from() + ", to=" + varying.to() + ")");
            }
            if (varying.step() < 1) {
                throw new IllegalArgumentException("Illegal varying parameters: step < 1 (step=" + varying.step() + ")");
            }
            int valueCount = 0;
            int v = varying.from();
            while (v <= varying.to()) {
                ++valueCount;
                v += varying.step();
            }
            int vc = valueCount;
            int[] values = new int[vc];
            int v2 = varying.from();
            int i = 0;
            while (v2 <= varying.to()) {
                values[i] = v2;
                v2 += varying.step();
                ++i;
            }
            return values;
        }

        private Varying getSoleVaryingAnnotation(Method m, int p) {
            Varying foundIt = null;
            Annotation[] annotationArray = m.getParameterAnnotations()[p];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation atn = annotationArray[n2];
                if (atn.annotationType() == Varying.class) {
                    if (foundIt != null) {
                        throw new AssertionError((Object)("Method " + m.getName() + " parameter " + p + " has more than one @Varying annotation"));
                    }
                    foundIt = (Varying)atn;
                }
                ++n2;
            }
            if (foundIt != null) {
                return foundIt;
            }
            throw new AssertionError((Object)("Method " + m.getName() + " parameter " + p + " is missing its @Varying annotation"));
        }
    }
}

