/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.perfrunner;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.perfrunner.Axis;
import org.jboss.perfrunner.PerfRunDescription;
import org.jboss.perfrunner.RunStats;
import org.jboss.perfrunner.Varying;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

class PerformanceReportBuilder
extends RunListener {
    private PrintWriter out;
    private RunStats statsAtStart;
    private MethodRunData runData;
    private int chartNum;

    PerformanceReportBuilder() {
    }

    public void testRunStarted(Description description) throws IOException {
        this.out = new PrintWriter("perfrunner-" + description.getClassName() + ".html");
        this.out.println("<!DOCTYPE html>");
        this.out.println("<html>");
        this.out.println("<head>");
        this.out.println(" <title>" + description.getDisplayName() + "</title>");
        this.includeStylesheet(this.out);
        this.includeScripts(this.out);
        this.out.println("</head>");
        this.out.println("<body>");
        String title = description.getDisplayName();
        if (title.equals(description.getClassName())) {
            title = "<span class=packageName>" + description.getTestClass().getPackage().getName() + ".</span>" + description.getTestClass().getSimpleName();
        }
        this.out.println(" <h1>" + title + "</h1>");
        this.out.println(" <div class=testRunInfo>");
        this.out.println("  <p class=generatedBy>Generated by <a href='https://github.com/jfuerth/junit-4-perfrunner'>PerfRunner</a></p>");
        this.out.println("  <p class=generatedOn>On " + new Date() + "</p>");
        this.out.println(" </div>");
    }

    private void includeStylesheet(PrintWriter out) throws IOException {
        out.println(" <style>");
        PerformanceReportBuilder.printContents(out, ((Object)((Object)this)).getClass().getResource("html/perfrunner-style.css"));
        out.println(" </style>");
    }

    private void includeScripts(PrintWriter out) throws IOException {
        out.println(" <script type='text/javascript'>");
        PerformanceReportBuilder.printContents(out, ((Object)((Object)this)).getClass().getResource("html/jquery.js"));
        out.println(" </script>");
        out.println(" <script type='text/javascript'>");
        PerformanceReportBuilder.printContents(out, ((Object)((Object)this)).getClass().getResource("html/jquery.flot.js"));
        out.println(" </script>");
        out.println(" <script type='text/javascript'>");
        PerformanceReportBuilder.printContents(out, ((Object)((Object)this)).getClass().getResource("html/jquery.flot.hiddengraphs.js"));
        out.println(" </script>");
    }

    private static void printContents(Writer out, URL srcUrl) throws IOException {
        InputStreamReader in = new InputStreamReader(srcUrl.openStream());
        try {
            int len;
            char[] buf = new char[10000];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (IOException e) {
                System.err.println("Failed to close input stream. Squishing this exception:");
                e.printStackTrace();
            }
        }
    }

    public void testStarted(Description description) {
        this.statsAtStart = RunStats.create();
    }

    public void testFinished(Description description) {
        RunStats runStats = this.statsAtStart.relativeToNow();
        try {
            PerfRunDescription desc = new PerfRunDescription(description);
            if (this.runData == null) {
                this.runData = new MethodRunData(desc);
            } else if (!this.runData.isSameChart(desc)) {
                this.runData.appendJavascriptTo(this.out, this.chartNum++);
                this.runData = new MethodRunData(desc);
            }
            this.runData.addTestRunData(desc, runStats);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void testRunFinished(Result result) {
        if (this.runData != null) {
            try {
                this.runData.appendJavascriptTo(this.out, this.chartNum++);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.out.println("</body>");
        this.out.flush();
        this.out.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key {
        private final List<ParamValue> paramValues;

        public static Key create(PerfRunDescription desc, List<Integer> paramIndexes) {
            ArrayList<ParamValue> paramValues = new ArrayList<ParamValue>();
            for (int i : paramIndexes) {
                paramValues.add(new ParamValue(desc.getParamAnnotations().get(i).name(), desc.getParamValues().get(i)));
            }
            Key key = new Key(paramValues);
            return key;
        }

        public Key(List<ParamValue> paramValues) {
            this.paramValues = new ArrayList<ParamValue>(paramValues);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.paramValues == null ? 0 : this.paramValues.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return !(this.paramValues == null ? other.paramValues != null : !this.paramValues.equals(other.paramValues));
        }

        public String toString() {
            return this.paramValues.toString();
        }
    }

    private static class MethodRunData {
        private final Map<Key, Map<Key, Series>> pageSeriesMap = new LinkedHashMap<Key, Map<Key, Series>>();
        private final String className;
        private final String methodName;
        private int xAxisParam = -1;
        private List<Integer> pageAxisParams;
        private List<Integer> seriesParams;

        public MethodRunData(PerfRunDescription desc) {
            this.className = desc.getClassName();
            this.methodName = desc.getMethodName();
            ArrayList<Integer> pageAxisParams = new ArrayList<Integer>();
            ArrayList<Integer> seriesParams = new ArrayList<Integer>();
            int i = 0;
            while (i < desc.getParamAnnotations().size()) {
                Varying v = desc.getParamAnnotations().get(i);
                if (v.axis() == Axis.X) {
                    if (this.xAxisParam != -1) {
                        throw new IllegalStateException("Found more than one x-axis parameter for test " + desc.getClassName() + "." + desc.getMethodName());
                    }
                    this.xAxisParam = i;
                } else if (v.axis() == Axis.SERIES) {
                    seriesParams.add(i);
                } else if (v.axis() == Axis.PAGE) {
                    pageAxisParams.add(i);
                } else {
                    throw new AssertionError((Object)("Oops, unknown Axis type " + (Object)((Object)v.axis())));
                }
                ++i;
            }
            if (this.xAxisParam == -1) {
                throw new IllegalStateException("No x-axis parameter was specified for test " + desc.getClassName() + "." + desc.getMethodName());
            }
            this.pageAxisParams = Collections.unmodifiableList(pageAxisParams);
            this.seriesParams = Collections.unmodifiableList(seriesParams);
        }

        public boolean isSameChart(PerfRunDescription desc) {
            return desc.getClassName().equals(this.className) && desc.getMethodName().equals(this.methodName);
        }

        public void addTestRunData(PerfRunDescription desc, RunStats runStats) {
            Key seriesKey;
            Series s;
            if (!this.isSameChart(desc)) {
                throw new IllegalArgumentException("The given description is for data that doesn't belong on this chart");
            }
            Key pageKey = Key.create(desc, this.pageAxisParams);
            Map<Key, Series> seriesMap = this.pageSeriesMap.get(pageKey);
            if (seriesMap == null) {
                seriesMap = new LinkedHashMap<Key, Series>();
                this.pageSeriesMap.put(pageKey, seriesMap);
            }
            if ((s = seriesMap.get(seriesKey = Key.create(desc, this.seriesParams))) == null) {
                s = new Series(seriesKey);
                seriesMap.put(seriesKey, s);
            }
            s.addPoint(desc.getParamValues().get(this.xAxisParam), runStats);
        }

        public void appendJavascriptTo(Appendable sb, int chartNum) throws IOException {
            sb.append("\n<h2><span class=packageName>" + this.className + ".</span>" + this.methodName + "</h2>\n");
            for (Map.Entry<Key, Map<Key, Series>> e : this.pageSeriesMap.entrySet()) {
                Key pageKey = e.getKey();
                Map<Key, Series> series = e.getValue();
                if (pageKey.paramValues.size() > 0) {
                    sb.append("<h3>" + pageKey.toString() + "</h3>");
                }
                sb.append("<div class=chartStats id=chartStats" + chartNum + ">&nbsp;</div>\n");
                sb.append("<div class=chart id=chart" + chartNum + "></div>\n");
                sb.append("<div class=legend id=legend" + chartNum + "></div>\n");
                sb.append("<script type='text/javascript'>\n");
                sb.append("$(function() {\n");
                sb.append(" $.plot($('#chart" + chartNum + "'), ");
                sb.append("[");
                boolean first = true;
                for (Series s : series.values()) {
                    if (!first) {
                        sb.append(",");
                    }
                    s.appendTo(sb);
                    first = false;
                }
                sb.append("\n]\n");
                sb.append(", {\n");
                sb.append("    series: { points: {show: true}, lines: {show: true} },\n");
                sb.append("    legend: { hideable: true, container: '#legend" + chartNum + "', noColumns: 2 },\n");
                sb.append("    grid: { hoverable: true }\n");
                sb.append("  });\n");
                sb.append("  $('#chart" + chartNum + "').bind('plothover', function (event, pos, item) {\n");
                sb.append("    if (item) {\n");
                sb.append("      var runStats = item.series.data[item.dataIndex][2];\n");
                sb.append("      var statsHtml = '';\n");
                sb.append("      if (item.series.name) { statsHtml += '<span class=seriesName>' + item.series.name + '</span>:'; }\n");
                sb.append("      for (stat in runStats) { statsHtml += ' ' + stat + ': <span class=statValue>' + runStats[stat] + '</span>' }\n");
                sb.append("      $('#chartStats" + chartNum + "').html(statsHtml);\n");
                sb.append("    }\n");
                sb.append("  });\n");
                sb.append("});\n");
                sb.append("</script>\n");
                ++chartNum;
            }
        }
    }

    public static class ParamValue {
        private final String paramName;
        private final double paramValue;

        public ParamValue(String paramName, double paramValue) {
            this.paramName = paramName;
            this.paramValue = paramValue;
        }

        public String getParamName() {
            return this.paramName;
        }

        public double getParamValue() {
            return this.paramValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.paramName == null ? 0 : this.paramName.hashCode());
            long temp = Double.doubleToLongBits(this.paramValue);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParamValue other = (ParamValue)obj;
            if (this.paramName == null ? other.paramName != null : !this.paramName.equals(other.paramName)) {
                return false;
            }
            return Double.doubleToLongBits(this.paramValue) == Double.doubleToLongBits(other.paramValue);
        }

        public String toString() {
            return String.valueOf(this.paramName) + "=" + this.paramValue;
        }
    }

    private static class Point {
        private final double x;
        private final RunStats runStats;

        public Point(double x, RunStats runStats) {
            this.x = x;
            this.runStats = runStats;
        }

        public void appendTo(Appendable sb) throws IOException {
            sb.append("[").append(String.valueOf(this.x)).append(",").append(String.valueOf(this.runStats.timeMillis())).append(",");
            this.runStats.appendTo(sb);
            sb.append("]");
        }
    }

    private static class Series {
        private final Key key;
        private final List<Point> points = new ArrayList<Point>();

        public Series(Key key) {
            this.key = key;
        }

        public void addPoint(double x, RunStats runStats) {
            this.points.add(new Point(x, runStats));
        }

        public void appendTo(Appendable sb) throws IOException {
            sb.append("\n {");
            if (this.key.paramValues.size() > 0) {
                sb.append("label: \"").append(this.key.toString()).append("\", ");
            }
            sb.append("data: [");
            boolean first = true;
            for (Point p : this.points) {
                if (!first) {
                    sb.append(",");
                }
                p.appendTo(sb);
                first = false;
            }
            sb.append("]}");
        }
    }
}

