/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.perfrunner;

import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;

class RunStats {
    private final long nanoTime;
    private final int gcCount;
    private final int heapInUse;

    private RunStats(long timeNanos, int gcCount, int heapInUse) {
        this.nanoTime = timeNanos;
        this.gcCount = gcCount;
        this.heapInUse = heapInUse;
    }

    public static RunStats create() {
        int gcTotal = 0;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcTotal = (int)((long)gcTotal + gcBean.getCollectionCount());
        }
        return new RunStats(System.nanoTime(), gcTotal, (int)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
    }

    public RunStats relativeToNow() {
        RunStats now = RunStats.create();
        return new RunStats(now.nanoTime - this.nanoTime, now.gcCount - this.gcCount, now.heapInUse - this.heapInUse);
    }

    public double timeMillis() {
        return (double)this.nanoTime / 1000000.0;
    }

    public void appendTo(Appendable sb) throws IOException {
        sb.append("{ nanoTime: " + this.nanoTime + ", gcCount: " + this.gcCount + ", heapInUse: " + this.heapInUse + "}");
    }
}

