/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.authentication.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.literal.NamedLiteral;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.StringUtils;
import org.jboss.picketlink.cdi.authentication.Authenticator;
import org.jboss.picketlink.cdi.authentication.AuthenticatorSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class DefaultAuthenticatorSelector
implements AuthenticatorSelector {
    private String authenticatorName;
    private Class<? extends Authenticator> authenticatorClass;
    @Inject
    @Any
    private Instance<Authenticator> authenticators;

    public Authenticator getSelectedAuthenticator() {
        if (this.authenticatorClass != null) {
            return (Authenticator)this.authenticators.select(this.authenticatorClass, new Annotation[0]).get();
        }
        if (!StringUtils.isEmpty((String)this.authenticatorName)) {
            Instance selected = this.authenticators.select(new Annotation[]{new NamedLiteral(this.authenticatorName)});
            if (selected.isAmbiguous()) {
                return null;
            }
            if (selected.isUnsatisfied()) {
                return null;
            }
            return (Authenticator)selected.get();
        }
        Authenticator selectedAuth = null;
        List references = BeanProvider.getContextualReferences(Authenticator.class, (boolean)true);
        for (Authenticator auth : references) {
            if (!this.isExternalAuthenticator(auth.getClass())) continue;
            selectedAuth = auth;
            break;
        }
        if (selectedAuth == null) {
            // empty if block
        }
        return selectedAuth;
    }

    private boolean isExternalAuthenticator(Class<? extends Authenticator> authClass) {
        return !authClass.getName().startsWith(this.getClass().getPackage().getName());
    }

    public Class<? extends Authenticator> getAuthenticatorClass() {
        return this.authenticatorClass;
    }

    public void setAuthenticatorClass(Class<? extends Authenticator> authenticatorClass) {
        this.authenticatorClass = authenticatorClass;
    }

    public String getAuthenticatorName() {
        return this.authenticatorName;
    }

    public void setAuthenticatorName(String authenticatorName) {
        this.authenticatorName = authenticatorName;
    }
}

