/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.credential.internal;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.inject.Named;
import org.jboss.picketlink.cdi.authentication.event.LoginFailedEvent;
import org.jboss.picketlink.cdi.authentication.event.PostAuthenticateEvent;
import org.jboss.picketlink.cdi.credential.Credential;
import org.jboss.picketlink.cdi.credential.LoginCredentials;

@Named(value="loginCredentials")
@RequestScoped
public class DefaultLoginCredentials
implements LoginCredentials {
    private Credential credential;
    private String userId;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public String getPassword() {
        return this.credential != null && this.credential.getValue() instanceof String ? (String)this.credential.getValue() : null;
    }

    public void setPassword(final String password) {
        this.credential = new Credential<String>(){

            public String getValue() {
                return password;
            }
        };
    }

    public void invalidate() {
        this.credential = null;
        this.userId = null;
    }

    protected void setValid(@Observes PostAuthenticateEvent event) {
        this.invalidate();
    }

    protected void afterLogin(@Observes PostAuthenticateEvent event) {
        this.invalidate();
    }

    protected void loginFailed(@Observes LoginFailedEvent event) {
        this.invalidate();
    }

    public String toString() {
        return "LoginCredential[" + (this.userId != null ? this.userId : "unknown") + "]";
    }
}

