/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.jboss.picketlink.cdi.Identity;
import org.jboss.picketlink.cdi.authentication.AuthenticationException;
import org.jboss.picketlink.cdi.authentication.Authenticator;
import org.jboss.picketlink.cdi.authentication.AuthenticatorSelector;
import org.jboss.picketlink.cdi.authentication.UnexpectedCredentialException;
import org.jboss.picketlink.cdi.authentication.event.AlreadyLoggedInEvent;
import org.jboss.picketlink.cdi.authentication.event.LoggedInEvent;
import org.jboss.picketlink.cdi.authentication.event.LoginFailedEvent;
import org.jboss.picketlink.cdi.authentication.event.PostAuthenticateEvent;
import org.jboss.picketlink.cdi.authentication.event.PostLoggedOutEvent;
import org.jboss.picketlink.cdi.authentication.event.PreAuthenticateEvent;
import org.jboss.picketlink.cdi.authentication.event.PreLoggedOutEvent;
import org.jboss.picketlink.cdi.credential.LoginCredentials;
import org.jboss.picketlink.idm.model.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SessionScoped
@Named(value="identity")
public class DefaultIdentity
implements Identity {
    private static final long serialVersionUID = 3696702275353144429L;
    @Inject
    private AuthenticatorSelector authenticatorSelector;
    @Inject
    private BeanManager beanManager;
    @Inject
    private LoginCredentials loginCredential;
    private boolean authenticating;
    private User user;

    public boolean isLoggedIn() {
        return this.user != null;
    }

    public User getUser() {
        return this.user;
    }

    public Identity.AuthenticationResult login() {
        try {
            if (this.isLoggedIn()) {
                if (this.isAuthenticationRequestWithDifferentUserId()) {
                    throw new UnexpectedCredentialException("active user: " + this.user.getId() + " provided credentials: " + this.loginCredential.getUserId());
                }
                this.beanManager.fireEvent((Object)new AlreadyLoggedInEvent(), new Annotation[0]);
                return Identity.AuthenticationResult.SUCCESS;
            }
            boolean success = this.authenticate();
            if (success) {
                this.beanManager.fireEvent((Object)new LoggedInEvent(), new Annotation[0]);
                return Identity.AuthenticationResult.SUCCESS;
            }
            this.beanManager.fireEvent((Object)new LoginFailedEvent(null), new Annotation[0]);
            return Identity.AuthenticationResult.FAILED;
        }
        catch (Throwable e) {
            this.beanManager.fireEvent((Object)new LoginFailedEvent(e), new Annotation[0]);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private boolean isAuthenticationRequestWithDifferentUserId() {
        return this.isLoggedIn() && this.loginCredential.getUserId() != null && !this.loginCredential.getUserId().equals(this.user.getId());
    }

    protected boolean authenticate() throws AuthenticationException {
        if (this.authenticating) {
            this.authenticating = false;
            throw new IllegalStateException("Authentication already in progress.");
        }
        try {
            this.authenticating = true;
            this.beanManager.fireEvent((Object)new PreAuthenticateEvent(), new Annotation[0]);
            Authenticator activeAuthenticator = this.authenticatorSelector.getSelectedAuthenticator();
            if (activeAuthenticator == null) {
                throw new AuthenticationException("No Authenticator has been configured.");
            }
            activeAuthenticator.authenticate();
            if (activeAuthenticator.getStatus() == null) {
                throw new AuthenticationException("Authenticator must return a valid authentication status");
            }
            if (activeAuthenticator.getStatus() == Authenticator.AuthenticationStatus.SUCCESS) {
                this.postAuthenticate(activeAuthenticator);
                this.user = activeAuthenticator.getUser();
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable ex) {
            if (ex instanceof AuthenticationException) {
                throw (AuthenticationException)ex;
            }
            throw new AuthenticationException("Authentication failed.", ex);
        }
        finally {
            this.authenticating = false;
        }
        return false;
    }

    protected void postAuthenticate(Authenticator activeAuthenticator) {
        activeAuthenticator.postAuthenticate();
        if (!activeAuthenticator.getStatus().equals((Object)Authenticator.AuthenticationStatus.SUCCESS)) {
            return;
        }
        this.beanManager.fireEvent((Object)new PostAuthenticateEvent(), new Annotation[0]);
    }

    public void logout() {
        this.logout(true);
    }

    protected void logout(boolean invalidateLoginCredential) {
        if (this.isLoggedIn()) {
            this.beanManager.fireEvent((Object)new PreLoggedOutEvent(this.user), new Annotation[0]);
            PostLoggedOutEvent postLoggedOutEvent = new PostLoggedOutEvent(this.user);
            this.unAuthenticate(invalidateLoginCredential);
            this.beanManager.fireEvent((Object)postLoggedOutEvent, new Annotation[0]);
        }
    }

    private void unAuthenticate(boolean invalidateLoginCredential) {
        this.user = null;
        if (invalidateLoginCredential) {
            this.loginCredential.invalidate();
        }
    }

    public boolean hasPermission(Object resource, String operation) {
        return false;
    }

    public boolean hasPermission(Class<?> resourceClass, Serializable identifier, String operation) {
        return false;
    }
}

