/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.internal.util.properties;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.jboss.picketlink.cdi.internal.util.properties.FieldProperty;
import org.jboss.picketlink.cdi.internal.util.properties.FieldPropertyImpl;
import org.jboss.picketlink.cdi.internal.util.properties.MethodProperty;
import org.jboss.picketlink.cdi.internal.util.properties.MethodPropertyImpl;
import org.jboss.picketlink.cdi.internal.util.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    private Properties() {
    }

    public static <V> FieldProperty<V> createProperty(Field field) {
        return new FieldPropertyImpl(field);
    }

    public static <V> MethodProperty<V> createProperty(Method method) {
        return new MethodPropertyImpl(method);
    }

    public static <V> Property<V> createProperty(Member member) {
        if (member instanceof Method) {
            return new MethodPropertyImpl((Method)Method.class.cast(member));
        }
        if (member instanceof Field) {
            return new FieldPropertyImpl((Field)Field.class.cast(member));
        }
        throw new IllegalArgumentException("Cannot make a property of " + member + " - it is neither a method or a field");
    }

    public static <V> boolean isProperty(Method method) {
        try {
            new MethodPropertyImpl(method);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

