/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.permission.internal;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.Dependent;
import org.jboss.picketlink.cdi.permission.IdentifierStrategy;
import org.jboss.picketlink.cdi.permission.annotations.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Dependent
public class ClassIdentifierStrategy
implements IdentifierStrategy {
    private Map<Class<?>, String> identifierNames = new ConcurrentHashMap();

    public boolean canIdentify(Class<?> resourceClass) {
        return Class.class.equals(resourceClass);
    }

    public String getIdentifier(Object resource) {
        if (!(resource instanceof Class)) {
            throw new IllegalArgumentException("Resource [" + resource + "] must be instance of Class");
        }
        return this.getIdentifierName((Class)resource);
    }

    public Serializable getNaturalIdentifier(Object resource) {
        return this.getIdentifier(resource);
    }

    private String getIdentifierName(Class<?> cls) {
        if (!this.identifierNames.containsKey(cls)) {
            Identifier identifier;
            String name = null;
            if (cls.isAnnotationPresent(Identifier.class) && (identifier = cls.getAnnotation(Identifier.class)).name() != null && !"".equals(identifier.name().trim())) {
                name = identifier.name();
            }
            if (name == null) {
                name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
            }
            this.identifierNames.put(cls, name);
            return name;
        }
        return this.identifierNames.get(cls);
    }

    public boolean canLoadResource(String identifier) {
        return false;
    }

    public Object lookupResource(String identifier) {
        return null;
    }
}

