/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.permission.internal;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.jboss.picketlink.cdi.internal.util.Strings;
import org.jboss.picketlink.cdi.internal.util.properties.Property;
import org.jboss.picketlink.cdi.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.jboss.picketlink.cdi.internal.util.properties.query.PropertyQueries;
import org.jboss.picketlink.cdi.internal.util.properties.query.PropertyQuery;
import org.jboss.picketlink.cdi.permission.IdentifierStrategy;
import org.jboss.picketlink.cdi.permission.annotations.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityIdentifierStrategy
implements IdentifierStrategy {
    private Map<Class<?>, String> identifierNames = new ConcurrentHashMap();
    private Map<Class<?>, Property<Serializable>> identifierProperties = new ConcurrentHashMap();
    @Inject
    Instance<EntityManager> entityManager;

    public boolean canIdentify(Class<?> resourceClass) {
        return resourceClass.isAnnotationPresent(Entity.class);
    }

    public String getIdentifier(Object resource) {
        return String.format("%s:%s", this.getIdentifierName(resource.getClass()), this.getNaturalIdentifier(resource));
    }

    public Serializable getNaturalIdentifier(Object resource) {
        Class<?> resourceClass = resource.getClass();
        if (!this.identifierProperties.containsKey(resourceClass)) {
            PropertyQuery pq = PropertyQueries.createQuery(resource.getClass());
            pq.addCriteria(new AnnotatedPropertyCriteria(Id.class));
            this.identifierProperties.put(resourceClass, pq.getSingleResult());
        }
        Property<Serializable> p = this.identifierProperties.get(resourceClass);
        return p.getValue(resource);
    }

    private String getIdentifierName(Class<?> cls) {
        if (!this.identifierNames.containsKey(cls)) {
            Identifier identifier;
            String name = null;
            if (cls.isAnnotationPresent(Identifier.class) && !Strings.isEmpty((identifier = cls.getAnnotation(Identifier.class)).name())) {
                name = identifier.name();
            }
            if (name == null) {
                name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
            }
            this.identifierNames.put(cls, name);
            return name;
        }
        return this.identifierNames.get(cls);
    }

    public boolean canLoadResource(String identifier) {
        return false;
    }

    public Object lookupResource(String identifier) {
        return null;
    }
}

