/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.permission.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.picketlink.cdi.permission.IdentifierStrategy;
import org.jboss.picketlink.cdi.permission.annotations.Identifier;
import org.jboss.picketlink.cdi.permission.internal.ClassIdentifierStrategy;
import org.jboss.picketlink.cdi.permission.internal.EntityIdentifierStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class IdentifierPolicy {
    private Map<Class<?>, IdentifierStrategy> strategies = new ConcurrentHashMap();
    private Set<IdentifierStrategy> registeredStrategies = new HashSet<IdentifierStrategy>();

    @Inject
    public void create() {
        if (this.registeredStrategies.isEmpty()) {
            this.registeredStrategies.add(new EntityIdentifierStrategy());
            this.registeredStrategies.add(new ClassIdentifierStrategy());
        }
    }

    public String getIdentifier(Object resource) {
        if (resource instanceof String) {
            return (String)resource;
        }
        IdentifierStrategy strategy = this.getStrategyForResource(resource);
        return strategy != null ? strategy.getIdentifier(resource) : null;
    }

    public Map<String, Object> lookupResources(Collection<String> identifiers, Collection<Object> loadedResources) {
        IdentifierStrategy strategy;
        HashMap<String, Object> resources = new HashMap<String, Object>();
        HashMap<String, Object> loadedIdentifiers = new HashMap<String, Object>();
        if (loadedResources != null && !loadedResources.isEmpty()) {
            for (Object resource : loadedResources) {
                String identifier;
                strategy = this.getStrategyForResource(resource);
                if (strategy == null || loadedIdentifiers.containsKey(identifier = strategy.getIdentifier(resource))) continue;
                loadedIdentifiers.put(identifier, resource);
            }
        }
        for (String identifier : identifiers) {
            Object resource;
            if (loadedIdentifiers.containsKey(identifier)) {
                resources.put(identifier, loadedIdentifiers.get(identifier));
                continue;
            }
            strategy = this.getStrategyForIdentifier(identifier);
            if (strategy == null || (resource = strategy.lookupResource(identifier)) == null) continue;
            resources.put(identifier, resource);
        }
        return resources;
    }

    public Serializable getIdentifierValue(Object resource) {
        IdentifierStrategy strategy = this.getStrategyForResource(resource);
        return strategy != null ? strategy.getNaturalIdentifier(resource) : null;
    }

    private IdentifierStrategy getStrategyForIdentifier(String identifier) {
        for (IdentifierStrategy strategy : this.strategies.values()) {
            if (!strategy.canLoadResource(identifier)) continue;
            return strategy;
        }
        for (IdentifierStrategy strategy : this.registeredStrategies) {
            if (!strategy.canLoadResource(identifier)) continue;
            return strategy;
        }
        return null;
    }

    private IdentifierStrategy getStrategyForResource(Object resource) {
        IdentifierStrategy strategy = this.strategies.get(resource.getClass());
        if (strategy == null) {
            Class strategyClass;
            if (resource.getClass().isAnnotationPresent(Identifier.class) && (strategyClass = resource.getClass().getAnnotation(Identifier.class).value()) != IdentifierStrategy.class) {
                try {
                    strategy = (IdentifierStrategy)strategyClass.newInstance();
                    this.strategies.put(resource.getClass(), strategy);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error instantiating IdentifierStrategy for object " + resource, ex);
                }
            }
            for (IdentifierStrategy s : this.registeredStrategies) {
                if (!s.canIdentify(resource.getClass())) continue;
                strategy = s;
                this.strategies.put(resource.getClass(), strategy);
                break;
            }
        }
        return strategy;
    }

    public Set<IdentifierStrategy> getRegisteredStrategies() {
        return this.registeredStrategies;
    }

    public void setRegisteredStrategies(Set<IdentifierStrategy> registeredStrategies) {
        this.registeredStrategies = registeredStrategies;
    }
}

