/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.permission.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jboss.picketlink.cdi.permission.Permission;
import org.jboss.picketlink.cdi.permission.PermissionQuery;
import org.jboss.picketlink.cdi.permission.internal.IdentifierPolicy;
import org.jboss.picketlink.cdi.permission.internal.JPAPermissionStoreConfig;
import org.jboss.picketlink.cdi.permission.spi.PermissionStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class JPAPermissionStore
implements PermissionStore {
    @Inject
    private Instance<EntityManager> entityManagerInstance;
    @Inject
    private JPAPermissionStoreConfig config;
    @Inject
    private IdentifierPolicy identifierPolicy;

    public List<Permission> getPermissions(PermissionQuery query) {
        EntityManager em = (EntityManager)this.entityManagerInstance.get();
        HashMap resourceMetadata = new HashMap();
        if (query.getResources() != null) {
            for (Object resource : query.getResources()) {
                JPAPermissionStoreConfig.StoreMetadata meta;
                Class<?> resourceClass = resource.getClass();
                JPAPermissionStoreConfig.StoreMetadata storeMetadata = meta = this.config.getStores().containsKey(resourceClass) ? this.config.getStores().get(resourceClass) : this.config.getGeneralStore();
                if (!resourceMetadata.containsKey(meta)) {
                    resourceMetadata.put(meta, new HashSet());
                }
                ((Set)resourceMetadata.get(meta)).add(resource);
            }
        } else if (query.getResource() != null) {
            JPAPermissionStoreConfig.StoreMetadata meta;
            Class<?> resourceClass = query.getResource().getClass();
            JPAPermissionStoreConfig.StoreMetadata storeMetadata = meta = this.config.getStores().containsKey(resourceClass) ? this.config.getStores().get(resourceClass) : this.config.getGeneralStore();
            if (!resourceMetadata.containsKey(meta)) {
                resourceMetadata.put(meta, new HashSet());
            }
            ((Set)resourceMetadata.get(meta)).add(query.getResource());
        } else {
            throw new SecurityException("Invalid permission query - must specify resource or resources");
        }
        if (resourceMetadata.isEmpty()) {
            for (JPAPermissionStoreConfig.StoreMetadata meta : this.config.getStores().values()) {
                Query permissionQuery = this.buildPermissionQuery(meta, query, em);
            }
        } else {
            ArrayList results = new ArrayList();
            ArrayList<Object> knownResources = new ArrayList<Object>();
            if (query.getResource() != null) {
                knownResources.add(query.getResource());
            } else if (query.getResources() != null) {
                knownResources.addAll(query.getResources());
            }
            for (JPAPermissionStoreConfig.StoreMetadata meta : resourceMetadata.keySet()) {
                Query permissionQuery = this.buildPermissionQuery(meta, query, em);
                for (Object result : permissionQuery.getResultList()) {
                    Object identifier = meta.getAclIdentifier().getValue(result);
                }
            }
        }
        return null;
    }

    private Query buildPermissionQuery(JPAPermissionStoreConfig.StoreMetadata meta, PermissionQuery query, EntityManager em) {
        HashMap<String, Object> paramValues = new HashMap<String, Object>();
        StringBuilder queryText = new StringBuilder();
        StringBuilder criteriaText = new StringBuilder();
        queryText.append("SELECT P FROM ");
        queryText.append(meta.getStoreClass().getName());
        queryText.append(" P WHERE ");
        if (query.getResource() != null) {
            criteriaText.append("P.");
            criteriaText.append(meta.getAclIdentifier().getName());
            criteriaText.append(" = :IDENTIFIER");
            if (meta.getResourceClass() != null) {
                paramValues.put("IDENTIFIER", this.identifierPolicy.getIdentifierValue(query.getResource()));
            } else {
                paramValues.put("IDENTIFIER", this.identifierPolicy.getIdentifier(query.getResource()));
            }
        } else if (query.getResources() != null) {
            // empty if block
        }
        if (query.getRecipient() != null) {
            if (criteriaText.length() > 0) {
                criteriaText.append(" AND ");
            }
            criteriaText.append("P.");
            criteriaText.append(meta.getAclRecipient().getName());
            criteriaText.append(" = :RECIPIENT");
            paramValues.put("RECIPIENT", query.getRecipient().getKey());
        }
        queryText.append((CharSequence)criteriaText);
        Query q = em.createQuery(queryText.toString());
        for (String param : paramValues.keySet()) {
            q.setParameter(param, paramValues.get(param));
        }
        return q;
    }

    public boolean grantPermission(Permission permission) {
        EntityManager em = (EntityManager)this.entityManagerInstance.get();
        JPAPermissionStoreConfig.StoreMetadata store = this.findStoreForResource(permission.getResource());
        PermissionQuery pq = new PermissionQuery((PermissionStore)this);
        pq.setResource(permission.getResource());
        pq.setRecipient(permission.getRecipient());
        Query q = this.buildPermissionQuery(store, pq, em);
        List results = q.getResultList();
        if (results.isEmpty()) {
            try {
                Object p = store.getStoreClass().newInstance();
                if (store.getResourceClass() != null) {
                    store.getAclIdentifier().setValue(p, this.identifierPolicy.getIdentifierValue(permission.getResource()));
                } else {
                    store.getAclIdentifier().setValue(p, this.identifierPolicy.getIdentifier(permission.getResource()));
                }
                store.getAclRecipient().setValue(p, permission.getRecipient().getKey());
                store.getAclPermission().setValue(p, permission.getPermission());
                em.persist(p);
                return true;
            }
            catch (IllegalAccessException ex) {
                throw new SecurityException("Error creating new permission", ex);
            }
            catch (InstantiationException ex) {
                throw new SecurityException("Error creating new permission", ex);
            }
        }
        return false;
    }

    public boolean grantPermissions(Collection<Permission> permissions) {
        return false;
    }

    public boolean revokePermission(Permission permission) {
        return false;
    }

    public boolean revokePermissions(Collection<Permission> permissions) {
        return false;
    }

    public List<String> listAvailableActions(Object target) {
        return null;
    }

    public void clearPermissions(Object target) {
    }

    public boolean isEnabled() {
        return false;
    }

    private JPAPermissionStoreConfig.StoreMetadata findStoreForResource(Object resource) {
        for (Class<?> cls : this.config.getStores().keySet()) {
            if (!cls.isInstance(resource)) continue;
            return this.config.getStores().get(cls);
        }
        return this.config.getGeneralStore();
    }
}

