/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.permission.internal;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.persistence.Entity;
import org.jboss.picketlink.cdi.internal.util.properties.Property;
import org.jboss.picketlink.cdi.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.jboss.picketlink.cdi.internal.util.properties.query.PropertyQueries;
import org.jboss.picketlink.cdi.permission.annotations.ACLIdentifier;
import org.jboss.picketlink.cdi.permission.annotations.ACLPermission;
import org.jboss.picketlink.cdi.permission.annotations.ACLRecipient;
import org.jboss.picketlink.cdi.permission.annotations.ACLResourceClass;
import org.jboss.picketlink.cdi.permission.annotations.ACLStore;
import org.jboss.picketlink.idm.SecurityConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class JPAPermissionStoreConfig
implements Extension {
    private StoreMetadata generalStore = null;
    private Map<Class<?>, StoreMetadata> storeMap = new HashMap();

    public StoreMetadata getGeneralStore() {
        return this.generalStore;
    }

    public Map<Class<?>, StoreMetadata> getStores() {
        return this.storeMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event, BeanManager beanManager) {
        AnnotatedType type;
        if (!event.getAnnotatedType().isAnnotationPresent(Entity.class) || !(type = event.getAnnotatedType()).isAnnotationPresent(ACLStore.class)) return;
        ACLStore store = (ACLStore)type.getAnnotation(ACLStore.class);
        if (ACLStore.GENERAL.class.equals((Object)store.value())) {
            if (this.generalStore != null) throw new SecurityConfigurationException("More than one entity bean has been configured as a general ACL store - conflicting bean classes: " + this.generalStore.getStoreClass().getName() + " and " + type.getJavaClass().getName());
            this.generalStore = new StoreMetadata(type.getJavaClass(), null);
            return;
        } else {
            if (this.storeMap.containsKey(store.value())) {
                throw new SecurityConfigurationException("More than one entity bean has been configured to store ACL permissions for class " + store.value().getName() + " - conflicting classes: " + this.storeMap.get(store.value()).getStoreClass().getName() + " and " + type.getJavaClass().getName());
            }
            this.storeMap.put(store.value(), new StoreMetadata(type.getJavaClass(), store.value()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StoreMetadata {
        private Class<?> storeClass;
        private Class<?> resourceClass;
        private Property<Object> aclIdentifier;
        private Property<Object> aclPermission;
        private Property<String> aclRecipient;
        private Property<String> aclResourceClass;

        public StoreMetadata(Class<?> storeClass, Class<?> resourceClass) {
            this.storeClass = storeClass;
            this.resourceClass = resourceClass;
            this.validateStore();
        }

        private void validateStore() {
            this.aclIdentifier = PropertyQueries.createQuery(this.storeClass).addCriteria(new AnnotatedPropertyCriteria(ACLIdentifier.class)).getFirstResult();
            if (this.aclIdentifier == null) {
                throw new SecurityConfigurationException("Permission storage class " + this.storeClass.getName() + " must have a field annotated @ACLIdentifier");
            }
            this.aclPermission = PropertyQueries.createQuery(this.storeClass).addCriteria(new AnnotatedPropertyCriteria(ACLPermission.class)).getFirstResult();
            if (this.aclPermission == null) {
                throw new SecurityConfigurationException("Permission storage class " + this.storeClass.getName() + " must have a field annotated @ACLPermission");
            }
            this.aclRecipient = PropertyQueries.createQuery(this.storeClass).addCriteria(new AnnotatedPropertyCriteria(ACLRecipient.class)).getFirstResult();
            if (this.aclRecipient == null) {
                throw new SecurityConfigurationException("Permission storage class " + this.storeClass.getName() + " must have a field annotated @ACLRecipient");
            }
            this.aclResourceClass = PropertyQueries.createQuery(this.storeClass).addCriteria(new AnnotatedPropertyCriteria(ACLResourceClass.class)).getFirstResult();
        }

        public Class<?> getStoreClass() {
            return this.storeClass;
        }

        public Class<?> getResourceClass() {
            return this.resourceClass;
        }

        public Property<Object> getAclIdentifier() {
            return this.aclIdentifier;
        }

        public Property<Object> getAclPermission() {
            return this.aclPermission;
        }

        public Property<String> getAclRecipient() {
            return this.aclRecipient;
        }

        public Property<String> getAclResourceClass() {
            return this.aclResourceClass;
        }
    }
}

