/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.picketlink.cdi.permission.internal;

import java.io.Serializable;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.picketlink.cdi.permission.PermissionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionMapper {
    @Inject
    private Instance<PermissionResolver> resolvers;

    public boolean resolvePermission(Object resource, String operation) {
        boolean permit = false;
        for (PermissionResolver resolver : this.resolvers) {
            PermissionResolver.PermissionStatus status = resolver.hasPermission(resource, operation);
            if (PermissionResolver.PermissionStatus.ALLOW.equals((Object)status)) {
                permit = true;
                continue;
            }
            if (!PermissionResolver.PermissionStatus.DENY.equals((Object)status)) continue;
            return false;
        }
        return permit;
    }

    public boolean resolvePermission(Class<?> resourceClass, Serializable identifier, String operation) {
        boolean permit = false;
        for (PermissionResolver resolver : this.resolvers) {
            PermissionResolver.PermissionStatus status = resolver.hasPermission(resourceClass, identifier, operation);
            if (PermissionResolver.PermissionStatus.ALLOW.equals((Object)status)) {
                permit = true;
                continue;
            }
            if (!PermissionResolver.PermissionStatus.DENY.equals((Object)status)) continue;
            return false;
        }
        return permit;
    }
}

