/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.bifrost.upload;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;

class BifrostHttpRequestRetryStrategy
implements HttpRequestRetryStrategy {
    private final int maxRetries;
    private final int delay;

    public BifrostHttpRequestRetryStrategy(int maxRetries, int delay) {
        this.maxRetries = maxRetries;
        this.delay = delay;
    }

    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        boolean exceptionBad = !(exception instanceof SSLException);
        return exceptionBad && execCount < this.maxRetries;
    }

    public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
        boolean codeBad = response.getCode() == 429 || response.getCode() >= 500;
        return codeBad && execCount < this.maxRetries;
    }

    public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
        return TimeValue.of((long)((long)execCount * (long)this.delay), (TimeUnit)TimeUnit.SECONDS);
    }
}

