/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.bifrost.upload;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.entity.GzipCompressingEntity;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.jboss.pnc.bifrost.upload.BifrostHttpRequestRetryStrategy;
import org.jboss.pnc.bifrost.upload.BifrostUploadException;
import org.jboss.pnc.bifrost.upload.ChecksumComputingStream;
import org.jboss.pnc.bifrost.upload.LogMetadata;

public class BifrostLogUploader {
    public static final String HEADER_PROCESS_CONTEXT = "log-process-context";
    public static final String HEADER_PROCESS_CONTEXT_VARIANT = "process-context-variant";
    public static final String HEADER_TMP = "log-tmp";
    public static final String HEADER_REQUEST_CONTEXT = "log-request-context";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    private final URI bifrostUrl;
    private final Supplier<String> tokenProvider;
    private static final ContentType PLAIN_UTF8_CONTENT_TYPE = ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8);
    private final BifrostHttpRequestRetryStrategy retryStrategy;

    public BifrostLogUploader(URI bifrostUrl, int maxRetries, int delaySeconds, Supplier<String> tokenProvider) {
        this.bifrostUrl = bifrostUrl.resolve("/final-log/upload");
        this.tokenProvider = tokenProvider;
        this.retryStrategy = new BifrostHttpRequestRetryStrategy(maxRetries, delaySeconds);
    }

    public void uploadFile(File logfile, LogMetadata metadata) throws BifrostUploadException {
        String md5Sum;
        try (ChecksumComputingStream checksums = ChecksumComputingStream.computeChecksums(Files.newInputStream(logfile.toPath(), new OpenOption[0]));){
            md5Sum = checksums.getMD5Sum();
        }
        catch (IOException e) {
            throw new BifrostUploadException("Could not compute file checksums.", e);
        }
        this.uploadFile(logfile, metadata, md5Sum);
    }

    public void uploadFile(File logfile, LogMetadata metadata, String md5sum) throws BifrostUploadException {
        MultipartEntityBuilder multipartEntityBuilder = BifrostLogUploader.prepareMetadata(metadata, md5sum);
        HttpEntity formDataEntity = multipartEntityBuilder.addPart("logfile", (ContentBody)new FileBody(logfile)).build();
        List<Header> headers = this.prepareHeaders(metadata);
        this.upload(formDataEntity, headers);
    }

    public void uploadString(String log, LogMetadata metadata) throws BifrostUploadException {
        String md5Sum;
        try (ChecksumComputingStream checksums = ChecksumComputingStream.computeChecksums(new ByteArrayInputStream(log.getBytes(StandardCharsets.UTF_8)));){
            md5Sum = checksums.getMD5Sum();
        }
        catch (IOException e) {
            throw new BifrostUploadException("Could not compute file checksums.", e);
        }
        this.uploadString(log, metadata, md5Sum);
    }

    public void uploadString(String log, LogMetadata metadata, String md5sum) throws BifrostUploadException {
        MultipartEntityBuilder multipartEntityBuilder = BifrostLogUploader.prepareMetadata(metadata, md5sum);
        HttpEntity formDataEntity = multipartEntityBuilder.addPart("logfile", (ContentBody)new StringBody(log, PLAIN_UTF8_CONTENT_TYPE)).build();
        List<Header> headers = this.prepareHeaders(metadata);
        this.upload(formDataEntity, headers);
    }

    private void upload(HttpEntity formDataEntity, List<Header> headers) {
        GzipCompressingEntity gzipped = new GzipCompressingEntity(formDataEntity);
        ClassicHttpRequest request = this.prepareRequest((HttpEntity)gzipped, headers);
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().setRetryStrategy((HttpRequestRetryStrategy)this.retryStrategy).build();){
            httpclient.execute(request, BifrostLogUploader::handleResponse);
        }
        catch (IOException e) {
            throw new BifrostUploadException("Failed to upload log to Bifrost", e);
        }
    }

    private ClassicHttpRequest prepareRequest(HttpEntity formDataEntity, List<Header> headers) {
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.post((URI)this.bifrostUrl).setEntity(formDataEntity);
        headers.forEach(arg_0 -> ((ClassicRequestBuilder)requestBuilder).addHeader(arg_0));
        return requestBuilder.build();
    }

    private List<Header> prepareHeaders(LogMetadata metadata) {
        ArrayList<Header> headers = new ArrayList<Header>();
        metadata.getHeaders().forEach((k, v) -> headers.add((Header)new BasicHeader(k, v)));
        headers.add((Header)new BasicHeader(HEADER_AUTHORIZATION, (Object)("Bearer " + this.tokenProvider.get())));
        return headers;
    }

    private static MultipartEntityBuilder prepareMetadata(LogMetadata metadata, String md5sum) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addPart("md5sum", (ContentBody)new StringBody(md5sum, PLAIN_UTF8_CONTENT_TYPE)).addPart("endTime", (ContentBody)new StringBody(metadata.getEndTime().toString(), PLAIN_UTF8_CONTENT_TYPE)).addPart("loggerName", (ContentBody)new StringBody(metadata.getLoggerName(), PLAIN_UTF8_CONTENT_TYPE)).addPart("tag", (ContentBody)new StringBody(metadata.getTag(), PLAIN_UTF8_CONTENT_TYPE));
        return multipartEntityBuilder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean handleResponse(ClassicHttpResponse response) {
        try (HttpEntity entity = response.getEntity();){
            if (response.getCode() == 200) {
                EntityUtils.consume((HttpEntity)entity);
                boolean bl = true;
                return bl;
            }
            String message = EntityUtils.toString((HttpEntity)entity);
            throw new BifrostUploadException("Failed to upload log to Bifrost, status " + response.getCode() + " message: " + message);
        }
        catch (IOException | ParseException e) {
            throw new BifrostUploadException("Failed to upload log to Bifrost", e);
        }
    }
}

