/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.bifrost.upload;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ChecksumComputingStream
extends FilterInputStream {
    private final MessageDigest md5;

    private ChecksumComputingStream(InputStream stream, MessageDigest md5) {
        super(stream);
        this.md5 = md5;
    }

    public static ChecksumComputingStream of(InputStream is) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        DigestInputStream md5dis = new DigestInputStream(is, md5);
        return new ChecksumComputingStream(md5dis, md5);
    }

    public static ChecksumComputingStream computeChecksums(InputStream is) throws IOException {
        ChecksumComputingStream cheksumStream = ChecksumComputingStream.of(is);
        cheksumStream.readFully();
        return cheksumStream;
    }

    public String getMD5Sum() {
        return ChecksumComputingStream.format(this.md5.digest());
    }

    public void readFully() throws IOException {
        while (this.read() != -1) {
        }
    }

    private static String format(byte[] digest) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : digest) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

