/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.bifrost.upload;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.jboss.pnc.bifrost.upload.TagOption;

public class LogMetadata {
    private OffsetDateTime endTime;
    private String loggerName;
    private String tag;
    @NonNull
    private Map<String, String> headers = new HashMap<String, String>();

    public void setProcessContext(String processContext) {
        this.headers.put("log-process-context", processContext);
    }

    public void setProcessContextVariant(String processContextVariant) {
        this.headers.put("process-context-variant", processContextVariant);
    }

    public void setTmp(String tmp) {
        this.headers.put("log-tmp", tmp);
    }

    public void setRequestContext(String requestContext) {
        this.headers.put("log-request-context", requestContext);
    }

    public void setTag(TagOption tagOption) {
        this.tag = tagOption.getTagName();
    }

    LogMetadata(OffsetDateTime endTime, String loggerName, String tag, @NonNull Map<String, String> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        this.endTime = endTime;
        this.loggerName = loggerName;
        this.tag = tag;
        this.headers = headers;
    }

    public static LogMetadataBuilder builder() {
        return new LogMetadataBuilder();
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getTag() {
        return this.tag;
    }

    @NonNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public void setHeaders(@NonNull Map<String, String> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogMetadata)) {
            return false;
        }
        LogMetadata other = (LogMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OffsetDateTime this$endTime = this.getEndTime();
        OffsetDateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OffsetDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public String toString() {
        return "LogMetadata(endTime=" + this.getEndTime() + ", loggerName=" + this.getLoggerName() + ", tag=" + this.getTag() + ", headers=" + this.getHeaders() + ")";
    }

    public static class LogMetadataBuilder {
        private OffsetDateTime endTime;
        private String loggerName;
        private String tag;
        private Map<String, String> headers = new HashMap<String, String>();

        public LogMetadataBuilder processContext(String processContext) {
            this.headers.put("log-process-context", processContext);
            return this;
        }

        public LogMetadataBuilder processContextVariant(String processContextVariant) {
            this.headers.put("process-context-variant", processContextVariant);
            return this;
        }

        public LogMetadataBuilder tmp(String tmp) {
            this.headers.put("log-tmp", tmp);
            return this;
        }

        public LogMetadataBuilder requestContext(String requestContext) {
            this.headers.put("log-request-context", requestContext);
            return this;
        }

        public LogMetadataBuilder tag(TagOption tagOption) {
            this.tag = tagOption.getTagName();
            return this;
        }

        LogMetadataBuilder() {
        }

        public LogMetadataBuilder endTime(OffsetDateTime endTime) {
            this.endTime = endTime;
            return this;
        }

        public LogMetadataBuilder loggerName(String loggerName) {
            this.loggerName = loggerName;
            return this;
        }

        public LogMetadataBuilder headers(@NonNull Map<String, String> headers) {
            if (headers == null) {
                throw new NullPointerException("headers is marked non-null but is null");
            }
            this.headers = headers;
            return this;
        }

        public LogMetadata build() {
            return new LogMetadata(this.endTime, this.loggerName, this.tag, this.headers);
        }

        public String toString() {
            return "LogMetadata.LogMetadataBuilder(endTime=" + this.endTime + ", loggerName=" + this.loggerName + ", tag=" + this.tag + ", headers=" + this.headers + ")";
        }
    }
}

