/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.bpm.mock;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.jboss.pnc.bpm.BpmManager;
import org.jboss.pnc.bpm.BpmTask;
import org.jboss.pnc.bpm.mock.MockKieSession;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.moduleconfig.BpmModuleConfig;
import org.jboss.pnc.spi.exception.CoreException;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.mockito.Mockito;

public class BpmMock
extends BpmManager {
    private MockKieSession session = new MockKieSession();
    private Optional<Consumer<BpmTask>> onTaskStarted = Optional.empty();

    public BpmMock() throws ConfigurationParseException, CoreException {
        super(BpmMock.mockBpmConfig());
        super.init();
    }

    protected KieSession initKieSession() throws CoreException {
        BpmMock.mockBpmConfig();
        this.session.onStartProcess(this::startProcessMock);
        return this.session;
    }

    public boolean startTask(BpmTask task) throws CoreException {
        boolean started = super.startTask(task);
        this.onTaskStarted.ifPresent(supplier -> supplier.accept(task));
        return started;
    }

    public void setOnTaskStarted(Consumer<BpmTask> onTaskStarted) {
        this.onTaskStarted = Optional.of(onTaskStarted);
    }

    private static BpmModuleConfig mockBpmConfig() {
        BpmModuleConfig bpmConfig = (BpmModuleConfig)Mockito.mock(BpmModuleConfig.class);
        Mockito.when((Object)bpmConfig.getMilestoneReleaseProcessId()).thenReturn((Object)"1.1.1");
        return bpmConfig;
    }

    protected ProcessInstance startProcessMock(String processName, Map params) {
        return new ProcessInstanceMock();
    }

    @PostConstruct
    public void setUp() throws CoreException {
        super.init();
    }

    public static class ProcessInstanceMock
    implements ProcessInstance {
        public String getProcessId() {
            return null;
        }

        public Process getProcess() {
            return null;
        }

        public long getId() {
            return 0L;
        }

        public String getProcessName() {
            return null;
        }

        public int getState() {
            return 0;
        }

        public long getParentProcessInstanceId() {
            return 0L;
        }

        public void signalEvent(String s, Object o) {
        }

        public String[] getEventTypes() {
            return new String[0];
        }
    }
}

