/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.bpm.mock;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.pnc.bpm.BpmManager;
import org.jboss.pnc.bpm.BpmTask;
import org.jboss.pnc.bpm.Connector;
import org.jboss.pnc.bpm.mock.MockKieSession;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.json.moduleconfig.BpmModuleConfig;
import org.jboss.pnc.spi.exception.CoreException;
import org.jboss.pnc.spi.exception.ProcessManagerException;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmMock
extends BpmManager {
    private static final Logger log = LoggerFactory.getLogger(BpmMock.class);
    private MockKieSession session = new MockKieSession();
    private Optional<Consumer<BpmTask>> onTaskStarted = Optional.empty();

    public BpmMock() throws ConfigurationParseException, CoreException, IOException {
        super(BpmMock.mockGlobalConfig(), BpmMock.mockBpmConfig());
    }

    public boolean startTask(BpmTask task) throws CoreException {
        Connector connector = (Connector)Mockito.mock(Connector.class);
        try {
            Mockito.when((Object)connector.startProcess((String)Mockito.any(), Mockito.any(), (String)Mockito.any())).thenReturn((Object)1L);
        }
        catch (ProcessManagerException e) {
            log.error("Cannot mock start process.", (Throwable)e);
        }
        task.setConnector(connector);
        boolean started = super.startTask(task);
        this.onTaskStarted.ifPresent(supplier -> supplier.accept(task));
        return started;
    }

    public void setOnTaskStarted(Consumer<BpmTask> onTaskStarted) {
        this.onTaskStarted = Optional.of(onTaskStarted);
    }

    private static BpmModuleConfig mockBpmConfig() {
        BpmModuleConfig bpmConfig = (BpmModuleConfig)Mockito.mock(BpmModuleConfig.class);
        Mockito.when((Object)bpmConfig.getMilestoneReleaseProcessId()).thenReturn((Object)"1.1.1");
        return bpmConfig;
    }

    private static GlobalModuleGroup mockGlobalConfig() {
        GlobalModuleGroup bpmConfig = (GlobalModuleGroup)Mockito.mock(GlobalModuleGroup.class);
        Mockito.when((Object)bpmConfig.getBpmUrl()).thenReturn((Object)"http://bpm.svc.cluster.local/business-central");
        Mockito.when((Object)bpmConfig.getIndyUrl()).thenReturn((Object)"http://indy.svc.cluster.local/");
        return bpmConfig;
    }

    public void setUp() throws CoreException {
        super.init();
    }
}

