/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.demo.data;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.jboss.pnc.datastore.repositories.SequenceHandlerRepository;
import org.jboss.pnc.datastore.repositories.internal.BuildConfigurationAuditedSpringRepository;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.ArtifactStatus;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.model.Environment;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductRelease;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.model.Project;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.datastore.Datastore;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.EnvironmentRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductReleaseRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductVersionRepository;
import org.jboss.pnc.spi.datastore.repositories.ProjectRepository;
import org.jboss.pnc.spi.datastore.repositories.UserRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@Singleton
public class DatabaseDataInitializer {
    public static final Logger log = Logger.getLogger(DatabaseDataInitializer.class.getName());
    private static final String PNC_PRODUCT_NAME = "Project Newcastle Demo Product";
    private static final String PNC_PRODUCT_VERSION = "1.0";
    private static final String PNC_PRODUCT_RELEASE = "1.0.0.GA";
    private static final String PNC_PRODUCT_MILESTONE = "1.0.0.Build1";
    private static final String PNC_PROJECT_1_NAME = "Project Newcastle Demo Project 1";
    private static final String PNC_PROJECT_BUILD_CFG_ID = "pnc-1.0.0.DR1";
    @Inject
    ProjectRepository projectRepository;
    @Inject
    ProductRepository productRepository;
    @Inject
    BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    BuildConfigurationAuditedSpringRepository buildConfigurationAuditedRepository;
    @Inject
    ProductVersionRepository productVersionRepository;
    @Inject
    ProductMilestoneRepository productMilestoneRepository;
    @Inject
    ProductReleaseRepository productReleaseRepository;
    @Inject
    BuildConfigurationSetRepository buildConfigurationSetRepository;
    @Inject
    UserRepository userRepository;
    @Inject
    BuildRecordRepository buildRecordRepository;
    @Inject
    BuildConfigSetRecordRepository buildConfigSetRecordRepository;
    @Inject
    EnvironmentRepository environmentRepository;
    @Inject
    SequenceHandlerRepository sequenceHandlerRepository;
    @Inject
    Datastore datastore;
    BuildConfiguration buildConfiguration1;
    BuildConfiguration buildConfiguration2;
    BuildConfigurationSet buildConfigurationSet1;
    User demoUser;

    public void verifyData() {
        Preconditions.checkState((this.projectRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Projects > 0");
        Preconditions.checkState((this.productRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Products > 0");
        Preconditions.checkState((this.buildConfigurationRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of BuildConfigurations > 0");
        Preconditions.checkState((this.productVersionRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of ProductVersions > 0");
        Preconditions.checkState((this.buildConfigurationSetRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of BuildRepositorySets > 0");
        BuildConfiguration buildConfigurationDB = (BuildConfiguration)this.buildConfigurationRepository.queryAll().get(0);
        Preconditions.checkState((((BuildConfigurationSet)buildConfigurationDB.getBuildConfigurationSets().iterator().next()).getProductVersion() != null ? 1 : 0) != 0, (Object)"Product version of buildConfiguration must be not null");
        BuildConfigurationSet buildConfigurationSetDB = (BuildConfigurationSet)this.buildConfigurationSetRepository.queryAll().get(0);
        Preconditions.checkState((buildConfigurationSetDB.getProductVersion() != null ? 1 : 0) != 0, (Object)"Product version of buildConfigurationSet must be not null");
        Preconditions.checkState((boolean)buildConfigurationSetDB.getProductVersion().getProduct().getName().equals(PNC_PRODUCT_NAME), (Object)"Product mapped to Project must be Project Newcastle Demo Product");
        Preconditions.checkState((boolean)buildConfigurationSetDB.getProductVersion().getVersion().equals(PNC_PRODUCT_VERSION), (Object)"Product version mapped to Project must be 1.0");
        Preconditions.checkState((boolean)((BuildConfigurationSet)buildConfigurationDB.getBuildConfigurationSets().iterator().next()).getProductVersion().getVersion().equals(PNC_PRODUCT_VERSION), (Object)"Product version mapped to BuildConfiguration must be 1.0");
        Preconditions.checkState((boolean)((BuildConfigurationSet)buildConfigurationDB.getBuildConfigurationSets().iterator().next()).getProductVersion().getProduct().getName().equals(PNC_PRODUCT_NAME), (Object)"Product mapped to BuildConfiguration must be Project Newcastle Demo Product");
        Preconditions.checkState((boolean)buildConfigurationDB.getProject().getName().equals(PNC_PROJECT_1_NAME), (Object)"Project mapped to BuildConfiguration must be Project Newcastle Demo Project 1");
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void initiliazeProjectProductData() {
        Environment environment1 = this.createAndPersistDefultEnvironment();
        Environment environment2 = this.createAndPersistDefultEnvironment();
        Product product = Product.Builder.newBuilder().name(PNC_PRODUCT_NAME).abbreviation("PNC").description("Example Product for Project Newcastle Demo").productCode("PNC").pgmSystemName("newcastle").build();
        product = (Product)this.productRepository.save((GenericEntity)product);
        ProductVersion productVersion = ProductVersion.Builder.newBuilder().version(PNC_PRODUCT_VERSION).product(product).build();
        productVersion = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion);
        ProductMilestone productMilestone = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE).productVersion(productVersion).build();
        productMilestone = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)productMilestone);
        ProductRelease productRelease = ProductRelease.Builder.newBuilder().version(PNC_PRODUCT_RELEASE).productVersion(productVersion).productMilestone(productMilestone).supportLevel(ProductRelease.SupportLevel.EARLYACCESS).build();
        productRelease = (ProductRelease)this.productReleaseRepository.save((GenericEntity)productRelease);
        productVersion.setCurrentProductMilestone(productMilestone);
        productVersion = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion);
        Project project1 = Project.Builder.newBuilder().name(PNC_PROJECT_1_NAME).description("Example Project for Newcastle Demo").projectUrl("https://github.com/project-ncl/pnc").build();
        Project project2 = Project.Builder.newBuilder().name("JBoss Modules").description("JBoss Modules Project").projectUrl("https://github.com/jboss-modules/jboss-modules").issueTrackerUrl("https://issues.jboss.org/browse/MODULES").build();
        Project project3 = Project.Builder.newBuilder().name("JBoss JavaEE Servlet Spec API").description("JavaEE Servlet Spec API").projectUrl("https://github.com/jboss/jboss-servlet-api_spec").issueTrackerUrl("https://issues.jboss.org/browse/JBEE").build();
        Project project4 = Project.Builder.newBuilder().name("Fabric8").description("Integration platform for working with Apache ActiveMQ, Camel, CXF and Karaf in the cloud").projectUrl("https://github.com/fabric8io/fabric8").issueTrackerUrl("https://github.com/fabric8io/fabric8/issues").build();
        this.projectRepository.save((GenericEntity)project1);
        this.projectRepository.save((GenericEntity)project2);
        this.projectRepository.save((GenericEntity)project3);
        this.projectRepository.save((GenericEntity)project4);
        this.buildConfiguration1 = BuildConfiguration.Builder.newBuilder().name(PNC_PROJECT_BUILD_CFG_ID).project(project1).description("Test build config for project newcastle").environment(environment1).buildScript("mvn clean deploy -DskipTests=true").scmRepoURL("https://github.com/project-ncl/pnc.git").scmRevision("*/v0.2").build();
        this.buildConfiguration1 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)this.buildConfiguration1);
        this.buildConfiguration2 = BuildConfiguration.Builder.newBuilder().name("jboss-modules-1.5.0").project(project2).description("Test config for JBoss modules build master branch.").environment(environment2).buildScript("mvn clean deploy -DskipTests=true").scmRepoURL("https://github.com/jboss-modules/jboss-modules.git").scmRevision("9e7115771a791feaa5be23b1255416197f2cda38").build();
        this.buildConfiguration2 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)this.buildConfiguration2);
        BuildConfiguration buildConfiguration3 = BuildConfiguration.Builder.newBuilder().name("jboss-servlet-spec-api-1.0.1").project(project3).description("Test build for jboss java servlet api").environment(environment1).buildScript("mvn clean deploy -DskipTests=true").scmRepoURL("https://github.com/jboss/jboss-servlet-api_spec.git").dependency(this.buildConfiguration2).build();
        buildConfiguration3 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration3);
        BuildConfiguration buildConfiguration4 = BuildConfiguration.Builder.newBuilder().name("io-fabric8-2.2-SNAPSHOT").project(project4).description("Test build for Fabric8").environment(environment1).buildScript("mvn clean deploy -DskipTests=true").scmRepoURL("https://github.com/fabric8io/fabric8.git").build();
        buildConfiguration4 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration4);
        this.buildConfigurationSet1 = BuildConfigurationSet.Builder.newBuilder().name("Build Config Set 1").buildConfiguration(this.buildConfiguration1).buildConfiguration(this.buildConfiguration2).buildConfiguration(buildConfiguration3).productVersion(productVersion).build();
        BuildConfigurationSet buildConfigurationSet2 = BuildConfigurationSet.Builder.newBuilder().name("Fabric Configuration Set").buildConfiguration(buildConfiguration4).build();
        this.demoUser = User.Builder.newBuilder().username("demo-user").firstName("Demo First Name").lastName("Demo Last Name").email("demo-user@pnc.com").build();
        this.buildConfigurationSetRepository.save((GenericEntity)this.buildConfigurationSet1);
        this.buildConfigurationSetRepository.save((GenericEntity)buildConfigurationSet2);
        this.demoUser = (User)this.userRepository.save((GenericEntity)this.demoUser);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void initiliazeBuildRecordDemoData() {
        Artifact builtArtifact1 = Artifact.Builder.newBuilder().identifier("test").deployUrl("http://google.pl/built1").status(ArtifactStatus.BINARY_BUILT).build();
        Artifact builtArtifact2 = Artifact.Builder.newBuilder().identifier("test").deployUrl("http://google.pl/built2").status(ArtifactStatus.BINARY_BUILT).build();
        Artifact importedArtifact1 = Artifact.Builder.newBuilder().identifier("test").deployUrl("http://google.pl/imported1").status(ArtifactStatus.BINARY_IMPORTED).build();
        Artifact importedArtifact2 = Artifact.Builder.newBuilder().identifier("test").deployUrl("http://google.pl/imported2").status(ArtifactStatus.BINARY_IMPORTED).build();
        HashSet<BuildRecord> buildRecords = new HashSet<BuildRecord>();
        boolean INITIAL_REVISION = true;
        IdRev buildConfig1AuditIdRev = new IdRev(this.buildConfiguration1.getId(), Integer.valueOf(1));
        BuildConfigurationAudited buildConfigAudited1 = (BuildConfigurationAudited)this.buildConfigurationAuditedRepository.findOne((Serializable)buildConfig1AuditIdRev);
        if (buildConfigAudited1 != null) {
            int nextId = this.datastore.getNextBuildRecordId();
            log.info("####nextId: " + nextId);
            BuildRecord buildRecord = BuildRecord.Builder.newBuilder().id(Integer.valueOf(nextId)).latestBuildConfiguration(this.buildConfiguration1).buildConfigurationAudited(buildConfigAudited1).startTime(Timestamp.from(Instant.now())).endTime(Timestamp.from(Instant.now())).builtArtifact(builtArtifact1).builtArtifact(builtArtifact2).builtArtifact(importedArtifact1).builtArtifact(importedArtifact2).user(this.demoUser).buildLog("Very short demo log: The quick brown fox jumps over the lazy dog.").status(BuildStatus.SUCCESS).build();
            this.buildRecordRepository.save((GenericEntity)buildRecord);
            buildRecords.add(buildRecord);
        }
        Artifact builtArtifact3 = Artifact.Builder.newBuilder().identifier("test").deployUrl("http://google.pl/built3").status(ArtifactStatus.BINARY_BUILT).build();
        Artifact builtArtifact4 = Artifact.Builder.newBuilder().identifier("test").deployUrl("http://google.pl/built4").status(ArtifactStatus.BINARY_BUILT).build();
        IdRev buildConfig2AuditIdRev = new IdRev(this.buildConfiguration2.getId(), Integer.valueOf(1));
        BuildConfigurationAudited buildConfigAudited2 = (BuildConfigurationAudited)this.buildConfigurationAuditedRepository.findOne((Serializable)buildConfig2AuditIdRev);
        if (buildConfigAudited2 != null) {
            int nextId = this.datastore.getNextBuildRecordId();
            log.info("####nextId: " + nextId);
            BuildRecord buildRecord = BuildRecord.Builder.newBuilder().id(Integer.valueOf(nextId)).latestBuildConfiguration(this.buildConfiguration2).buildConfigurationAudited(buildConfigAudited2).startTime(Timestamp.from(Instant.now())).endTime(Timestamp.from(Instant.now())).builtArtifact(builtArtifact3).builtArtifact(builtArtifact4).user(this.demoUser).buildLog("Very short demo log: The quick brown fox jumps over the lazy dog.").status(BuildStatus.SUCCESS).build();
            this.buildRecordRepository.save((GenericEntity)buildRecord);
            buildRecords.add(buildRecord);
        }
        BuildConfigSetRecord buildConfigSetRecord1 = BuildConfigSetRecord.Builder.newBuilder().id(Integer.valueOf(this.datastore.getNextBuildConfigSetRecordId())).buildConfigurationSet(this.buildConfigurationSet1).startTime(Timestamp.from(Instant.now())).endTime(Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.FAILED).build();
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord1);
        BuildConfigSetRecord buildConfigSetRecord2 = BuildConfigSetRecord.Builder.newBuilder().id(Integer.valueOf(this.datastore.getNextBuildConfigSetRecordId())).buildConfigurationSet(this.buildConfigurationSet1).buildRecords(buildRecords).startTime(Timestamp.from(Instant.now())).endTime(Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.SUCCESS).build();
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord2);
    }

    private Environment createAndPersistDefultEnvironment() {
        Environment environment = Environment.Builder.defaultEnvironment().build();
        return (Environment)this.environmentRepository.save((GenericEntity)environment);
    }
}

