/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.demo.data;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.jboss.pnc.datastore.repositories.SequenceHandlerRepository;
import org.jboss.pnc.datastore.repositories.internal.BuildConfigurationAuditedSpringRepository;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.ArtifactQuality;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductRelease;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.model.Project;
import org.jboss.pnc.model.RepositoryType;
import org.jboss.pnc.model.SystemImageType;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.datastore.Datastore;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildEnvironmentRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductReleaseRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductVersionRepository;
import org.jboss.pnc.spi.datastore.repositories.ProjectRepository;
import org.jboss.pnc.spi.datastore.repositories.UserRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@Singleton
public class DatabaseDataInitializer {
    public static final Logger log = Logger.getLogger(DatabaseDataInitializer.class.getName());
    private static final String PNC_PRODUCT_NAME = "Project Newcastle Demo Product";
    private static final String PNC_PRODUCT_VERSION_1 = "1.0";
    private static final String PNC_PRODUCT_VERSION_2 = "2.0";
    private static final String PNC_PRODUCT_RELEASE = "1.0.0.GA";
    private static final String PNC_PRODUCT_MILESTONE1 = "1.0.0.Build1";
    private static final String PNC_PRODUCT_MILESTONE2 = "1.0.0.Build2";
    private static final String PNC_PROJECT_1_NAME = "Project Newcastle Demo Project 1";
    private static final String PNC_PROJECT_BUILD_CFG_ID = "pnc-1.0.0.DR1";
    @Inject
    ArtifactRepository artifactRepository;
    @Inject
    ProjectRepository projectRepository;
    @Inject
    ProductRepository productRepository;
    @Inject
    BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    BuildConfigurationAuditedSpringRepository buildConfigurationAuditedRepository;
    @Inject
    ProductVersionRepository productVersionRepository;
    @Inject
    ProductMilestoneRepository productMilestoneRepository;
    @Inject
    ProductReleaseRepository productReleaseRepository;
    @Inject
    BuildConfigurationSetRepository buildConfigurationSetRepository;
    @Inject
    UserRepository userRepository;
    @Inject
    BuildRecordRepository buildRecordRepository;
    @Inject
    BuildConfigSetRecordRepository buildConfigSetRecordRepository;
    @Inject
    BuildEnvironmentRepository environmentRepository;
    @Inject
    SequenceHandlerRepository sequenceHandlerRepository;
    @Inject
    Datastore datastore;
    BuildConfiguration buildConfiguration1;
    BuildConfiguration buildConfiguration2;
    BuildConfigurationSet buildConfigurationSet1;
    ProductMilestone demoProductMilestone1;
    User demoUser;
    User pncAdminUser;

    public void verifyData() {
        Preconditions.checkState((this.projectRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Projects > 0");
        Preconditions.checkState((this.productRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Products > 0");
        Preconditions.checkState((this.buildConfigurationRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of BuildConfigurations > 0");
        Preconditions.checkState((this.productVersionRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of ProductVersions > 0");
        Preconditions.checkState((this.buildConfigurationSetRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of BuildRepositorySets > 0");
        Preconditions.checkState((this.artifactRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Artifacts > 0");
        BuildConfiguration buildConfigurationDB = (BuildConfiguration)this.buildConfigurationRepository.queryAll().get(0);
        Preconditions.checkState((((BuildConfigurationSet)buildConfigurationDB.getBuildConfigurationSets().iterator().next()).getProductVersion() != null ? 1 : 0) != 0, (Object)"Product version of buildConfiguration must be not null");
        BuildConfigurationSet buildConfigurationSetDB = (BuildConfigurationSet)this.buildConfigurationSetRepository.queryAll().get(0);
        Preconditions.checkState((buildConfigurationSetDB.getProductVersion() != null ? 1 : 0) != 0, (Object)"Product version of buildConfigurationSet must be not null");
        Preconditions.checkState((boolean)buildConfigurationSetDB.getProductVersion().getProduct().getName().equals(PNC_PRODUCT_NAME), (Object)"Product mapped to Project must be Project Newcastle Demo Product");
        Preconditions.checkState((boolean)buildConfigurationSetDB.getProductVersion().getVersion().equals(PNC_PRODUCT_VERSION_1), (Object)"Product version mapped to Project must be 1.0");
        Preconditions.checkState((boolean)((BuildConfigurationSet)buildConfigurationDB.getBuildConfigurationSets().iterator().next()).getProductVersion().getVersion().equals(PNC_PRODUCT_VERSION_1), (Object)"Product version mapped to BuildConfiguration must be 1.0");
        Preconditions.checkState((boolean)((BuildConfigurationSet)buildConfigurationDB.getBuildConfigurationSets().iterator().next()).getProductVersion().getProduct().getName().equals(PNC_PRODUCT_NAME), (Object)"Product mapped to BuildConfiguration must be Project Newcastle Demo Product");
        Preconditions.checkState((boolean)buildConfigurationDB.getProject().getName().equals(PNC_PROJECT_1_NAME), (Object)"Project mapped to BuildConfiguration must be Project Newcastle Demo Project 1");
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void initiliazeProjectProductData() {
        BuildEnvironment environment1Unsaved = BuildEnvironment.Builder.newBuilder().name("Demo Environment 1").description("Basic Java and Maven Environment").attribute("JDK", "1.7.0").attribute("OS", "Linux").systemImageId("12345678").systemImageRepositoryUrl("my.registry/newcastle").systemImageType(SystemImageType.DOCKER_IMAGE).build();
        BuildEnvironment environment1 = (BuildEnvironment)this.environmentRepository.save((GenericEntity)environment1Unsaved);
        Product product = Product.Builder.newBuilder().name(PNC_PRODUCT_NAME).abbreviation("PNC").description("Example Product for Project Newcastle Demo").productCode("PNC").pgmSystemName("newcastle").build();
        product = (Product)this.productRepository.save((GenericEntity)product);
        ProductVersion productVersion1 = ProductVersion.Builder.newBuilder().version(PNC_PRODUCT_VERSION_1).product(product).build();
        productVersion1 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion1);
        ProductVersion productVersion2 = ProductVersion.Builder.newBuilder().version(PNC_PRODUCT_VERSION_2).product(product).build();
        productVersion2 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion2);
        int DAYS_IN_A_WEEK = 7;
        Date TODAY = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Date ONE_WEEK_BEFORE_TODAY = Date.from(LocalDateTime.now().minusDays(7L).atZone(ZoneId.systemDefault()).toInstant());
        Date ONE_WEEK_AFTER_TODAY = Date.from(LocalDateTime.now().plusDays(7L).atZone(ZoneId.systemDefault()).toInstant());
        this.demoProductMilestone1 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE1).startingDate(ONE_WEEK_BEFORE_TODAY).plannedEndDate(TODAY).productVersion(productVersion1).build();
        this.demoProductMilestone1 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone1);
        ProductMilestone demoProductMilestone2 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE2).startingDate(TODAY).plannedEndDate(ONE_WEEK_AFTER_TODAY).productVersion(productVersion1).build();
        demoProductMilestone2 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)demoProductMilestone2);
        ProductRelease productRelease = ProductRelease.Builder.newBuilder().version(PNC_PRODUCT_RELEASE).productMilestone(this.demoProductMilestone1).supportLevel(ProductRelease.SupportLevel.EARLYACCESS).build();
        productRelease = (ProductRelease)this.productReleaseRepository.save((GenericEntity)productRelease);
        productVersion1.setCurrentProductMilestone(this.demoProductMilestone1);
        productVersion1 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion1);
        Project project1 = Project.Builder.newBuilder().name(PNC_PROJECT_1_NAME).description("Example Project for Newcastle Demo").projectUrl("https://github.com/project-ncl/pnc").build();
        Project project2 = Project.Builder.newBuilder().name("JBoss Modules").description("JBoss Modules Project").projectUrl("https://github.com/jboss-modules/jboss-modules").issueTrackerUrl("https://issues.jboss.org/browse/MODULES").build();
        Project project3 = Project.Builder.newBuilder().name("JBoss JavaEE Servlet Spec API").description("JavaEE Servlet Spec API").projectUrl("https://github.com/jboss/jboss-servlet-api_spec").issueTrackerUrl("https://issues.jboss.org/browse/JBEE").build();
        Project project4 = Project.Builder.newBuilder().name("Fabric8").description("Integration platform for working with Apache ActiveMQ, Camel, CXF and Karaf in the cloud").projectUrl("https://github.com/fabric8io/fabric8").issueTrackerUrl("https://github.com/fabric8io/fabric8/issues").build();
        Project project5 = Project.Builder.newBuilder().name("Maven Plugin Test").description("Sample Maven Project with plugins and external downloads").projectUrl("https://github.com/rnc/mvn-plugin-test").build();
        this.projectRepository.save((GenericEntity)project1);
        this.projectRepository.save((GenericEntity)project2);
        this.projectRepository.save((GenericEntity)project3);
        this.projectRepository.save((GenericEntity)project4);
        this.projectRepository.save((GenericEntity)project5);
        this.buildConfiguration1 = BuildConfiguration.Builder.newBuilder().name(PNC_PROJECT_BUILD_CFG_ID).project(project1).description("Test build config for project newcastle").buildEnvironment(environment1).buildScript("mvn clean deploy -DskipTests=true").scmRepoURL("https://github.com/project-ncl/pnc.git").productVersion(productVersion1).scmRevision("*/v0.2").build();
        this.buildConfiguration1 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)this.buildConfiguration1);
        this.buildConfiguration2 = BuildConfiguration.Builder.newBuilder().name("jboss-modules-1.5.0").project(project2).description("Test config for JBoss modules build master branch.").buildEnvironment(environment1).buildScript("mvn clean deploy -DskipTests=true").productVersion(productVersion1).scmRepoURL("https://github.com/jboss-modules/jboss-modules.git").scmRevision("9e7115771a791feaa5be23b1255416197f2cda38").build();
        this.buildConfiguration2 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)this.buildConfiguration2);
        BuildConfiguration buildConfiguration3 = BuildConfiguration.Builder.newBuilder().name("jboss-servlet-spec-api-1.0.1").project(project3).description("Test build for jboss java servlet api").buildEnvironment(environment1).buildScript("mvn clean deploy -DskipTests=true").productVersion(productVersion2).scmRepoURL("https://github.com/jboss/jboss-servlet-api_spec.git").dependency(this.buildConfiguration2).build();
        buildConfiguration3 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration3);
        BuildConfiguration buildConfiguration4 = BuildConfiguration.Builder.newBuilder().name("io-fabric8-2.2-SNAPSHOT").project(project4).description("Test build for Fabric8").buildEnvironment(environment1).buildScript("mvn clean deploy -DskipTests=true").scmRepoURL("https://github.com/fabric8io/fabric8.git").build();
        buildConfiguration4 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration4);
        BuildConfiguration buildConfiguration5 = BuildConfiguration.Builder.newBuilder().name("maven-plugin-test").project(project5).description("Test build for Plugins with external downloads").buildEnvironment(environment1).buildScript("mvn clean deploy").scmRepoURL("https://github.com/rnc/mvn-plugin-test.git").build();
        buildConfiguration5 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration5);
        this.buildConfigurationSet1 = BuildConfigurationSet.Builder.newBuilder().name("Example Build Group 1").buildConfiguration(this.buildConfiguration1).buildConfiguration(this.buildConfiguration2).buildConfiguration(buildConfiguration3).productVersion(productVersion1).build();
        BuildConfigurationSet buildConfigurationSet2 = BuildConfigurationSet.Builder.newBuilder().name("Fabric Build Group").buildConfiguration(buildConfiguration4).productVersion(productVersion1).build();
        this.demoUser = User.Builder.newBuilder().username("demo-user").firstName("Demo First Name").lastName("Demo Last Name").email("demo-user@pnc.com").build();
        this.pncAdminUser = User.Builder.newBuilder().username("pnc-admin").firstName("pnc-admin").lastName("pnc-admin").email("pnc-admin@pnc.com").build();
        this.buildConfigurationSetRepository.save((GenericEntity)this.buildConfigurationSet1);
        this.buildConfigurationSetRepository.save((GenericEntity)buildConfigurationSet2);
        this.demoUser = (User)this.userRepository.save((GenericEntity)this.demoUser);
        this.pncAdminUser = (User)this.userRepository.save((GenericEntity)this.pncAdminUser);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void initiliazeBuildRecordDemoData() {
        Artifact builtArtifact1 = Artifact.Builder.newBuilder().identifier("demo:built-artifact1:jar:1.0").artifactQuality(ArtifactQuality.BUILT).repoType(RepositoryType.MAVEN).filename("demo built artifact 1").checksum("abcd1234").build();
        Artifact builtArtifact2 = Artifact.Builder.newBuilder().identifier("demo:built-artifact2:jar:1.0").artifactQuality(ArtifactQuality.BUILT).repoType(RepositoryType.MAVEN).filename("demo built artifact 2").checksum("abcd2345").build();
        builtArtifact1 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact1);
        builtArtifact2 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact2);
        Artifact importedArtifact1 = Artifact.Builder.newBuilder().identifier("demo:imported-artifact1:jar:1.0").repoType(RepositoryType.MAVEN).filename("demo imported artifact 1").originUrl("http://central/import1.jar").artifactQuality(ArtifactQuality.IMPORTED).importDate(Date.from(Instant.now())).checksum("abcd1234").deployUrl("http://google.pl/imported1").build();
        Artifact importedArtifact2 = Artifact.Builder.newBuilder().identifier("demo:imported-artifact2:jar:1.0").repoType(RepositoryType.MAVEN).filename("demo imported artifact 2").originUrl("http://central/import2.jar").artifactQuality(ArtifactQuality.IMPORTED).importDate(Date.from(Instant.now())).checksum("abcd1234").deployUrl("http://google.pl/imported2").build();
        importedArtifact1 = (Artifact)this.artifactRepository.save((GenericEntity)importedArtifact1);
        importedArtifact2 = (Artifact)this.artifactRepository.save((GenericEntity)importedArtifact2);
        HashSet<BuildRecord> buildRecords = new HashSet<BuildRecord>();
        boolean INITIAL_REVISION = true;
        IdRev buildConfig1AuditIdRev = new IdRev(this.buildConfiguration1.getId(), Integer.valueOf(1));
        BuildConfigurationAudited buildConfigAudited1 = (BuildConfigurationAudited)this.buildConfigurationAuditedRepository.findOne((Serializable)buildConfig1AuditIdRev);
        if (buildConfigAudited1 != null) {
            int nextId = this.datastore.getNextBuildRecordId();
            log.info("####nextId: " + nextId);
            BuildRecord buildRecord1 = BuildRecord.Builder.newBuilder().id(Integer.valueOf(nextId)).latestBuildConfiguration(this.buildConfiguration1).buildConfigurationAudited(buildConfigAudited1).submitTime((Date)Timestamp.from(Instant.now().minus(8L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(5L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now())).builtArtifact(builtArtifact1).builtArtifact(builtArtifact2).dependency(importedArtifact1).dependency(importedArtifact2).user(this.demoUser).buildLog("Very short demo log: The quick brown fox jumps over the lazy dog.").status(BuildStatus.SUCCESS).productMilestone(this.demoProductMilestone1).build();
            this.buildRecordRepository.save((GenericEntity)buildRecord1);
            buildRecords.add(buildRecord1);
        }
        Artifact builtArtifact3 = Artifact.Builder.newBuilder().identifier("demo:built-artifact3:jar:1.0").artifactQuality(ArtifactQuality.BUILT).repoType(RepositoryType.MAVEN).filename("demo built artifact 3").checksum("abcd1234").deployUrl("http://google.pl/built3").build();
        Artifact builtArtifact4 = Artifact.Builder.newBuilder().identifier("demo:built-artifact4:jar:1.0").artifactQuality(ArtifactQuality.BUILT).repoType(RepositoryType.MAVEN).filename("demo built artifact 4").checksum("abcd1234").deployUrl("http://google.pl/built4").build();
        builtArtifact3 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact3);
        builtArtifact4 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact4);
        Artifact dependencyBuiltArtifact1 = (Artifact)this.artifactRepository.queryByPredicates(new Predicate[]{ArtifactPredicates.withIdentifierAndChecksum((String)builtArtifact1.getIdentifier(), (String)builtArtifact1.getChecksum())});
        IdRev buildConfig2AuditIdRev = new IdRev(this.buildConfiguration2.getId(), Integer.valueOf(1));
        BuildConfigurationAudited buildConfigAudited2 = (BuildConfigurationAudited)this.buildConfigurationAuditedRepository.findOne((Serializable)buildConfig2AuditIdRev);
        if (buildConfigAudited2 != null) {
            int nextId = this.datastore.getNextBuildRecordId();
            log.info("####nextId: " + nextId);
            BuildRecord buildRecord2 = BuildRecord.Builder.newBuilder().id(Integer.valueOf(nextId)).latestBuildConfiguration(this.buildConfiguration2).buildConfigurationAudited(buildConfigAudited2).submitTime((Date)Timestamp.from(Instant.now().minus(8L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(5L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now())).builtArtifact(builtArtifact3).builtArtifact(builtArtifact4).dependency(dependencyBuiltArtifact1).dependency(importedArtifact1).user(this.demoUser).buildLog("Very short demo log: The quick brown fox jumps over the lazy dog.").status(BuildStatus.SUCCESS).build();
            this.buildRecordRepository.save((GenericEntity)buildRecord2);
            buildRecords.add(buildRecord2);
        }
        BuildConfigSetRecord buildConfigSetRecord1 = BuildConfigSetRecord.Builder.newBuilder().buildConfigurationSet(this.buildConfigurationSet1).startTime((Date)Timestamp.from(Instant.now())).endTime((Date)Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.FAILED).build();
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord1);
        BuildConfigSetRecord buildConfigSetRecord2 = BuildConfigSetRecord.Builder.newBuilder().buildConfigurationSet(this.buildConfigurationSet1).buildRecords(buildRecords).startTime((Date)Timestamp.from(Instant.now())).endTime((Date)Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.SUCCESS).build();
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord2);
        this.demoProductMilestone1 = (ProductMilestone)this.productMilestoneRepository.queryById((Serializable)this.demoProductMilestone1.getId());
        this.demoProductMilestone1.addDistributedArtifact(builtArtifact1);
        this.demoProductMilestone1.addDistributedArtifact(builtArtifact3);
        this.demoProductMilestone1.addDistributedArtifact(importedArtifact2);
        this.demoProductMilestone1 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone1);
    }
}

