/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.demo.data;

import java.lang.invoke.MethodHandles;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.moduleconfig.DemoDataConfig;
import org.jboss.pnc.common.json.moduleprovider.ConfigProvider;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.jboss.pnc.demo.data.DatabaseDataInitializer;
import org.jboss.pnc.spi.datastore.repositories.ProjectRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@Singleton
@Startup
public class DemoDataInitializer {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    Configuration configuration;
    @Inject
    DatabaseDataInitializer dbDataInitializer;
    @Inject
    ProjectRepository projectRepository;

    @PostConstruct
    public void initialize() {
        DemoDataConfig demoDataConfig = null;
        try {
            demoDataConfig = (DemoDataConfig)this.configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(DemoDataConfig.class));
        }
        catch (ConfigurationParseException e) {
            logger.warn((Object)"Cannot read demo data config.", (Throwable)e);
        }
        if (demoDataConfig == null || !demoDataConfig.getImportDemoData().booleanValue()) {
            logger.info((Object)"Demo data import is not enabled.");
            return;
        }
        long numberOfProjectInDB = this.projectRepository.count(new Predicate[0]);
        if (numberOfProjectInDB != 0L) {
            logger.info((Object)("There are >0 ({}) projects in DB. Skipping initialization." + numberOfProjectInDB));
        } else {
            logger.info((Object)"Initializing DEMO data");
            this.dbDataInitializer.initiliazeProjectProductData();
            this.dbDataInitializer.initiliazeBuildRecordDemoData();
            this.dbDataInitializer.verifyData();
            logger.info((Object)"Finished initializing DEMO data");
        }
    }
}

