/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.demo.data;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.common.json.moduleconfig.DemoDataConfig;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.BuildCategory;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.enums.BuildType;
import org.jboss.pnc.enums.MilestoneCloseStatus;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.enums.SupportLevel;
import org.jboss.pnc.enums.SystemImageType;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductMilestoneRelease;
import org.jboss.pnc.model.ProductRelease;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.model.Project;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.model.TargetRepository;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.datastore.Datastore;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildEnvironmentRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneReleaseRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductReleaseRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductVersionRepository;
import org.jboss.pnc.spi.datastore.repositories.ProjectRepository;
import org.jboss.pnc.spi.datastore.repositories.RepositoryConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.SequenceHandlerRepository;
import org.jboss.pnc.spi.datastore.repositories.TargetRepositoryRepository;
import org.jboss.pnc.spi.datastore.repositories.UserRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@Singleton
public class DatabaseDataInitializer {
    public static final Logger log = Logger.getLogger(DatabaseDataInitializer.class.getName());
    public static final String PNC_PRODUCT_NAME = "Project Newcastle Demo Product";
    public static final String PNC_PRODUCT_VERSION_1 = "1.0";
    public static final String PNC_PRODUCT_VERSION_2 = "2.0";
    public static final String PNC_PRODUCT_RELEASE = "1.0.0.GA";
    public static final String PNC_PRODUCT_MILESTONE1 = "1.0.0.Build1";
    public static final String PNC_PRODUCT_MILESTONE2 = "1.0.0.Build2";
    public static final String PNC_PRODUCT_MILESTONE3 = "1.0.0.Build3";
    public static final String PNC_PRODUCT_MILESTONE4 = "1.0.0.Build4";
    public static final String PNC_PROJECT_1_NAME = "Project Newcastle Demo Project 1";
    public static final String PNC_PROJECT_BUILD_CFG_ID = "pnc-1.0.0.DR1";
    @Inject
    private ArtifactRepository artifactRepository;
    @Inject
    private ArtifactAuditedRepository artifactAuditedRepository;
    @Inject
    private TargetRepositoryRepository targetRepositoryRepository;
    @Inject
    private ProjectRepository projectRepository;
    @Inject
    private ProductRepository productRepository;
    @Inject
    private RepositoryConfigurationRepository repositoryConfigurationRepository;
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    @Inject
    private ProductVersionRepository productVersionRepository;
    @Inject
    private ProductMilestoneRepository productMilestoneRepository;
    @Inject
    private ProductMilestoneReleaseRepository productMilestoneReleaseRepository;
    @Inject
    private ProductReleaseRepository productReleaseRepository;
    @Inject
    private BuildConfigurationSetRepository buildConfigurationSetRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private BuildRecordRepository buildRecordRepository;
    @Inject
    private BuildConfigSetRecordRepository buildConfigSetRecordRepository;
    @Inject
    private BuildEnvironmentRepository environmentRepository;
    @Inject
    private SequenceHandlerRepository sequenceHandlerRepository;
    @Inject
    private Datastore datastore;
    @Inject
    DemoDataConfig demoDataConfig;
    @Inject
    SystemConfig systemConfig;
    BuildConfiguration buildConfiguration1;
    BuildConfiguration buildConfiguration2;
    BuildConfigurationSet buildConfigurationSet1;
    ProductMilestone demoProductMilestone1;
    User demoUser;
    User pncAdminUser;

    public void verifyData() {
        Preconditions.checkState((this.projectRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Projects > 0");
        Preconditions.checkState((this.productRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Products > 0");
        Preconditions.checkState((this.buildConfigurationRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of BuildConfigurations > 0");
        Preconditions.checkState((this.productVersionRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of ProductVersions > 0");
        Preconditions.checkState((this.buildConfigurationSetRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of BuildRepositorySets > 0");
        Preconditions.checkState((this.artifactRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Artifacts > 0");
        BuildConfiguration buildConfigurationDB = (BuildConfiguration)this.buildConfigurationRepository.queryAll().get(0);
        BuildConfigurationSet buildConfigurationSet = (BuildConfigurationSet)buildConfigurationDB.getBuildConfigurationSets().iterator().next();
        Preconditions.checkState((buildConfigurationSet.getProductVersion() != null ? 1 : 0) != 0, (Object)"Product version of buildConfiguration must be not null");
        BuildConfigurationSet buildConfigurationSetDB = (BuildConfigurationSet)this.buildConfigurationSetRepository.queryAll().get(0);
        Preconditions.checkState((buildConfigurationSetDB.getProductVersion() != null ? 1 : 0) != 0, (Object)"Product version of buildConfigurationSet must be not null");
        Preconditions.checkState((boolean)buildConfigurationSetDB.getProductVersion().getProduct().getName().equals(PNC_PRODUCT_NAME), (Object)"Product mapped to Project must be Project Newcastle Demo Product");
        Preconditions.checkState((boolean)buildConfigurationSetDB.getProductVersion().getVersion().equals(PNC_PRODUCT_VERSION_1), (Object)"Product version mapped to Project must be 1.0");
        Preconditions.checkState((boolean)buildConfigurationSet.getProductVersion().getVersion().equals(PNC_PRODUCT_VERSION_1), (Object)"Product version mapped to BuildConfiguration must be 1.0");
        Preconditions.checkState((boolean)buildConfigurationSet.getProductVersion().getProduct().getName().equals(PNC_PRODUCT_NAME), (Object)"Product mapped to BuildConfiguration must be Project Newcastle Demo Product");
        Preconditions.checkState((boolean)buildConfigurationDB.getProject().getName().equals(PNC_PROJECT_1_NAME), (Object)"Project mapped to BuildConfiguration must be Project Newcastle Demo Project 1");
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void initiliazeProjectProductData() {
        BuildEnvironment environment1Unsaved = BuildEnvironment.Builder.newBuilder().name("Demo Environment 1").description("Basic Java and Maven Environment").attribute("JDK", "1.7.0").attribute("OS", "Linux").systemImageId("12345678").systemImageRepositoryUrl("my.registry/newcastle").systemImageType(SystemImageType.DOCKER_IMAGE).deprecated(false).build();
        BuildEnvironment environment1 = (BuildEnvironment)this.environmentRepository.save((GenericEntity)environment1Unsaved);
        BuildEnvironment environment2Unsaved = BuildEnvironment.Builder.newBuilder().name("Demo Environment 2").description("Basic Java and Maven Environment").attribute("JDK", "1.7.0").attribute("OS", "Linux").systemImageId("12345679").systemImageRepositoryUrl("my.registry/newcastle").systemImageType(SystemImageType.DOCKER_IMAGE).deprecated(true).build();
        BuildEnvironment environment2 = (BuildEnvironment)this.environmentRepository.save((GenericEntity)environment2Unsaved);
        Product product = Product.Builder.newBuilder().name(PNC_PRODUCT_NAME).abbreviation("PNC").description("Example Product for Project Newcastle Demo").build();
        product = (Product)this.productRepository.save((GenericEntity)product);
        ProductVersion productVersion1 = ProductVersion.Builder.newBuilder().version(PNC_PRODUCT_VERSION_1).product(product).generateBrewTagPrefix(product.getAbbreviation(), PNC_PRODUCT_VERSION_1, this.systemConfig.getBrewTagPattern()).build();
        productVersion1 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion1);
        ProductVersion productVersion2 = ProductVersion.Builder.newBuilder().version(PNC_PRODUCT_VERSION_2).product(product).generateBrewTagPrefix(product.getAbbreviation(), PNC_PRODUCT_VERSION_2, this.systemConfig.getBrewTagPattern()).build();
        productVersion2 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion2);
        int DAYS_IN_A_WEEK = 7;
        Date TODAY = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Date ONE_WEEK_BEFORE_TODAY = Date.from(LocalDateTime.now().minusDays(7L).atZone(ZoneId.systemDefault()).toInstant());
        Date ONE_WEEK_AFTER_TODAY = Date.from(LocalDateTime.now().plusDays(7L).atZone(ZoneId.systemDefault()).toInstant());
        this.demoProductMilestone1 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE1).startingDate(ONE_WEEK_BEFORE_TODAY).plannedEndDate(TODAY).productVersion(productVersion1).build();
        this.demoProductMilestone1 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone1);
        ProductMilestone demoProductMilestone2 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE2).startingDate(TODAY).plannedEndDate(ONE_WEEK_AFTER_TODAY).productVersion(productVersion1).build();
        demoProductMilestone2 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)demoProductMilestone2);
        Instant t0 = TODAY.toInstant();
        Instant successTime = t0.plus(10L, ChronoUnit.MINUTES);
        ProductMilestone demoProductMilestone3 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE3).startingDate(TODAY).plannedEndDate(ONE_WEEK_AFTER_TODAY).endDate(ONE_WEEK_AFTER_TODAY).productVersion(productVersion1).build();
        demoProductMilestone3 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)demoProductMilestone3);
        ProductMilestone demoProductMilestone4 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE4).startingDate(TODAY).plannedEndDate(ONE_WEEK_AFTER_TODAY).endDate(ONE_WEEK_AFTER_TODAY).productVersion(productVersion1).build();
        demoProductMilestone4 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)demoProductMilestone4);
        ProductMilestoneRelease milestoneRelease1 = new ProductMilestoneRelease();
        milestoneRelease1.setId(Sequence.nextId());
        milestoneRelease1.setMilestone(demoProductMilestone3);
        milestoneRelease1.setStartingDate(Date.from(t0.plus(2L, ChronoUnit.MINUTES)));
        milestoneRelease1.setStatus(MilestoneCloseStatus.SYSTEM_ERROR);
        this.productMilestoneReleaseRepository.save((GenericEntity)milestoneRelease1);
        ProductMilestoneRelease milestoneRelease2 = new ProductMilestoneRelease();
        milestoneRelease2.setId(Sequence.nextId());
        milestoneRelease2.setMilestone(demoProductMilestone3);
        milestoneRelease2.setStartingDate(Date.from(t0));
        milestoneRelease2.setStatus(MilestoneCloseStatus.FAILED);
        this.productMilestoneReleaseRepository.save((GenericEntity)milestoneRelease2);
        ProductMilestoneRelease milestoneRelease3 = new ProductMilestoneRelease();
        milestoneRelease3.setId(Sequence.nextId());
        milestoneRelease3.setMilestone(demoProductMilestone3);
        milestoneRelease3.setStartingDate(Date.from(successTime));
        milestoneRelease3.setStatus(MilestoneCloseStatus.SUCCEEDED);
        this.productMilestoneReleaseRepository.save((GenericEntity)milestoneRelease3);
        ProductRelease productRelease = ProductRelease.Builder.newBuilder().version(PNC_PRODUCT_RELEASE).productMilestone(this.demoProductMilestone1).supportLevel(SupportLevel.EARLYACCESS).build();
        productRelease = (ProductRelease)this.productReleaseRepository.save((GenericEntity)productRelease);
        productVersion1.setCurrentProductMilestone(demoProductMilestone3);
        productVersion1 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion1);
        Project project1 = Project.Builder.newBuilder().name(PNC_PROJECT_1_NAME).description("Example Project for Newcastle Demo").projectUrl("https://github.com/project-ncl/pnc").build();
        Project project2 = Project.Builder.newBuilder().name("Causeway").description("Causeway - Koji integration").projectUrl("https://github.com/project-ncl/causeway").build();
        Project project3 = Project.Builder.newBuilder().name("Pnc Build Agent").description("Pnc Build Agent - remote client to execute commands.").projectUrl("https://github.com/project-ncl/pnc-build-agent").build();
        Project project4 = Project.Builder.newBuilder().name("Dependency Analysis").description("Dependency Analysis - Analise project dependencies.").projectUrl("https://github.com/project-ncl/dependency-analysis").build();
        Project project5 = Project.Builder.newBuilder().name("termd").description("Remote shell.").projectUrl("https://github.com/project-ncl/termd").build();
        this.projectRepository.save((GenericEntity)project1);
        this.projectRepository.save((GenericEntity)project2);
        this.projectRepository.save((GenericEntity)project3);
        this.projectRepository.save((GenericEntity)project4);
        this.projectRepository.save((GenericEntity)project5);
        RepositoryConfiguration repositoryConfiguration1 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(0), "https://github.com/project-ncl/pnc.git");
        RepositoryConfiguration repositoryConfiguration2 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(1), null);
        RepositoryConfiguration repositoryConfiguration3 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(2), null);
        RepositoryConfiguration repositoryConfiguration4 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(3), null);
        RepositoryConfiguration repositoryConfiguration5 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(4), null);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration1);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration2);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration3);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration4);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration5);
        HashMap<String, String> genericParameters = new HashMap<String, String>();
        genericParameters.put("KEY", "VALUE");
        this.buildConfiguration1 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name(PNC_PROJECT_BUILD_CFG_ID).project(project1).description("Test build config for project newcastle").buildType(BuildType.MVN).buildEnvironment(environment1).buildScript("mvn deploy -DskipTests=true").repositoryConfiguration(repositoryConfiguration1).productVersion(productVersion1).scmRevision("*/v0.2").genericParameters(genericParameters).build();
        this.buildConfiguration1 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)this.buildConfiguration1);
        this.buildConfiguration2 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name("termd").project(project2).buildType(BuildType.MVN).description("Test configueration for Termd.").buildEnvironment(environment1).buildScript("mvn deploy -DskipTests=true").productVersion(productVersion1).repositoryConfiguration(repositoryConfiguration2).scmRevision("master").build();
        this.buildConfiguration2 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)this.buildConfiguration2);
        BuildConfiguration buildConfiguration3 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name("pnc-build-agent-0.4").project(project3).description("Test config for Pnc Build Agent.").buildType(BuildType.MVN).buildEnvironment(environment1).buildScript("mvn deploy -DskipTests=true").productVersion(productVersion2).repositoryConfiguration(repositoryConfiguration3).dependency(this.buildConfiguration2).build();
        buildConfiguration3 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration3);
        BuildConfiguration buildConfiguration4 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name("dependency-analysis-1.3").project(project4).description("Test config for Dependency Analysis.").buildType(BuildType.MVN).buildEnvironment(environment1).buildScript("mvn deploy -DskipTests=true").repositoryConfiguration(repositoryConfiguration4).dependency(this.buildConfiguration1).build();
        buildConfiguration4 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration4);
        BuildConfiguration buildConfiguration5 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name("maven-plugin-test").project(project5).description("Test build for Plugins with external downloads").buildType(BuildType.MVN).buildEnvironment(environment1).buildScript("mvn clean deploy").repositoryConfiguration(repositoryConfiguration5).build();
        buildConfiguration5 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration5);
        this.buildConfigurationSet1 = BuildConfigurationSet.Builder.newBuilder().name("Example-Build-Group-1").buildConfiguration(this.buildConfiguration1).buildConfiguration(this.buildConfiguration2).buildConfiguration(buildConfiguration3).productVersion(productVersion1).build();
        BuildConfigurationSet buildConfigurationSet2 = BuildConfigurationSet.Builder.newBuilder().name("Fabric-Build-Group").buildConfiguration(buildConfiguration4).productVersion(productVersion1).build();
        this.demoUser = User.Builder.newBuilder().username("demo-user").firstName("Demo First Name").lastName("Demo Last Name").email("demo-user@pnc.com").build();
        this.pncAdminUser = User.Builder.newBuilder().username("pnc-admin").firstName("pnc-admin").lastName("pnc-admin").email("pnc-admin@pnc.com").build();
        this.buildConfigurationSetRepository.save((GenericEntity)this.buildConfigurationSet1);
        this.buildConfigurationSetRepository.save((GenericEntity)buildConfigurationSet2);
        this.demoUser = (User)this.userRepository.save((GenericEntity)this.demoUser);
        this.pncAdminUser = (User)this.userRepository.save((GenericEntity)this.pncAdminUser);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void initiliazeBuildRecordDemoData() {
        TargetRepository targetRepository = TargetRepository.newBuilder().repositoryType(RepositoryType.MAVEN).repositoryPath("builds-untested").identifier("indy-maven").temporaryRepo(Boolean.valueOf(false)).build();
        TargetRepository targetRepository2 = TargetRepository.newBuilder().repositoryType(RepositoryType.NPM).repositoryPath("builds-tested").identifier("indy-npm").temporaryRepo(Boolean.valueOf(true)).build();
        this.targetRepositoryRepository.save((GenericEntity)targetRepository);
        this.targetRepositoryRepository.save((GenericEntity)targetRepository2);
        Artifact builtArtifact1 = Artifact.Builder.newBuilder().identifier("demo:built-artifact1:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 1").md5("4af310bf0ef67bc7d143f35818ea1ed2").sha1("3a8ff25c890f2a4a283876a91037ff6c57474a14").sha256("1660168483cb8a05d1cc2e77c861682a42ed9517ba945159d5538950c5db00fa").deployPath("demo/built-artifact1/1.0/built-artifact1-1.0.jar").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).buildCategory(BuildCategory.STANDARD).build();
        Artifact builtArtifact2 = Artifact.Builder.newBuilder().identifier("demo:built-artifact2:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 2").md5("4af310bf0ef67bc7d143f35818ea1ed2").sha1("61dad16e14438d2d8c8cbd18b267d62944f37898").sha256("2fafc2ed0f752ac2540283d48c5cd663254a853c5cb13dec02dce023fc7471a9").deployPath("demo/built-artifact2/1.0/built-artifact2-1.0.jar").size(Long.valueOf(11L)).artifactQuality(ArtifactQuality.VERIFIED).buildCategory(BuildCategory.STANDARD).build();
        Artifact builtArtifact3 = Artifact.Builder.newBuilder().identifier("demo:built-artifact11:pom:1.0").targetRepository(targetRepository2).filename("demo built artifact 11").md5("5c8e1503e77dc8e370610098e01f0a8e").sha1("550748f6f58ed8d4f6b63850a867ac207da30013").sha256("b39f88c9937f201981767e539025121971e72bc590ea20ed7fdfffafc05f55a9").deployPath("demo/built-artifact11/1.0/built-artifact11-1.0.pom").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.DELETED).buildCategory(BuildCategory.SERVICE).build();
        Artifact builtArtifact4 = Artifact.Builder.newBuilder().identifier("demo:built-artifact22:jar:1.0").targetRepository(targetRepository2).filename("demo built artifact 21").md5("48312fb24c7b2a116c2139d5b39bad66").sha1("6ce2fd75c35e7eed2c45338b943be34d0b974f16").sha256("61c9ccd3ba0013311ddb89cb9a29389b6761061bdcdfb48f0096bf98c7279a21").deployPath("demo/built-artifact22/1.0/built-artifact22-1.0.jar").size(Long.valueOf(11L)).artifactQuality(ArtifactQuality.NEW).buildCategory(BuildCategory.SERVICE).build();
        builtArtifact1 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact1);
        builtArtifact2 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact2);
        builtArtifact3 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact3);
        builtArtifact4 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact4);
        Artifact importedArtifact1 = Artifact.Builder.newBuilder().identifier("demo:imported-artifact1:jar:1.0").targetRepository(targetRepository).filename("demo imported artifact 1").originUrl("http://central/import1.jar").importDate(Date.from(Instant.now())).md5("md-fake-abcd1234").sha1("sha1-fake-abcd1234").sha256("sha256-fake-abcd1234").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).buildCategory(BuildCategory.STANDARD).deployPath("/imported1").build();
        Artifact importedArtifact2 = Artifact.Builder.newBuilder().identifier("demo:imported-artifact2:jar:1.0").targetRepository(targetRepository).filename("demo imported artifact 2").originUrl("http://central/import2.jar").importDate(Date.from(Instant.now())).md5("md-fake-abcd1234").sha1("sha1-fake-abcd1234").sha256("sha256-fake-abcd1234").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).buildCategory(BuildCategory.STANDARD).deployPath("/imported2").build();
        importedArtifact1 = (Artifact)this.artifactRepository.save((GenericEntity)importedArtifact1);
        importedArtifact2 = (Artifact)this.artifactRepository.save((GenericEntity)importedArtifact2);
        HashSet<BuildRecord> buildRecords = new HashSet<BuildRecord>();
        boolean INITIAL_REVISION = true;
        IdRev buildConfig1AuditIdRev = new IdRev(this.buildConfiguration1.getId(), Integer.valueOf(1));
        BuildConfigurationAudited buildConfigAudited1 = this.buildConfigurationAuditedRepository.queryById(buildConfig1AuditIdRev);
        if (buildConfigAudited1 != null) {
            String nextId = Sequence.nextBase32Id();
            log.info("####nextId: " + nextId);
            BuildRecord buildRecord1 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfigAudited1).submitTime((Date)Timestamp.from(Instant.now().minus(8L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(5L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now())).dependency(importedArtifact1).dependency(importedArtifact2).user(this.pncAdminUser).repourLog("This is a wannabe alignment log.").buildLog("Very short demo log: The quick brown fox jumps over the lazy dog.").status(BuildStatus.SUCCESS).productMilestone(this.demoProductMilestone1).sshCommand("ssh worker@localhost -P 9999").sshPassword("dontchangeme").buildEnvironment(buildConfigAudited1.getBuildEnvironment()).scmRepoURL(buildConfigAudited1.getRepositoryConfiguration().getInternalUrl()).scmRevision(buildConfigAudited1.getScmRevision()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.3").temporaryBuild(false).build();
            log.info("Saving buildRecord1: " + buildRecord1);
            BuildRecord savedBuildRecord1 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)buildRecord1);
            builtArtifact1.setBuildRecord(savedBuildRecord1);
            builtArtifact2.setBuildRecord(savedBuildRecord1);
            log.info("Saved buildRecord1: " + savedBuildRecord1 + "BuildConfigurationAuditedIdRev: " + savedBuildRecord1.getBuildConfigurationAuditedIdRev());
            buildRecords.add(buildRecord1);
            nextId = Sequence.nextBase32Id();
            log.info("####nextId: " + nextId);
            BuildRecord tempRecord1 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfigAudited1).submitTime((Date)Timestamp.from(Instant.now())).startTime((Date)Timestamp.from(Instant.now())).endTime((Date)Timestamp.from(Instant.now())).user(this.pncAdminUser).repourLog("This is a wannabe alignment log.").buildLog("Very short demo log: The quick brown fox jumps over the lazy dog.").status(BuildStatus.SUCCESS).buildEnvironment(buildConfigAudited1.getBuildEnvironment()).scmRepoURL(buildConfigAudited1.getRepositoryConfiguration().getInternalUrl()).scmRevision(buildConfigAudited1.getScmRevision()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.3").temporaryBuild(true).build();
            log.info("Saving tempRecord1: " + tempRecord1);
            BuildRecord savedTempRecord1 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)tempRecord1);
            builtArtifact3.setBuildRecord(savedTempRecord1);
            builtArtifact4.setBuildRecord(savedTempRecord1);
            log.info("Saved buildRecord1: " + savedTempRecord1 + "BuildConfigurationAuditedIdRev: " + savedTempRecord1.getBuildConfigurationAuditedIdRev());
            buildRecords.add(tempRecord1);
        }
        Artifact builtArtifact5 = Artifact.Builder.newBuilder().identifier("demo:built-artifact3:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 3").md5("17353a18678c6c249e3052edec2e4c5c").sha1("61dad16e14438d2d8c8cbd18b267d62944f37898").sha256("1660168483cb8a05d1cc2e77c861682a42ed9517ba945159d5538950c5db00fa").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built3").build();
        Artifact builtArtifact6 = Artifact.Builder.newBuilder().identifier("demo:built-artifact4:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 4").md5("md-fake-abcd1234").sha1("sha1-fake-abcd1234").sha256("sha256-fake-abcd1234").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built4").build();
        Artifact builtArtifact7 = Artifact.Builder.newBuilder().identifier("demo:built-artifact5:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 7").md5("adsfs6df548w1327cx78he873217df98").sha1("a56asdf87a3cvx231b87987fasd6f5ads4f32sdf").sha256("sad5f64sf87b3cvx2b1v87tr89h7d3f5g432xcz1zv87fawrv23n8796534564er").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built5").build();
        Artifact builtArtifact8 = Artifact.Builder.newBuilder().identifier("demo:built-artifact6:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 8").md5("md-fake-abcdefg1234").sha1("sha1-fake-abcdefg1234").sha256("sha256-fake-abcdefg1234").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built6").build();
        builtArtifact5 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact5);
        builtArtifact6 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact6);
        builtArtifact7 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact7);
        builtArtifact8 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact8);
        Artifact dependencyBuiltArtifact1 = (Artifact)this.artifactRepository.queryByPredicates(new Predicate[]{ArtifactPredicates.withIdentifierAndSha256((String)builtArtifact1.getIdentifier(), (String)builtArtifact1.getSha256())});
        Calendar calendar = Calendar.getInstance();
        calendar.set(2019, 0, 10);
        IdRev buildConfig2AuditIdRev = new IdRev(this.buildConfiguration2.getId(), Integer.valueOf(1));
        BuildConfigurationAudited buildConfigAudited2 = this.buildConfigurationAuditedRepository.queryById(buildConfig2AuditIdRev);
        if (buildConfigAudited2 != null) {
            String nextId = Sequence.nextBase32Id();
            log.info("####nextId: " + nextId);
            BuildRecord buildRecord2 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfigAudited2).submitTime((Date)Timestamp.from(Instant.now().minus(8L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(5L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now())).dependency(dependencyBuiltArtifact1).dependency(importedArtifact1).user(this.demoUser).buildLog("Very short demo log: The quick brown fox jumps over the lazy dog.").status(BuildStatus.SUCCESS).buildEnvironment(buildConfigAudited2.getBuildEnvironment()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.4").temporaryBuild(false).build();
            nextId = Sequence.nextBase32Id();
            log.info("####nextId: " + nextId);
            BuildRecord savedBuildRecord2 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)buildRecord2);
            builtArtifact5.setBuildRecord(savedBuildRecord2);
            builtArtifact6.setBuildRecord(savedBuildRecord2);
            buildRecords.add(buildRecord2);
            BuildRecord tempRecord1 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfigAudited2).submitTime((Date)Timestamp.from(calendar.toInstant().minus(8L, ChronoUnit.HOURS))).startTime((Date)Timestamp.from(calendar.toInstant().minus(5L, ChronoUnit.HOURS))).endTime((Date)Timestamp.from(calendar.toInstant())).user(this.demoUser).buildLog("Is it free?").status(BuildStatus.SUCCESS).buildEnvironment(buildConfigAudited2.getBuildEnvironment()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.4").temporaryBuild(true).build();
            BuildRecord savedTempRecord1 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)tempRecord1);
            builtArtifact7.setBuildRecord(savedTempRecord1);
            builtArtifact8.setBuildRecord(savedTempRecord1);
            buildRecords.add(tempRecord1);
        }
        BuildConfigSetRecord buildConfigSetRecord1 = BuildConfigSetRecord.Builder.newBuilder().buildConfigurationSet(this.buildConfigurationSet1).startTime((Date)Timestamp.from(Instant.now())).endTime((Date)Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.FAILED).temporaryBuild(false).build();
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord1);
        BuildConfigSetRecord buildConfigSetRecord2 = BuildConfigSetRecord.Builder.newBuilder().buildConfigurationSet(this.buildConfigurationSet1).buildRecords(buildRecords).startTime((Date)Timestamp.from(Instant.now())).endTime((Date)Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.SUCCESS).temporaryBuild(false).build();
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord2);
        BuildConfigSetRecord buildConfigSetRecord3 = BuildConfigSetRecord.Builder.newBuilder().buildConfigurationSet(this.buildConfigurationSet1).startTime((Date)Timestamp.from(calendar.toInstant().minus(20L, ChronoUnit.DAYS))).endTime((Date)Timestamp.from(calendar.toInstant().minus(20L, ChronoUnit.DAYS))).user(this.demoUser).status(BuildStatus.SUCCESS).temporaryBuild(true).build();
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord3);
        this.demoProductMilestone1 = (ProductMilestone)this.productMilestoneRepository.queryById((Serializable)this.demoProductMilestone1.getId());
        this.demoProductMilestone1.addDistributedArtifact(builtArtifact1);
        this.demoProductMilestone1.addDistributedArtifact(builtArtifact5);
        this.demoProductMilestone1.addDistributedArtifact(importedArtifact2);
        this.demoProductMilestone1 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone1);
    }

    private RepositoryConfiguration createRepositoryConfiguration(String internalScmUrl, String externalUrl) {
        return RepositoryConfiguration.Builder.newBuilder().internalUrl(internalScmUrl).externalUrl(externalUrl).build();
    }
}

