/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.demo.data;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.jboss.pnc.api.enums.DeliverableAnalyzerReportLabel;
import org.jboss.pnc.api.enums.LabelOperation;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.common.json.moduleconfig.DemoDataConfig;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.demo.data.BuildConfigurationAuditedHelper;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.BuildCategory;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.enums.BuildType;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.enums.SupportLevel;
import org.jboss.pnc.enums.SystemImageType;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.BuildPushOperation;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.DeliverableAnalyzerLabelEntry;
import org.jboss.pnc.model.DeliverableAnalyzerOperation;
import org.jboss.pnc.model.DeliverableAnalyzerReport;
import org.jboss.pnc.model.DeliverableArtifact;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductRelease;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.model.Project;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.model.TargetRepository;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.datastore.Datastore;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildEnvironmentRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildPushOperationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerLabelEntryRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerOperationRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerReportRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductReleaseRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductVersionRepository;
import org.jboss.pnc.spi.datastore.repositories.ProjectRepository;
import org.jboss.pnc.spi.datastore.repositories.RepositoryConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.SequenceHandlerRepository;
import org.jboss.pnc.spi.datastore.repositories.TargetRepositoryRepository;
import org.jboss.pnc.spi.datastore.repositories.UserRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@Singleton
public class DatabaseDataInitializer {
    public static final Logger log = Logger.getLogger(DatabaseDataInitializer.class.getName());
    public static final String PNC_PRODUCT_NAME = "Project Newcastle Demo Product";
    public static final String PNC_PRODUCT_VERSION_1 = "1.0";
    public static final String PNC_PRODUCT_VERSION_2 = "2.0";
    public static final String PNC_PRODUCT_RELEASE = "1.0.0.GA";
    public static final String PNC_PRODUCT_MILESTONE1 = "1.0.0.Build1";
    public static final String PNC_PRODUCT_MILESTONE2 = "1.0.0.Build2";
    public static final String PNC_PRODUCT_MILESTONE3 = "1.0.0.Build3";
    public static final String PNC_PRODUCT_MILESTONE4 = "1.0.0.Build4";
    public static final String PNC_PRODUCT_MILESTONE5 = "2.0.0.Build1";
    public static final String PNC_PROJECT_1_NAME = "Project Newcastle Demo Project 1";
    public static final String PNC_PROJECT_BUILD_CFG_ID = "pnc-1.0.0.DR1";
    public static final String EAP_PRODUCT_NAME = "JBoss EAP Demo Product";
    public static final String EAP_PRODUCT_VERSION = "7.0";
    public static final String EAP_PRODUCT_MILESTONE_1 = "7.0.0.Build1";
    public static final String EAP_PRODUCT_MILESTONE_2 = "7.0.0.Build2";
    public static final String EAP_PROJECT_NAME = "JBoss EAP Demo Project";
    public static final String EAP_PROJECT_BUILD_CFG_ID = "eap-7.0.0.CR1";
    @Inject
    private ArtifactRepository artifactRepository;
    @Inject
    private ArtifactAuditedRepository artifactAuditedRepository;
    @Inject
    private TargetRepositoryRepository targetRepositoryRepository;
    @Inject
    private ProjectRepository projectRepository;
    @Inject
    private ProductRepository productRepository;
    @Inject
    private RepositoryConfigurationRepository repositoryConfigurationRepository;
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    @Inject
    private ProductVersionRepository productVersionRepository;
    @Inject
    private ProductMilestoneRepository productMilestoneRepository;
    @Inject
    private ProductReleaseRepository productReleaseRepository;
    @Inject
    private BuildConfigurationSetRepository buildConfigurationSetRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private BuildRecordRepository buildRecordRepository;
    @Inject
    private BuildConfigSetRecordRepository buildConfigSetRecordRepository;
    @Inject
    private BuildEnvironmentRepository environmentRepository;
    @Inject
    private SequenceHandlerRepository sequenceHandlerRepository;
    @Inject
    private DeliverableAnalyzerOperationRepository deliverableAnalyzerOperationRepository;
    @Inject
    private DeliverableAnalyzerReportRepository deliverableAnalyzerReportRepository;
    @Inject
    private DeliverableArtifactRepository deliverableArtifactRepository;
    @Inject
    private DeliverableAnalyzerLabelEntryRepository deliverableAnalyzerLabelEntryRepository;
    @Inject
    private BuildPushOperationRepository buildPushOperationRepository;
    @Inject
    private Datastore datastore;
    @Inject
    DemoDataConfig demoDataConfig;
    @Inject
    SystemConfig systemConfig;
    @Inject
    BuildConfigurationAuditedHelper helper;
    BuildConfiguration buildConfiguration1;
    BuildConfiguration buildConfiguration2;
    BuildConfiguration buildConfiguration6;
    BuildConfigurationSet buildConfigurationSet1;
    ProductMilestone demoProductMilestone1;
    ProductMilestone demoProductMilestone2;
    ProductMilestone demoProductMilestone3;
    ProductMilestone demoProductMilestone5;
    ProductMilestone demoProductMilestone6;
    ProductMilestone demoProductMilestone7;
    User demoUser;
    User pncAdminUser;
    final int DAYS_IN_A_WEEK = 7;
    final Date TODAY = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    final Date ONE_WEEK_BEFORE_TODAY = Date.from(LocalDateTime.now().minusDays(7L).atZone(ZoneId.systemDefault()).toInstant());
    final Date ONE_WEEK_AFTER_TODAY = Date.from(LocalDateTime.now().plusDays(7L).atZone(ZoneId.systemDefault()).toInstant());

    public void verifyData() {
        Preconditions.checkState((this.projectRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Projects > 0");
        Preconditions.checkState((this.productRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Products > 0");
        Preconditions.checkState((this.buildConfigurationRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of BuildConfigurations > 0");
        Preconditions.checkState((this.productVersionRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of ProductVersions > 0");
        Preconditions.checkState((this.buildConfigurationSetRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of BuildRepositorySets > 0");
        Preconditions.checkState((this.artifactRepository.count(new Predicate[0]) > 0 ? 1 : 0) != 0, (Object)"Expecting number of Artifacts > 0");
        BuildConfiguration buildConfigurationDB = (BuildConfiguration)this.buildConfigurationRepository.queryAll().get(0);
        BuildConfigurationSet buildConfigurationSet = (BuildConfigurationSet)buildConfigurationDB.getBuildConfigurationSets().iterator().next();
        Preconditions.checkState((buildConfigurationSet.getProductVersion() != null ? 1 : 0) != 0, (Object)"Product version of buildConfiguration must be not null");
        BuildConfigurationSet buildConfigurationSetDB = (BuildConfigurationSet)this.buildConfigurationSetRepository.queryAll().get(0);
        Preconditions.checkState((buildConfigurationSetDB.getProductVersion() != null ? 1 : 0) != 0, (Object)"Product version of buildConfigurationSet must be not null");
        Preconditions.checkState((boolean)buildConfigurationSetDB.getProductVersion().getProduct().getName().equals(PNC_PRODUCT_NAME), (Object)"Product mapped to Project must be Project Newcastle Demo Product");
        Preconditions.checkState((boolean)buildConfigurationSetDB.getProductVersion().getVersion().equals(PNC_PRODUCT_VERSION_1), (Object)"Product version mapped to Project must be 1.0");
        Preconditions.checkState((boolean)buildConfigurationSet.getProductVersion().getVersion().equals(PNC_PRODUCT_VERSION_1), (Object)"Product version mapped to BuildConfiguration must be 1.0");
        Preconditions.checkState((boolean)buildConfigurationSet.getProductVersion().getProduct().getName().equals(PNC_PRODUCT_NAME), (Object)"Product mapped to BuildConfiguration must be Project Newcastle Demo Product");
        Preconditions.checkState((boolean)buildConfigurationDB.getProject().getName().equals(PNC_PROJECT_1_NAME), (Object)"Project mapped to BuildConfiguration must be Project Newcastle Demo Project 1");
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void initiliazeProjectProductData() {
        BuildEnvironment environment1Unsaved = BuildEnvironment.Builder.newBuilder().name("Demo Environment 1").description("Basic Java and Maven Environment").attribute("JDK", "1.7.0").attribute("OS", "Linux").systemImageId("12345678").systemImageRepositoryUrl("my.registry/newcastle").systemImageType(SystemImageType.DOCKER_IMAGE).deprecated(false).build();
        BuildEnvironment environment1 = (BuildEnvironment)this.environmentRepository.save((GenericEntity)environment1Unsaved);
        BuildEnvironment environment2Unsaved = BuildEnvironment.Builder.newBuilder().name("Demo Environment 2").description("Basic Java and Maven Environment").attribute("JDK", "1.7.0").attribute("OS", "Linux").systemImageId("12345679").systemImageRepositoryUrl("my.registry/newcastle").systemImageType(SystemImageType.DOCKER_IMAGE).deprecated(true).build();
        BuildEnvironment environment2 = (BuildEnvironment)this.environmentRepository.save((GenericEntity)environment2Unsaved);
        Product product1 = Product.Builder.newBuilder().name(PNC_PRODUCT_NAME).abbreviation("PNC").description("Example Product for Project Newcastle Demo").build();
        product1 = (Product)this.productRepository.save((GenericEntity)product1);
        Product product2 = Product.Builder.newBuilder().name(EAP_PRODUCT_NAME).abbreviation("EAP").description("Example Product for JBoss EAP Demo").build();
        product2 = (Product)this.productRepository.save((GenericEntity)product2);
        ProductVersion productVersion1 = ProductVersion.Builder.newBuilder().version(PNC_PRODUCT_VERSION_1).product(product1).generateBrewTagPrefix(product1.getAbbreviation(), PNC_PRODUCT_VERSION_1, this.systemConfig.getBrewTagPattern()).build();
        productVersion1 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion1);
        ProductVersion productVersion2 = ProductVersion.Builder.newBuilder().version(PNC_PRODUCT_VERSION_2).product(product1).generateBrewTagPrefix(product1.getAbbreviation(), PNC_PRODUCT_VERSION_2, this.systemConfig.getBrewTagPattern()).build();
        productVersion2 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion2);
        ProductVersion productVersion3 = ProductVersion.Builder.newBuilder().version(EAP_PRODUCT_VERSION).product(product2).generateBrewTagPrefix(product2.getAbbreviation(), EAP_PRODUCT_VERSION, this.systemConfig.getBrewTagPattern()).build();
        productVersion3 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion3);
        this.demoProductMilestone1 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE1).startingDate(this.ONE_WEEK_BEFORE_TODAY).plannedEndDate(this.TODAY).productVersion(productVersion1).build();
        this.demoProductMilestone1 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone1);
        this.demoProductMilestone2 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE2).startingDate(this.TODAY).plannedEndDate(this.ONE_WEEK_AFTER_TODAY).productVersion(productVersion1).build();
        this.demoProductMilestone2 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone2);
        Instant t0 = this.TODAY.toInstant();
        Instant successTime = t0.plus(10L, ChronoUnit.MINUTES);
        this.demoProductMilestone3 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE3).startingDate(this.TODAY).plannedEndDate(this.ONE_WEEK_AFTER_TODAY).endDate(this.ONE_WEEK_AFTER_TODAY).productVersion(productVersion1).build();
        this.demoProductMilestone3 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone3);
        ProductMilestone demoProductMilestone4 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE4).startingDate(this.TODAY).plannedEndDate(this.ONE_WEEK_AFTER_TODAY).endDate(this.ONE_WEEK_AFTER_TODAY).productVersion(productVersion1).build();
        demoProductMilestone4 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)demoProductMilestone4);
        this.demoProductMilestone5 = ProductMilestone.Builder.newBuilder().version(EAP_PRODUCT_MILESTONE_1).startingDate(this.ONE_WEEK_BEFORE_TODAY).plannedEndDate(this.TODAY).endDate(this.ONE_WEEK_AFTER_TODAY).productVersion(productVersion3).build();
        this.demoProductMilestone5 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone5);
        this.demoProductMilestone6 = ProductMilestone.Builder.newBuilder().version(EAP_PRODUCT_MILESTONE_2).startingDate(this.TODAY).plannedEndDate(this.ONE_WEEK_AFTER_TODAY).productVersion(productVersion3).build();
        this.demoProductMilestone6 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone6);
        this.demoProductMilestone7 = ProductMilestone.Builder.newBuilder().version(PNC_PRODUCT_MILESTONE5).startingDate(this.TODAY).plannedEndDate(this.ONE_WEEK_AFTER_TODAY).productVersion(productVersion2).build();
        this.demoProductMilestone7 = (ProductMilestone)this.productMilestoneRepository.save((GenericEntity)this.demoProductMilestone7);
        ProductRelease productRelease = ProductRelease.Builder.newBuilder().version(PNC_PRODUCT_RELEASE).productMilestone(this.demoProductMilestone1).supportLevel(SupportLevel.EARLYACCESS).build();
        productRelease = (ProductRelease)this.productReleaseRepository.save((GenericEntity)productRelease);
        productVersion1.setCurrentProductMilestone(this.demoProductMilestone3);
        productVersion1 = (ProductVersion)this.productVersionRepository.save((GenericEntity)productVersion1);
        Project project1 = Project.Builder.newBuilder().name(PNC_PROJECT_1_NAME).description("Example Project for Newcastle Demo").projectUrl("https://github.com/project-ncl/pnc").build();
        Project project2 = Project.Builder.newBuilder().name("Causeway").description("Causeway - Koji integration").projectUrl("https://github.com/project-ncl/causeway").build();
        Project project3 = Project.Builder.newBuilder().name("Pnc Build Agent").description("Pnc Build Agent - remote client to execute commands.").projectUrl("https://github.com/project-ncl/pnc-build-agent").build();
        Project project4 = Project.Builder.newBuilder().name("Dependency Analysis").description("Dependency Analysis - Analise project dependencies.").projectUrl("https://github.com/project-ncl/dependency-analysis").build();
        Project project5 = Project.Builder.newBuilder().name("termd").description("Remote shell.").projectUrl("https://github.com/project-ncl/termd").build();
        Project project6 = Project.Builder.newBuilder().name(EAP_PROJECT_NAME).description("Example Project for JBoss EAP Demo").projectUrl("https://github.com/jboss/eap").build();
        this.projectRepository.save((GenericEntity)project1);
        this.projectRepository.save((GenericEntity)project2);
        this.projectRepository.save((GenericEntity)project3);
        this.projectRepository.save((GenericEntity)project4);
        this.projectRepository.save((GenericEntity)project5);
        this.projectRepository.save((GenericEntity)project6);
        RepositoryConfiguration repositoryConfiguration1 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(0), "https://github.com/project-ncl/pnc.git");
        RepositoryConfiguration repositoryConfiguration2 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(1), null);
        RepositoryConfiguration repositoryConfiguration3 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(2), null);
        RepositoryConfiguration repositoryConfiguration4 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(3), null);
        RepositoryConfiguration repositoryConfiguration5 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(4), null);
        RepositoryConfiguration repositoryConfiguration6 = this.createRepositoryConfiguration(this.demoDataConfig.getInternalRepo(5), "https://github.com/jboss/eap.git");
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration1);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration2);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration3);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration4);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration5);
        this.repositoryConfigurationRepository.save((GenericEntity)repositoryConfiguration6);
        HashMap<String, String> genericParameters = new HashMap<String, String>();
        genericParameters.put("KEY", "VALUE");
        this.buildConfiguration1 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name(PNC_PROJECT_BUILD_CFG_ID).project(project1).description("Test build config for project newcastle").buildType(BuildType.MVN).buildEnvironment(environment1).buildScript("mvn deploy -DskipTests=true").repositoryConfiguration(repositoryConfiguration1).productVersion(productVersion1).scmRevision("*/v0.2").genericParameters(genericParameters).build();
        this.buildConfiguration1 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)this.buildConfiguration1);
        this.buildConfiguration2 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name("termd").project(project2).buildType(BuildType.MVN).description("Test configueration for Termd.").buildEnvironment(environment1).buildScript("mvn deploy -DskipTests=true").productVersion(productVersion1).repositoryConfiguration(repositoryConfiguration2).scmRevision("master").build();
        this.buildConfiguration2 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)this.buildConfiguration2);
        BuildConfiguration buildConfiguration3 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name("pnc-build-agent-0.4").project(project3).description("Test config for Pnc Build Agent.").buildType(BuildType.MVN).buildEnvironment(environment1).buildScript("mvn deploy -DskipTests=true").productVersion(productVersion2).repositoryConfiguration(repositoryConfiguration3).dependency(this.buildConfiguration2).build();
        buildConfiguration3 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration3);
        BuildConfiguration buildConfiguration4 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name("dependency-analysis-1.3").project(project4).description("Test config for Dependency Analysis.").buildType(BuildType.MVN).buildEnvironment(environment1).buildScript("mvn deploy -DskipTests=true").repositoryConfiguration(repositoryConfiguration4).dependency(this.buildConfiguration1).build();
        buildConfiguration4 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration4);
        BuildConfiguration buildConfiguration5 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name("maven-plugin-test").project(project5).description("Test build for Plugins with external downloads").buildType(BuildType.MVN).buildEnvironment(environment1).buildScript("mvn clean deploy").repositoryConfiguration(repositoryConfiguration5).build();
        buildConfiguration5 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)buildConfiguration5);
        this.buildConfiguration6 = BuildConfiguration.Builder.newBuilder().id(Integer.valueOf(this.sequenceHandlerRepository.getNextID("build_configuration_id_seq").intValue())).name(EAP_PROJECT_BUILD_CFG_ID).project(project6).description("Test build config for project eap").buildType(BuildType.MVN).buildEnvironment(environment1).buildScript("mvn clean deploy").repositoryConfiguration(repositoryConfiguration6).build();
        this.buildConfiguration6 = (BuildConfiguration)this.buildConfigurationRepository.save((GenericEntity)this.buildConfiguration6);
        this.buildConfigurationSet1 = BuildConfigurationSet.Builder.newBuilder().name("Example-Build-Group-1").buildConfiguration(this.buildConfiguration1).buildConfiguration(this.buildConfiguration2).buildConfiguration(buildConfiguration3).productVersion(productVersion1).build();
        BuildConfigurationSet buildConfigurationSet2 = BuildConfigurationSet.Builder.newBuilder().name("Fabric-Build-Group").buildConfiguration(buildConfiguration4).productVersion(productVersion1).build();
        this.demoUser = User.Builder.newBuilder().username("demo-user").firstName("Demo First Name").lastName("Demo Last Name").email("demo-user@pnc.com").build();
        this.pncAdminUser = User.Builder.newBuilder().username("pnc-admin").firstName("pnc-admin").lastName("pnc-admin").email("pnc-admin@pnc.com").build();
        this.buildConfigurationSetRepository.save((GenericEntity)this.buildConfigurationSet1);
        this.buildConfigurationSetRepository.save((GenericEntity)buildConfigurationSet2);
        this.demoUser = (User)this.userRepository.save((GenericEntity)this.demoUser);
        this.pncAdminUser = (User)this.userRepository.save((GenericEntity)this.pncAdminUser);
    }

    @TransactionAttribute
    public void updateBuildConfigurations() {
        this.buildConfiguration2.setBuildScript("mvn deploy -DskipTests");
        this.helper.save(this.buildConfiguration2);
        this.buildConfiguration6.setBuildScript(this.buildConfiguration6.getBuildScript() + " -DskipTests");
        this.helper.save(this.buildConfiguration6);
        this.buildConfiguration1.setBuildScript("mvn clean install -DskipTests=true");
        this.helper.save(this.buildConfiguration1);
        this.buildConfiguration1.setBuildScript("mvn clean install");
        this.helper.save(this.buildConfiguration1);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void initiliazeBuildRecordDemoData() {
        boolean INITIAL_REVISION = true;
        int SECOND_REVISION = 2;
        int THIRD_REVISION = 3;
        TargetRepository targetRepository = TargetRepository.newBuilder().repositoryType(RepositoryType.MAVEN).repositoryPath("builds-untested").identifier("indy-maven").temporaryRepo(Boolean.valueOf(false)).build();
        TargetRepository targetRepository2 = TargetRepository.newBuilder().repositoryType(RepositoryType.NPM).repositoryPath("builds-tested").identifier("indy-npm").temporaryRepo(Boolean.valueOf(true)).build();
        this.targetRepositoryRepository.save((GenericEntity)targetRepository);
        this.targetRepositoryRepository.save((GenericEntity)targetRepository2);
        Artifact builtArtifact1 = Artifact.Builder.newBuilder().identifier("demo:built-artifact1:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 1").md5("4af310bf0ef67bc7d143f35818ea1ed2").sha1("3a8ff25c890f2a4a283876a91037ff6c57474a14").sha256("1660168483cb8a05d1cc2e77c861682a42ed9517ba945159d5538950c5db00fa").deployPath("demo/built-artifact1/1.0/built-artifact1-1.0.jar").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).buildCategory(BuildCategory.STANDARD).build();
        Artifact builtArtifact2 = Artifact.Builder.newBuilder().identifier("demo:built-artifact2:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 2").md5("4af310bf0ef67bc7d143f35818ea1ed2").sha1("61dad16e14438d2d8c8cbd18b267d62944f37898").sha256("2fafc2ed0f752ac2540283d48c5cd663254a853c5cb13dec02dce023fc7471a9").deployPath("demo/built-artifact2/1.0/built-artifact2-1.0.jar").size(Long.valueOf(11L)).artifactQuality(ArtifactQuality.VERIFIED).buildCategory(BuildCategory.STANDARD).build();
        Artifact builtArtifact3 = Artifact.Builder.newBuilder().identifier("demo:built-artifact11:pom:1.0").targetRepository(targetRepository2).filename("demo built artifact 11").md5("5c8e1503e77dc8e370610098e01f0a8e").sha1("550748f6f58ed8d4f6b63850a867ac207da30013").sha256("b39f88c9937f201981767e539025121971e72bc590ea20ed7fdfffafc05f55a9").deployPath("demo/built-artifact11/1.0/built-artifact11-1.0.pom").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.DELETED).buildCategory(BuildCategory.SERVICE).build();
        Artifact builtArtifact4 = Artifact.Builder.newBuilder().identifier("demo:built-artifact22:jar:1.0").targetRepository(targetRepository2).filename("demo built artifact 21").md5("48312fb24c7b2a116c2139d5b39bad66").sha1("6ce2fd75c35e7eed2c45338b943be34d0b974f16").sha256("61c9ccd3ba0013311ddb89cb9a29389b6761061bdcdfb48f0096bf98c7279a21").deployPath("demo/built-artifact22/1.0/built-artifact22-1.0.jar").size(Long.valueOf(11L)).artifactQuality(ArtifactQuality.NEW).buildCategory(BuildCategory.SERVICE).build();
        Artifact builtArtifact9 = Artifact.Builder.newBuilder().identifier("demo:built-artifact7:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 9").md5("md-fake-abcdefg4321").sha1("sha1-fake-abcdefg4321").sha256("sha256-fake-abcdefg4321").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built7").build();
        builtArtifact1 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact1);
        builtArtifact2 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact2);
        builtArtifact3 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact3);
        builtArtifact4 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact4);
        Artifact importedArtifact1 = Artifact.Builder.newBuilder().identifier("demo:imported-artifact1:jar:1.0").targetRepository(targetRepository).filename("demo imported artifact 1").originUrl("http://central/import1.jar").importDate(Date.from(Instant.now())).md5("md-fake-abcd1234").sha1("sha1-fake-abcd1234").sha256("sha256-fake-abcd1234").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).buildCategory(BuildCategory.STANDARD).deployPath("/imported1").build();
        Artifact importedArtifact2 = Artifact.Builder.newBuilder().identifier("demo:imported-artifact2:jar:1.0").targetRepository(targetRepository).filename("demo imported artifact 2").originUrl("http://central/import2.jar").importDate(Date.from(Instant.now())).md5("md-fake-abcd1234").sha1("sha1-fake-abcd1234").sha256("sha256-fake-abcd1234").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.IMPORTED).buildCategory(BuildCategory.STANDARD).deployPath("/imported2").build();
        importedArtifact1 = (Artifact)this.artifactRepository.save((GenericEntity)importedArtifact1);
        importedArtifact2 = (Artifact)this.artifactRepository.save((GenericEntity)importedArtifact2);
        HashSet<BuildRecord> buildRecords = new HashSet<BuildRecord>();
        List buildConfig1Revisions = this.buildConfigurationAuditedRepository.findAllByIdOrderByRevDesc(this.buildConfiguration1.getId());
        int buildConfig1RevisionsCount = buildConfig1Revisions.size();
        BuildConfigurationAudited buildConfigAudited1 = (BuildConfigurationAudited)buildConfig1Revisions.get(buildConfig1RevisionsCount - 1);
        Objects.requireNonNull(buildConfigAudited1, "couldn't get buildConfigAudited1");
        String nextId = Sequence.nextBase32Id();
        log.info("####nextId: " + nextId);
        BuildRecord buildRecord1 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfigAudited1).submitTime((Date)Timestamp.from(Instant.now().minus(8L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(5L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now())).dependency(importedArtifact1).dependency(importedArtifact2).user(this.pncAdminUser).status(BuildStatus.SUCCESS).productMilestone(this.demoProductMilestone1).sshCommand("ssh worker@localhost -P 9999").sshPassword("dontchangeme").buildEnvironment(buildConfigAudited1.getBuildEnvironment()).scmRepoURL(buildConfigAudited1.getRepositoryConfiguration().getInternalUrl()).scmRevision(buildConfigAudited1.getScmRevision()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.3").temporaryBuild(false).attribute("FOO", "bar").build();
        log.info("Saving buildRecord1: " + buildRecord1);
        BuildRecord savedBuildRecord1 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)buildRecord1);
        builtArtifact1.setBuildRecord(savedBuildRecord1);
        builtArtifact2.setBuildRecord(savedBuildRecord1);
        builtArtifact9.setBuildRecord(savedBuildRecord1);
        log.info("Saved buildRecord1: " + savedBuildRecord1 + "BuildConfigurationAuditedIdRev: " + savedBuildRecord1.getBuildConfigurationAuditedIdRev());
        buildRecords.add(buildRecord1);
        BuildPushOperation buildPush1 = BuildPushOperation.builder().id(new Base32LongID(Sequence.nextBase32Id())).build(buildRecord1).submitTime((Date)Timestamp.from(Instant.now().minus(8L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(7L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now().minus(6L, ChronoUnit.MINUTES))).operationParameters(Map.of("tagPrefix", "foobar")).progressStatus(ProgressStatus.FINISHED).result(OperationResult.FAILED).user(this.demoUser).build();
        this.buildPushOperationRepository.save((GenericEntity)buildPush1);
        BuildPushOperation buildPush2 = BuildPushOperation.builder().id(new Base32LongID(Sequence.nextBase32Id())).build(buildRecord1).submitTime((Date)Timestamp.from(Instant.now().minus(5L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(4L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now().minus(3L, ChronoUnit.MINUTES))).operationParameters(Map.of("tagPrefix", "foo-bar")).progressStatus(ProgressStatus.FINISHED).result(OperationResult.SYSTEM_ERROR).user(this.demoUser).build();
        this.buildPushOperationRepository.save((GenericEntity)buildPush2);
        nextId = Sequence.nextBase32Id();
        log.info("####nextId: " + nextId);
        BuildRecord tempRecord1 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfigAudited1).submitTime((Date)Timestamp.from(Instant.now())).startTime((Date)Timestamp.from(Instant.now())).endTime((Date)Timestamp.from(Instant.now())).user(this.pncAdminUser).status(BuildStatus.SUCCESS).buildEnvironment(buildConfigAudited1.getBuildEnvironment()).scmRepoURL(buildConfigAudited1.getRepositoryConfiguration().getInternalUrl()).scmRevision(buildConfigAudited1.getScmRevision()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.3").temporaryBuild(true).build();
        log.info("Saving tempRecord1: " + tempRecord1);
        BuildRecord savedTempRecord1 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)tempRecord1);
        builtArtifact3.setBuildRecord(savedTempRecord1);
        builtArtifact4.setBuildRecord(savedTempRecord1);
        log.info("Saved buildRecord1: " + savedTempRecord1 + "BuildConfigurationAuditedIdRev: " + savedTempRecord1.getBuildConfigurationAuditedIdRev());
        buildRecords.add(tempRecord1);
        Artifact builtArtifact5 = Artifact.Builder.newBuilder().identifier("demo:built-artifact3:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 3").md5("17353a18678c6c249e3052edec2e4c5c").sha1("61dad16e14438d2d8c8cbd18b267d62944f37898").sha256("1660168483cb8a05d1cc2e77c861682a42ed9517ba945159d5538950c5db00fa").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built3").build();
        Artifact builtArtifact6 = Artifact.Builder.newBuilder().identifier("demo:built-artifact4:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 4").md5("md-fake-abcd1234").sha1("sha1-fake-abcd1234").sha256("sha256-fake-abcd1234").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built4").build();
        Artifact builtArtifact7 = Artifact.Builder.newBuilder().identifier("demo:built-artifact5:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 7").md5("adsfs6df548w1327cx78he873217df98").sha1("a56asdf87a3cvx231b87987fasd6f5ads4f32sdf").sha256("sad5f64sf87b3cvx2b1v87tr89h7d3f5g432xcz1zv87fawrv23n8796534564er").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built5").build();
        Artifact builtArtifact8 = Artifact.Builder.newBuilder().identifier("demo:built-artifact6:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 8").md5("md-fake-abcdefg1234").sha1("sha1-fake-abcdefg1234").sha256("sha256-fake-abcdefg1234").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built6").build();
        Artifact builtArtifact10 = Artifact.Builder.newBuilder().identifier("demo:built-artifact7:jar:1.1").targetRepository(targetRepository).filename("demo built artifact 10").md5("md5-fake-abc123").sha1("sha1-fake-abc123").sha256("sha256-fake-abc123").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built7").build();
        builtArtifact5 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact5);
        builtArtifact6 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact6);
        builtArtifact7 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact7);
        builtArtifact8 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact8);
        builtArtifact9 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact9);
        builtArtifact10 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact10);
        Artifact dependencyBuiltArtifact1 = (Artifact)this.artifactRepository.queryByPredicates(new Predicate[]{ArtifactPredicates.withIdentifierAndSha256((String)builtArtifact1.getIdentifier(), (String)builtArtifact1.getSha256())});
        Calendar calendar = Calendar.getInstance();
        calendar.set(2019, 0, 10);
        List buildConfig2Revisions = this.buildConfigurationAuditedRepository.findAllByIdOrderByRevDesc(this.buildConfiguration2.getId());
        int buildConfig2RevisionsCount = buildConfig2Revisions.size();
        BuildConfigurationAudited buildConfig2InitialAudit = (BuildConfigurationAudited)buildConfig2Revisions.get(buildConfig2RevisionsCount - 1);
        BuildConfigurationAudited buildConfig2SecondAudit = (BuildConfigurationAudited)buildConfig2Revisions.get(buildConfig2RevisionsCount - 2);
        if (buildConfig2InitialAudit != null && buildConfig2SecondAudit != null) {
            nextId = Sequence.nextBase32Id();
            log.info("####nextId: " + nextId);
            BuildRecord buildRecord2 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfig2InitialAudit).submitTime((Date)Timestamp.from(Instant.now().minus(8L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(5L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now())).dependency(dependencyBuiltArtifact1).dependency(importedArtifact1).user(this.demoUser).status(BuildStatus.SUCCESS).buildEnvironment(buildConfig2InitialAudit.getBuildEnvironment()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.4").temporaryBuild(false).build();
            nextId = Sequence.nextBase32Id();
            log.info("####nextId: " + nextId);
            BuildRecord savedBuildRecord2 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)buildRecord2);
            builtArtifact5.setBuildRecord(savedBuildRecord2);
            builtArtifact6.setBuildRecord(savedBuildRecord2);
            buildRecords.add(buildRecord2);
            BuildRecord tempRecord2 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfig2InitialAudit).submitTime((Date)Timestamp.from(calendar.toInstant().minus(8L, ChronoUnit.HOURS))).startTime((Date)Timestamp.from(calendar.toInstant().minus(5L, ChronoUnit.HOURS))).endTime((Date)Timestamp.from(calendar.toInstant())).user(this.demoUser).status(BuildStatus.SUCCESS).buildEnvironment(buildConfig2InitialAudit.getBuildEnvironment()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.4").temporaryBuild(true).dependency(builtArtifact3).dependency(builtArtifact7).build();
            BuildRecord savedTempRecord2 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)tempRecord2);
            builtArtifact7.setBuildRecord(savedTempRecord2);
            builtArtifact8.setBuildRecord(savedTempRecord2);
            buildRecords.add(tempRecord2);
            nextId = Sequence.nextBase32Id();
            log.info("####nextId: " + nextId);
            BuildRecord buildRecord3 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfig2SecondAudit).productMilestone(this.demoProductMilestone2).submitTime(this.ONE_WEEK_BEFORE_TODAY).startTime((Date)Timestamp.from(calendar.toInstant().minus(1L, ChronoUnit.HOURS))).endTime((Date)Timestamp.from(calendar.toInstant())).user(this.demoUser).status(BuildStatus.SUCCESS).buildEnvironment(buildConfig2InitialAudit.getBuildEnvironment()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.4.2").temporaryBuild(false).build();
            BuildRecord savedBuildRecord3 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)buildRecord3);
            builtArtifact10.setBuildRecord(savedBuildRecord3);
        }
        List buildConfig6Revisions = this.buildConfigurationAuditedRepository.findAllByIdOrderByRevDesc(this.buildConfiguration6.getId());
        int buildConfig6RevisionsCount = buildConfig6Revisions.size();
        BuildConfigurationAudited buildConfig6InitialAudit = (BuildConfigurationAudited)buildConfig6Revisions.get(buildConfig6RevisionsCount - 1);
        BuildConfigurationAudited buildConfig6SecondAudit = (BuildConfigurationAudited)buildConfig6Revisions.get(buildConfig6RevisionsCount - 2);
        BuildConfigurationAudited buildConfig1SecondAudit = (BuildConfigurationAudited)buildConfig1Revisions.get(buildConfig1RevisionsCount - 2);
        BuildConfigurationAudited buildConfig1ThirdAudit = (BuildConfigurationAudited)buildConfig1Revisions.get(buildConfig1RevisionsCount - 3);
        nextId = Sequence.nextBase32Id();
        log.info("####nextId: " + nextId);
        BuildRecord buildRecord4 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfig6InitialAudit).productMilestone(this.demoProductMilestone5).submitTime((Date)Timestamp.from(Instant.now().minus(8L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(7L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now().minus(6L, ChronoUnit.MINUTES))).user(this.demoUser).status(BuildStatus.SUCCESS).buildEnvironment(buildConfig6InitialAudit.getBuildEnvironment()).executionRootName("org.jboss.eap:parent").executionRootVersion("7.0.3").temporaryBuild(false).dependency(importedArtifact1).dependency(builtArtifact10).build();
        nextId = Sequence.nextBase32Id();
        log.info("####nextId: " + nextId);
        BuildRecord buildRecord5 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfig6SecondAudit).productMilestone(this.demoProductMilestone6).submitTime((Date)Timestamp.from(Instant.now().minus(2L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(1L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.SUCCESS).buildEnvironment(buildConfig6SecondAudit.getBuildEnvironment()).executionRootName("org.jboss.eap:parent").executionRootVersion("7.0.4").temporaryBuild(false).build();
        nextId = Sequence.nextBase32Id();
        log.info("####nextId: " + nextId);
        BuildRecord buildRecord6 = BuildRecord.Builder.newBuilder().id(nextId).productMilestone(this.demoProductMilestone7).buildConfigurationAudited(buildConfig1SecondAudit).submitTime((Date)Timestamp.from(Instant.now().minus(2L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(1L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.SUCCESS).buildEnvironment(buildConfig1SecondAudit.getBuildEnvironment()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.3").temporaryBuild(false).build();
        nextId = Sequence.nextBase32Id();
        log.info("####nextId: " + nextId);
        BuildRecord buildRecord7 = BuildRecord.Builder.newBuilder().id(nextId).buildConfigurationAudited(buildConfig1ThirdAudit).submitTime((Date)Timestamp.from(Instant.now().minus(2L, ChronoUnit.MINUTES))).startTime((Date)Timestamp.from(Instant.now().minus(1L, ChronoUnit.MINUTES))).endTime((Date)Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.SUCCESS).buildEnvironment(buildConfig1ThirdAudit.getBuildEnvironment()).executionRootName("org.jboss.pnc:parent").executionRootVersion("1.2.3").temporaryBuild(false).build();
        buildRecord4 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)buildRecord4);
        buildRecord5 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)buildRecord5);
        buildRecord6 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)buildRecord6);
        buildRecord7 = (BuildRecord)this.buildRecordRepository.save((GenericEntity)buildRecord7);
        Artifact builtArtifact11 = Artifact.Builder.newBuilder().buildRecord(buildRecord4).identifier("demo:built-artifact11:jar:1.1").targetRepository(targetRepository).filename("demo built artifact 11").md5("md5-fake-abc123").sha1("sha1-fake-abc123").sha256("sha256-fake-abc123").size(Long.valueOf(10L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built11").build();
        Artifact builtArtifact12 = Artifact.Builder.newBuilder().buildRecord(buildRecord5).identifier("demo:built-artifact12:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 12").md5("md5-fake-123abc").sha1("sha1-fake-123abc").sha256("sha256-fake-123abc").size(Long.valueOf(11L)).artifactQuality(ArtifactQuality.VERIFIED).deployPath("/built12").build();
        Artifact builtArtifact13 = Artifact.Builder.newBuilder().buildRecord(buildRecord6).identifier("demo:built-artifact13:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 13").md5("md5-fake-123abc").sha1("sha1-fake-123abc").sha256("sha256-fake-123abc").size(Long.valueOf(13L)).artifactQuality(ArtifactQuality.NEW).deployPath("/demo/built-artifact13/1.0/built-artifact13-1.0.jar").build();
        Artifact builtArtifact14 = Artifact.Builder.newBuilder().buildRecord(buildRecord7).identifier("demo:built-artifact14:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 14").md5("md5-fake-123abc").sha1("sha1-fake-123abc").sha256("sha256-fake-123abc").size(Long.valueOf(14L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built14").build();
        Artifact builtArtifact15 = Artifact.Builder.newBuilder().buildRecord(buildRecord7).identifier("demo:built-artifact15:jar:1.0").targetRepository(targetRepository).filename("demo built artifact 15").md5("md5-fake-123abc").sha1("sha1-fake-123abc").sha256("sha256-fake-123abc").size(Long.valueOf(15L)).artifactQuality(ArtifactQuality.NEW).deployPath("/built15").build();
        Artifact builtArtifact16a = Artifact.Builder.newBuilder().buildRecord(buildRecord7).identifier("demo:built-artifact16:jar:1.0.redhat-a").targetRepository(targetRepository).filename("demo built artifact 16a").md5("md5-fake-123abc").sha1("sha1-fake-123abc").sha256("sha256-fake-123abc").size(Long.valueOf(16L)).artifactQuality(ArtifactQuality.NEW).deployPath("/demo/built-artifact16/1.0.redhat-a/built-artifact16-1.0.redhat-a.jar").build();
        Artifact builtArtifact16b = Artifact.Builder.newBuilder().buildRecord(buildRecord7).identifier("demo:built-artifact16:jar:1.0.redhat-b").targetRepository(targetRepository).filename("demo built artifact 16b").md5("md5-fake-123abc").sha1("sha1-fake-123abc").sha256("sha256-fake-123abc").size(Long.valueOf(16L)).artifactQuality(ArtifactQuality.NEW).deployPath("/demo/built-artifact16/1.0.redhat-b/built-artifact16-1.0.redhat-b.jar").build();
        Artifact builtArtifact17 = Artifact.Builder.newBuilder().buildRecord(buildRecord7).identifier("demo:built-artifact17:jar:1.0.redhat").targetRepository(targetRepository).filename("demo built artifact 17").md5("md5-fake-123abc").sha1("sha1-fake-123abc").sha256("sha256-fake-123abc").size(Long.valueOf(17L)).artifactQuality(ArtifactQuality.NEW).deployPath("/demo/built-artifact17/1.0.redhat/built-artifact17-1.0.redhat.jar").build();
        Artifact builtArtifact18 = Artifact.Builder.newBuilder().buildRecord(buildRecord7).identifier("demo:built-artifact18:jar:1.0.redhat").targetRepository(targetRepository).filename("demo built artifact 18").md5("md5-fake-123abc").sha1("sha1-fake-123abc").sha256("sha256-fake-123abc").size(Long.valueOf(18L)).artifactQuality(ArtifactQuality.NEW).deployPath("/demo/built-artifact18/1.0.redhat/built-artifact18-1.0.redhat.jar").build();
        builtArtifact11 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact11);
        builtArtifact12 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact12);
        builtArtifact13 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact13);
        builtArtifact14 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact14);
        builtArtifact15 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact15);
        builtArtifact16a = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact16a);
        builtArtifact16b = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact16b);
        builtArtifact17 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact17);
        builtArtifact18 = (Artifact)this.artifactRepository.save((GenericEntity)builtArtifact18);
        this.demoProductMilestone1 = (ProductMilestone)this.productMilestoneRepository.queryById((Serializable)this.demoProductMilestone1.getId());
        this.demoProductMilestone3 = (ProductMilestone)this.productMilestoneRepository.queryById((Serializable)this.demoProductMilestone3.getId());
        this.demoProductMilestone7 = (ProductMilestone)this.productMilestoneRepository.queryById((Serializable)this.demoProductMilestone7.getId());
        BuildConfigSetRecord buildConfigSetRecord1 = BuildConfigSetRecord.Builder.newBuilder().buildConfigurationSet(this.buildConfigurationSet1).startTime((Date)Timestamp.from(Instant.now())).endTime((Date)Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.FAILED).buildRecords(Set.of(savedBuildRecord1)).temporaryBuild(false).build();
        savedBuildRecord1.setBuildConfigSetRecord(buildConfigSetRecord1);
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord1);
        BuildConfigSetRecord buildConfigSetRecord2 = BuildConfigSetRecord.Builder.newBuilder().buildConfigurationSet(this.buildConfigurationSet1).buildRecords(buildRecords).startTime((Date)Timestamp.from(Instant.now())).endTime((Date)Timestamp.from(Instant.now())).user(this.demoUser).status(BuildStatus.SUCCESS).temporaryBuild(false).build();
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord2);
        buildRecords.forEach(record -> this.buildRecordRepository.save((GenericEntity)record));
        BuildConfigSetRecord buildConfigSetRecord3 = BuildConfigSetRecord.Builder.newBuilder().buildConfigurationSet(this.buildConfigurationSet1).startTime((Date)Timestamp.from(calendar.toInstant().minus(20L, ChronoUnit.DAYS))).endTime((Date)Timestamp.from(calendar.toInstant().minus(20L, ChronoUnit.DAYS))).user(this.demoUser).status(BuildStatus.SUCCESS).temporaryBuild(true).build();
        this.buildConfigSetRecordRepository.save((GenericEntity)buildConfigSetRecord3);
        HashMap<String, String> operationParameters = new HashMap<String, String>();
        operationParameters.put("url-0", "https://github.com/project-ncl/pnc/archive/refs/tags/2.1.1.tar.gz");
        DeliverableAnalyzerOperation operation1 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000001L)).progressStatus(ProgressStatus.NEW).submitTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone1).operationParameters(operationParameters).build();
        this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation1);
        DeliverableAnalyzerOperation operation2 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000002L)).progressStatus(ProgressStatus.IN_PROGRESS).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone1).build();
        operation2 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation2);
        DeliverableAnalyzerOperation operation3 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000003L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone3).build();
        operation3 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation3);
        DeliverableAnalyzerOperation operation4 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000004L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone7).build();
        operation4 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation4);
        DeliverableAnalyzerOperation operation5 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000005L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone1).build();
        operation5 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation5);
        DeliverableAnalyzerOperation operation6 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000006L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone2).build();
        operation6 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation6);
        DeliverableAnalyzerOperation operation7 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000007L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone3).build();
        operation7 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation7);
        DeliverableAnalyzerOperation operation8 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000008L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone1).build();
        operation8 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation8);
        DeliverableAnalyzerOperation operation9 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000009L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone5).build();
        operation9 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation9);
        DeliverableAnalyzerOperation operation10 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000010L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone1).build();
        operation10 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation10);
        DeliverableAnalyzerOperation operation11 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000011L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone6).build();
        operation11 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation11);
        DeliverableAnalyzerOperation operation12 = DeliverableAnalyzerOperation.Builder.newBuilder().id(new Base32LongID(1000012L)).progressStatus(ProgressStatus.FINISHED).submitTime(this.TODAY).startTime(this.TODAY).user(this.demoUser).productMilestone(this.demoProductMilestone6).build();
        operation12 = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.save((GenericEntity)operation12);
        DeliverableAnalyzerReport report1 = DeliverableAnalyzerReport.builder().operation(operation2).labels(EnumSet.of(DeliverableAnalyzerReportLabel.RELEASED)).build();
        report1 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report1);
        DeliverableAnalyzerReport report2 = DeliverableAnalyzerReport.builder().operation(operation3).labels(EnumSet.noneOf(DeliverableAnalyzerReportLabel.class)).build();
        report2 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report2);
        DeliverableAnalyzerReport report3 = DeliverableAnalyzerReport.builder().operation(operation4).labels(EnumSet.noneOf(DeliverableAnalyzerReportLabel.class)).build();
        report3 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report3);
        DeliverableAnalyzerReport report4 = DeliverableAnalyzerReport.builder().operation(operation5).labels(EnumSet.noneOf(DeliverableAnalyzerReportLabel.class)).build();
        report4 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report4);
        DeliverableAnalyzerReport report5 = DeliverableAnalyzerReport.builder().operation(operation6).labels(EnumSet.noneOf(DeliverableAnalyzerReportLabel.class)).build();
        report5 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report5);
        DeliverableAnalyzerReport report6 = DeliverableAnalyzerReport.builder().operation(operation7).labels(EnumSet.noneOf(DeliverableAnalyzerReportLabel.class)).build();
        report6 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report6);
        DeliverableAnalyzerReport report7 = DeliverableAnalyzerReport.builder().operation(operation8).labels(EnumSet.of(DeliverableAnalyzerReportLabel.SCRATCH)).build();
        report7 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report7);
        DeliverableAnalyzerReport report8 = DeliverableAnalyzerReport.builder().operation(operation9).labels(EnumSet.noneOf(DeliverableAnalyzerReportLabel.class)).build();
        report8 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report8);
        DeliverableAnalyzerReport report9 = DeliverableAnalyzerReport.builder().operation(operation10).labels(EnumSet.noneOf(DeliverableAnalyzerReportLabel.class)).build();
        report9 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report9);
        DeliverableAnalyzerReport report10 = DeliverableAnalyzerReport.builder().operation(operation11).labels(EnumSet.noneOf(DeliverableAnalyzerReportLabel.class)).build();
        report10 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report10);
        DeliverableAnalyzerReport report11 = DeliverableAnalyzerReport.builder().operation(operation12).labels(EnumSet.noneOf(DeliverableAnalyzerReportLabel.class)).build();
        report11 = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.save((GenericEntity)report11);
        DeliverableAnalyzerLabelEntry report1LabelEntry1 = DeliverableAnalyzerLabelEntry.builder().report(report1).changeOrder(Integer.valueOf(1)).entryTime(this.ONE_WEEK_BEFORE_TODAY).user(this.pncAdminUser).label(DeliverableAnalyzerReportLabel.RELEASED).change(LabelOperation.ADDED).reason("This was a game-changer! Release it! <3").build();
        this.deliverableAnalyzerLabelEntryRepository.save((GenericEntity)report1LabelEntry1);
        DeliverableArtifact analyzedArtifact1 = DeliverableArtifact.builder().report(report1).artifact(builtArtifact1).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact2 = DeliverableArtifact.builder().report(report1).artifact(builtArtifact5).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact3 = DeliverableArtifact.builder().report(report1).artifact(builtArtifact9).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact4 = DeliverableArtifact.builder().report(report1).artifact(builtArtifact10).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact5 = DeliverableArtifact.builder().report(report1).artifact(builtArtifact11).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact6 = DeliverableArtifact.builder().report(report1).artifact(builtArtifact12).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact7 = DeliverableArtifact.builder().report(report1).artifact(importedArtifact2).builtFromSource(false).brewBuildId(Long.valueOf(42L)).build();
        DeliverableArtifact analyzedArtifact8 = DeliverableArtifact.builder().report(report2).artifact(builtArtifact13).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact9 = DeliverableArtifact.builder().report(report3).artifact(builtArtifact14).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact10 = DeliverableArtifact.builder().report(report3).artifact(builtArtifact15).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact11a = DeliverableArtifact.builder().report(report4).artifact(builtArtifact16a).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact11b = DeliverableArtifact.builder().report(report4).artifact(builtArtifact16b).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact12 = DeliverableArtifact.builder().report(report5).artifact(builtArtifact16b).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact13 = DeliverableArtifact.builder().report(report5).artifact(builtArtifact17).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact14 = DeliverableArtifact.builder().report(report6).artifact(builtArtifact18).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact15 = DeliverableArtifact.builder().report(report7).artifact(builtArtifact18).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact16 = DeliverableArtifact.builder().report(report8).artifact(builtArtifact13).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact17 = DeliverableArtifact.builder().report(report8).artifact(builtArtifact2).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact18 = DeliverableArtifact.builder().report(report2).artifact(builtArtifact2).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact19 = DeliverableArtifact.builder().report(report9).artifact(builtArtifact18).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact20 = DeliverableArtifact.builder().report(report10).artifact(builtArtifact13).builtFromSource(true).brewBuildId(null).build();
        DeliverableArtifact analyzedArtifact21 = DeliverableArtifact.builder().report(report11).artifact(builtArtifact13).builtFromSource(true).brewBuildId(null).build();
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact1);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact2);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact3);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact4);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact5);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact6);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact7);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact8);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact9);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact10);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact11a);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact11b);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact12);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact13);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact14);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact15);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact16);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact17);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact18);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact19);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact20);
        this.deliverableArtifactRepository.save((GenericEntity)analyzedArtifact21);
    }

    private RepositoryConfiguration createRepositoryConfiguration(String internalScmUrl, String externalUrl) {
        return RepositoryConfiguration.Builder.newBuilder().internalUrl(internalScmUrl).externalUrl(externalUrl).build();
    }
}

