/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Pattern;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.BuildType;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildConfigurationRef
implements DTOEntity {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    protected final String id;
    @NotNull(groups={WhenCreatingNew.class})
    @Pattern(regexp="^[a-zA-Z0-9_.][a-zA-Z0-9_.-]*(?<!\\.git)$", groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final @NotNull(groups={WhenCreatingNew.class}) @Pattern(regexp="^[a-zA-Z0-9_.][a-zA-Z0-9_.-]*(?<!\\.git)$", groups={WhenCreatingNew.class, WhenUpdating.class}) String name;
    protected final String description;
    protected final String buildScript;
    protected final String scmRevision;
    protected final Instant creationTime;
    protected final Instant modificationTime;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final BuildType buildType;
    protected final String defaultAlignmentParams;

    BuildConfigurationRef(String id, String name, String description, String buildScript, String scmRevision, Instant creationTime, Instant modificationTime, BuildType buildType, String defaultAlignmentParams) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.buildScript = buildScript;
        this.scmRevision = scmRevision;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.buildType = buildType;
        this.defaultAlignmentParams = defaultAlignmentParams;
    }

    public static Builder refBuilder() {
        return new Builder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBuildScript() {
        return this.buildScript;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public String getDefaultAlignmentParams() {
        return this.defaultAlignmentParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfigurationRef)) {
            return false;
        }
        BuildConfigurationRef other = (BuildConfigurationRef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$buildScript = this.getBuildScript();
        String other$buildScript = other.getBuildScript();
        if (this$buildScript == null ? other$buildScript != null : !this$buildScript.equals(other$buildScript)) {
            return false;
        }
        String this$scmRevision = this.getScmRevision();
        String other$scmRevision = other.getScmRevision();
        if (this$scmRevision == null ? other$scmRevision != null : !this$scmRevision.equals(other$scmRevision)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$modificationTime = this.getModificationTime();
        Instant other$modificationTime = other.getModificationTime();
        if (this$modificationTime == null ? other$modificationTime != null : !((Object)this$modificationTime).equals(other$modificationTime)) {
            return false;
        }
        BuildType this$buildType = this.getBuildType();
        BuildType other$buildType = other.getBuildType();
        if (this$buildType == null ? other$buildType != null : !this$buildType.equals(other$buildType)) {
            return false;
        }
        String this$defaultAlignmentParams = this.getDefaultAlignmentParams();
        String other$defaultAlignmentParams = other.getDefaultAlignmentParams();
        return !(this$defaultAlignmentParams == null ? other$defaultAlignmentParams != null : !this$defaultAlignmentParams.equals(other$defaultAlignmentParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildConfigurationRef;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $buildScript = this.getBuildScript();
        result = result * 59 + ($buildScript == null ? 43 : $buildScript.hashCode());
        String $scmRevision = this.getScmRevision();
        result = result * 59 + ($scmRevision == null ? 43 : $scmRevision.hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $modificationTime = this.getModificationTime();
        result = result * 59 + ($modificationTime == null ? 43 : ((Object)$modificationTime).hashCode());
        BuildType $buildType = this.getBuildType();
        result = result * 59 + ($buildType == null ? 43 : $buildType.hashCode());
        String $defaultAlignmentParams = this.getDefaultAlignmentParams();
        result = result * 59 + ($defaultAlignmentParams == null ? 43 : $defaultAlignmentParams.hashCode());
        return result;
    }

    public String toString() {
        return "BuildConfigurationRef(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", buildScript=" + this.getBuildScript() + ", scmRevision=" + this.getScmRevision() + ", creationTime=" + this.getCreationTime() + ", modificationTime=" + this.getModificationTime() + ", buildType=" + this.getBuildType() + ", defaultAlignmentParams=" + this.getDefaultAlignmentParams() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private String name;
        private String description;
        private String buildScript;
        private String scmRevision;
        private Instant creationTime;
        private Instant modificationTime;
        private BuildType buildType;
        private String defaultAlignmentParams;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder buildScript(String buildScript) {
            this.buildScript = buildScript;
            return this;
        }

        public Builder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        public Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        public Builder defaultAlignmentParams(String defaultAlignmentParams) {
            this.defaultAlignmentParams = defaultAlignmentParams;
            return this;
        }

        public BuildConfigurationRef build() {
            return new BuildConfigurationRef(this.id, this.name, this.description, this.buildScript, this.scmRevision, this.creationTime, this.modificationTime, this.buildType, this.defaultAlignmentParams);
        }

        public String toString() {
            return "BuildConfigurationRef.Builder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", buildScript=" + this.buildScript + ", scmRevision=" + this.scmRevision + ", creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", buildType=" + this.buildType + ", defaultAlignmentParams=" + this.defaultAlignmentParams + ")";
        }
    }
}

