/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.SystemImageType;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Environment
implements DTOEntity {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private final String id;
    private final String name;
    private final String description;
    private final String systemImageRepositoryUrl;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final String systemImageId;
    private final Map<String, String> attributes;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private final SystemImageType systemImageType;
    private final boolean deprecated;

    Environment(String id, String name, String description, String systemImageRepositoryUrl, String systemImageId, Map<String, String> attributes, SystemImageType systemImageType, boolean deprecated) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.systemImageRepositoryUrl = systemImageRepositoryUrl;
        this.systemImageId = systemImageId;
        this.attributes = attributes;
        this.systemImageType = systemImageType;
        this.deprecated = deprecated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).name(this.name).description(this.description).systemImageRepositoryUrl(this.systemImageRepositoryUrl).systemImageId(this.systemImageId).attributes(this.attributes).systemImageType(this.systemImageType).deprecated(this.deprecated);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSystemImageRepositoryUrl() {
        return this.systemImageRepositoryUrl;
    }

    public String getSystemImageId() {
        return this.systemImageId;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public SystemImageType getSystemImageType() {
        return this.systemImageType;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$systemImageRepositoryUrl = this.getSystemImageRepositoryUrl();
        String other$systemImageRepositoryUrl = other.getSystemImageRepositoryUrl();
        if (this$systemImageRepositoryUrl == null ? other$systemImageRepositoryUrl != null : !this$systemImageRepositoryUrl.equals(other$systemImageRepositoryUrl)) {
            return false;
        }
        String this$systemImageId = this.getSystemImageId();
        String other$systemImageId = other.getSystemImageId();
        if (this$systemImageId == null ? other$systemImageId != null : !this$systemImageId.equals(other$systemImageId)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        SystemImageType this$systemImageType = this.getSystemImageType();
        SystemImageType other$systemImageType = other.getSystemImageType();
        if (this$systemImageType == null ? other$systemImageType != null : !this$systemImageType.equals(other$systemImageType)) {
            return false;
        }
        return this.isDeprecated() == other.isDeprecated();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Environment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $systemImageRepositoryUrl = this.getSystemImageRepositoryUrl();
        result = result * 59 + ($systemImageRepositoryUrl == null ? 43 : $systemImageRepositoryUrl.hashCode());
        String $systemImageId = this.getSystemImageId();
        result = result * 59 + ($systemImageId == null ? 43 : $systemImageId.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        SystemImageType $systemImageType = this.getSystemImageType();
        result = result * 59 + ($systemImageType == null ? 43 : $systemImageType.hashCode());
        result = result * 59 + (this.isDeprecated() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Environment(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", systemImageRepositoryUrl=" + this.getSystemImageRepositoryUrl() + ", systemImageId=" + this.getSystemImageId() + ", attributes=" + this.getAttributes() + ", systemImageType=" + this.getSystemImageType() + ", deprecated=" + this.isDeprecated() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private String name;
        private String description;
        private String systemImageRepositoryUrl;
        private String systemImageId;
        private Map<String, String> attributes;
        private SystemImageType systemImageType;
        private boolean deprecated;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder systemImageRepositoryUrl(String systemImageRepositoryUrl) {
            this.systemImageRepositoryUrl = systemImageRepositoryUrl;
            return this;
        }

        public Builder systemImageId(String systemImageId) {
            this.systemImageId = systemImageId;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder systemImageType(SystemImageType systemImageType) {
            this.systemImageType = systemImageType;
            return this;
        }

        public Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Environment build() {
            return new Environment(this.id, this.name, this.description, this.systemImageRepositoryUrl, this.systemImageId, this.attributes, this.systemImageType, this.deprecated);
        }

        public String toString() {
            return "Environment.Builder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", systemImageRepositoryUrl=" + this.systemImageRepositoryUrl + ", systemImageId=" + this.systemImageId + ", attributes=" + this.attributes + ", systemImageType=" + this.systemImageType + ", deprecated=" + this.deprecated + ")";
        }
    }
}

