/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import org.jboss.pnc.dto.GroupBuildRef;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.enums.BuildStatus;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GroupBuild
extends GroupBuildRef {
    private final GroupConfigurationRef groupConfig;
    private final User user;
    private final ProductVersionRef productVersion;

    private GroupBuild(GroupConfigurationRef groupConfig, User user, ProductVersionRef productVersion, String id, Instant startTime, Instant endTime, BuildStatus status, Boolean temporaryBuild) {
        super(id, startTime, endTime, status, temporaryBuild);
        this.groupConfig = groupConfig;
        this.user = user;
        this.productVersion = productVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().groupConfig(this.groupConfig).user(this.user).productVersion(this.productVersion).id(this.id).startTime(this.startTime).endTime(this.endTime).status(this.status).temporaryBuild(this.temporaryBuild);
    }

    public GroupConfigurationRef getGroupConfig() {
        return this.groupConfig;
    }

    public User getUser() {
        return this.user;
    }

    public ProductVersionRef getProductVersion() {
        return this.productVersion;
    }

    @Override
    public String toString() {
        return "GroupBuild(super=" + super.toString() + ", groupConfig=" + this.getGroupConfig() + ", user=" + this.getUser() + ", productVersion=" + this.getProductVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupBuild)) {
            return false;
        }
        GroupBuild other = (GroupBuild)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupConfigurationRef this$groupConfig = this.getGroupConfig();
        GroupConfigurationRef other$groupConfig = other.getGroupConfig();
        if (this$groupConfig == null ? other$groupConfig != null : !((Object)this$groupConfig).equals(other$groupConfig)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        ProductVersionRef this$productVersion = this.getProductVersion();
        ProductVersionRef other$productVersion = other.getProductVersion();
        return !(this$productVersion == null ? other$productVersion != null : !((Object)this$productVersion).equals(other$productVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GroupBuild;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GroupConfigurationRef $groupConfig = this.getGroupConfig();
        result = result * 59 + ($groupConfig == null ? 43 : ((Object)$groupConfig).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        ProductVersionRef $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : ((Object)$productVersion).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private GroupConfigurationRef groupConfig;
        private User user;
        private ProductVersionRef productVersion;
        private String id;
        private Instant startTime;
        private Instant endTime;
        private BuildStatus status;
        private Boolean temporaryBuild;

        Builder() {
        }

        public Builder groupConfig(GroupConfigurationRef groupConfig) {
            this.groupConfig = groupConfig;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder productVersion(ProductVersionRef productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder status(BuildStatus status) {
            this.status = status;
            return this;
        }

        public Builder temporaryBuild(Boolean temporaryBuild) {
            this.temporaryBuild = temporaryBuild;
            return this;
        }

        public GroupBuild build() {
            return new GroupBuild(this.groupConfig, this.user, this.productVersion, this.id, this.startTime, this.endTime, this.status, this.temporaryBuild);
        }

        public String toString() {
            return "GroupBuild.Builder(groupConfig=" + this.groupConfig + ", user=" + this.user + ", productVersion=" + this.productVersion + ", id=" + this.id + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", status=" + this.status + ", temporaryBuild=" + this.temporaryBuild + ")";
        }
    }
}

