/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.ProductReleaseRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.validation.constraints.RefHasId;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductMilestone
extends ProductMilestoneRef {
    @RefHasId(groups={WhenCreatingNew.class})
    private final ProductVersionRef productVersion;
    private final ProductReleaseRef productRelease;

    private ProductMilestone(ProductVersionRef productVersion, ProductReleaseRef productRelease, String id, String version, Instant endDate, Instant startingDate, Instant plannedEndDate) {
        super(id, version, endDate, startingDate, plannedEndDate);
        this.productVersion = productVersion;
        this.productRelease = productRelease;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().productVersion(this.productVersion).productRelease(this.productRelease).id(this.id).version(this.version).endDate(this.endDate).startingDate(this.startingDate).plannedEndDate(this.plannedEndDate);
    }

    public ProductVersionRef getProductVersion() {
        return this.productVersion;
    }

    public ProductReleaseRef getProductRelease() {
        return this.productRelease;
    }

    @Override
    public String toString() {
        return "ProductMilestone(super=" + super.toString() + ", productVersion=" + this.getProductVersion() + ", productRelease=" + this.getProductRelease() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductMilestone)) {
            return false;
        }
        ProductMilestone other = (ProductMilestone)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProductVersionRef this$productVersion = this.getProductVersion();
        ProductVersionRef other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !((Object)this$productVersion).equals(other$productVersion)) {
            return false;
        }
        ProductReleaseRef this$productRelease = this.getProductRelease();
        ProductReleaseRef other$productRelease = other.getProductRelease();
        return !(this$productRelease == null ? other$productRelease != null : !((Object)this$productRelease).equals(other$productRelease));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProductMilestone;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ProductVersionRef $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : ((Object)$productVersion).hashCode());
        ProductReleaseRef $productRelease = this.getProductRelease();
        result = result * 59 + ($productRelease == null ? 43 : ((Object)$productRelease).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private ProductVersionRef productVersion;
        private ProductReleaseRef productRelease;
        private String id;
        private String version;
        private Instant endDate;
        private Instant startingDate;
        private Instant plannedEndDate;

        Builder() {
        }

        public Builder productVersion(ProductVersionRef productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public Builder productRelease(ProductReleaseRef productRelease) {
            this.productRelease = productRelease;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder startingDate(Instant startingDate) {
            this.startingDate = startingDate;
            return this;
        }

        public Builder plannedEndDate(Instant plannedEndDate) {
            this.plannedEndDate = plannedEndDate;
            return this;
        }

        public ProductMilestone build() {
            return new ProductMilestone(this.productVersion, this.productRelease, this.id, this.version, this.endDate, this.startingDate, this.plannedEndDate);
        }

        public String toString() {
            return "ProductMilestone.Builder(productVersion=" + this.productVersion + ", productRelease=" + this.productRelease + ", id=" + this.id + ", version=" + this.version + ", endDate=" + this.endDate + ", startingDate=" + this.startingDate + ", plannedEndDate=" + this.plannedEndDate + ")";
        }
    }
}

