/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import org.jboss.pnc.dto.ArtifactRevisionRef;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.enums.ArtifactQuality;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ArtifactRevision
extends ArtifactRevisionRef {
    private final User modificationUser;

    private ArtifactRevision(String id, Integer rev, String qualityLevelReason, Instant modificationTime, ArtifactQuality artifactQuality, User modificationUser) {
        super(id, rev, qualityLevelReason, modificationTime, artifactQuality);
        this.modificationUser = modificationUser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).rev(this.rev).qualityLevelReason(this.qualityLevelReason).modificationTime(this.modificationTime).artifactQuality(this.artifactQuality).modificationUser(this.modificationUser);
    }

    public User getModificationUser() {
        return this.modificationUser;
    }

    @Override
    public String toString() {
        return "ArtifactRevision(super=" + super.toString() + ", modificationUser=" + this.getModificationUser() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactRevision)) {
            return false;
        }
        ArtifactRevision other = (ArtifactRevision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        User this$modificationUser = this.getModificationUser();
        User other$modificationUser = other.getModificationUser();
        return !(this$modificationUser == null ? other$modificationUser != null : !((Object)this$modificationUser).equals(other$modificationUser));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArtifactRevision;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        User $modificationUser = this.getModificationUser();
        result = result * 59 + ($modificationUser == null ? 43 : ((Object)$modificationUser).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private Integer rev;
        private String qualityLevelReason;
        private Instant modificationTime;
        private ArtifactQuality artifactQuality;
        private User modificationUser;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder rev(Integer rev) {
            this.rev = rev;
            return this;
        }

        public Builder qualityLevelReason(String qualityLevelReason) {
            this.qualityLevelReason = qualityLevelReason;
            return this;
        }

        public Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder artifactQuality(ArtifactQuality artifactQuality) {
            this.artifactQuality = artifactQuality;
            return this;
        }

        public Builder modificationUser(User modificationUser) {
            this.modificationUser = modificationUser;
            return this;
        }

        public ArtifactRevision build() {
            return new ArtifactRevision(this.id, this.rev, this.qualityLevelReason, this.modificationTime, this.artifactQuality, this.modificationUser);
        }

        public String toString() {
            return "ArtifactRevision.Builder(id=" + this.id + ", rev=" + this.rev + ", qualityLevelReason=" + this.qualityLevelReason + ", modificationTime=" + this.modificationTime + ", artifactQuality=" + this.artifactQuality + ", modificationUser=" + this.modificationUser + ")";
        }
    }
}

