/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Collections;
import java.util.List;

@JsonDeserialize(builder=Builder.class)
public class Validation {
    private final String attribute;
    private final List<String> messages;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Object value;

    public Validation(String attribute, String message, Object value) {
        this.attribute = attribute;
        this.messages = Collections.singletonList(message);
        this.value = value;
    }

    public Validation(String attribute, String message) {
        this.attribute = attribute;
        this.messages = Collections.singletonList(message);
        this.value = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAttribute() {
        return this.attribute;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Validation)) {
            return false;
        }
        Validation other = (Validation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$attribute = this.getAttribute();
        String other$attribute = other.getAttribute();
        if (this$attribute == null ? other$attribute != null : !this$attribute.equals(other$attribute)) {
            return false;
        }
        List<String> this$messages = this.getMessages();
        List<String> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Validation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $attribute = this.getAttribute();
        result = result * 59 + ($attribute == null ? 43 : $attribute.hashCode());
        List<String> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Validation(attribute=" + this.getAttribute() + ", messages=" + this.getMessages() + ", value=" + this.getValue() + ")";
    }

    public Validation(String attribute, List<String> messages, Object value) {
        this.attribute = attribute;
        this.messages = messages;
        this.value = value;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String attribute;
        private List<String> messages;
        private Object value;

        Builder() {
        }

        public Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public Builder messages(List<String> messages) {
            this.messages = messages;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Validation build() {
            return new Validation(this.attribute, this.messages, this.value);
        }

        public String toString() {
            return "Validation.Builder(attribute=" + this.attribute + ", messages=" + this.messages + ", value=" + this.value + ")";
        }
    }
}

