package org.jboss.pnc.client.patch;

import java.lang.Exception;
import java.lang.String;
import org.jboss.pnc.dto.Artifact;
import org.jboss.pnc.enums.ArtifactQuality;

public class ArtifactPatchBuilder extends PatchBase<ArtifactPatchBuilder, Artifact> {
  public ArtifactPatchBuilder() {
    super(org.jboss.pnc.dto.Artifact.class);
  }

  public ArtifactPatchBuilder replaceArtifactQuality(ArtifactQuality element) throws
      PatchBuilderException {
    try {
      return replace(element, "artifactQuality");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ArtifactPatchBuilder replaceQualityLevelReason(String element) throws
      PatchBuilderException {
    try {
      return replace(element, "qualityLevelReason");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }
}
