/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.BuildProgress;
import org.jboss.pnc.enums.BuildStatus;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildRef
implements DTOEntity {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    protected final String id;
    protected final Instant submitTime;
    protected final Instant startTime;
    protected final Instant endTime;
    protected final BuildProgress progress;
    protected final BuildStatus status;
    protected final String buildContentId;
    protected final Boolean temporaryBuild;
    protected final String scmUrl;
    protected final String scmRevision;
    protected final String scmTag;
    protected final String buildOutputChecksum;

    BuildRef(String id, Instant submitTime, Instant startTime, Instant endTime, BuildProgress progress, BuildStatus status, String buildContentId, Boolean temporaryBuild, String scmUrl, String scmRevision, String scmTag, String buildOutputChecksum) {
        this.id = id;
        this.submitTime = submitTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.progress = progress;
        this.status = status;
        this.buildContentId = buildContentId;
        this.temporaryBuild = temporaryBuild;
        this.scmUrl = scmUrl;
        this.scmRevision = scmRevision;
        this.scmTag = scmTag;
        this.buildOutputChecksum = buildOutputChecksum;
    }

    public static Builder refBuilder() {
        return new Builder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Instant getSubmitTime() {
        return this.submitTime;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public BuildProgress getProgress() {
        return this.progress;
    }

    public BuildStatus getStatus() {
        return this.status;
    }

    public String getBuildContentId() {
        return this.buildContentId;
    }

    public Boolean getTemporaryBuild() {
        return this.temporaryBuild;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public String getBuildOutputChecksum() {
        return this.buildOutputChecksum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildRef)) {
            return false;
        }
        BuildRef other = (BuildRef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Instant this$submitTime = this.getSubmitTime();
        Instant other$submitTime = other.getSubmitTime();
        if (this$submitTime == null ? other$submitTime != null : !((Object)this$submitTime).equals(other$submitTime)) {
            return false;
        }
        Instant this$startTime = this.getStartTime();
        Instant other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Instant this$endTime = this.getEndTime();
        Instant other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        BuildProgress this$progress = this.getProgress();
        BuildProgress other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !this$progress.equals(other$progress)) {
            return false;
        }
        BuildStatus this$status = this.getStatus();
        BuildStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$buildContentId = this.getBuildContentId();
        String other$buildContentId = other.getBuildContentId();
        if (this$buildContentId == null ? other$buildContentId != null : !this$buildContentId.equals(other$buildContentId)) {
            return false;
        }
        Boolean this$temporaryBuild = this.getTemporaryBuild();
        Boolean other$temporaryBuild = other.getTemporaryBuild();
        if (this$temporaryBuild == null ? other$temporaryBuild != null : !((Object)this$temporaryBuild).equals(other$temporaryBuild)) {
            return false;
        }
        String this$scmUrl = this.getScmUrl();
        String other$scmUrl = other.getScmUrl();
        if (this$scmUrl == null ? other$scmUrl != null : !this$scmUrl.equals(other$scmUrl)) {
            return false;
        }
        String this$scmRevision = this.getScmRevision();
        String other$scmRevision = other.getScmRevision();
        if (this$scmRevision == null ? other$scmRevision != null : !this$scmRevision.equals(other$scmRevision)) {
            return false;
        }
        String this$scmTag = this.getScmTag();
        String other$scmTag = other.getScmTag();
        if (this$scmTag == null ? other$scmTag != null : !this$scmTag.equals(other$scmTag)) {
            return false;
        }
        String this$buildOutputChecksum = this.getBuildOutputChecksum();
        String other$buildOutputChecksum = other.getBuildOutputChecksum();
        return !(this$buildOutputChecksum == null ? other$buildOutputChecksum != null : !this$buildOutputChecksum.equals(other$buildOutputChecksum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildRef;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Instant $submitTime = this.getSubmitTime();
        result = result * 59 + ($submitTime == null ? 43 : ((Object)$submitTime).hashCode());
        Instant $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Instant $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        BuildProgress $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        BuildStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $buildContentId = this.getBuildContentId();
        result = result * 59 + ($buildContentId == null ? 43 : $buildContentId.hashCode());
        Boolean $temporaryBuild = this.getTemporaryBuild();
        result = result * 59 + ($temporaryBuild == null ? 43 : ((Object)$temporaryBuild).hashCode());
        String $scmUrl = this.getScmUrl();
        result = result * 59 + ($scmUrl == null ? 43 : $scmUrl.hashCode());
        String $scmRevision = this.getScmRevision();
        result = result * 59 + ($scmRevision == null ? 43 : $scmRevision.hashCode());
        String $scmTag = this.getScmTag();
        result = result * 59 + ($scmTag == null ? 43 : $scmTag.hashCode());
        String $buildOutputChecksum = this.getBuildOutputChecksum();
        result = result * 59 + ($buildOutputChecksum == null ? 43 : $buildOutputChecksum.hashCode());
        return result;
    }

    public String toString() {
        return "BuildRef(id=" + this.getId() + ", submitTime=" + this.getSubmitTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", progress=" + this.getProgress() + ", status=" + this.getStatus() + ", buildContentId=" + this.getBuildContentId() + ", temporaryBuild=" + this.getTemporaryBuild() + ", scmUrl=" + this.getScmUrl() + ", scmRevision=" + this.getScmRevision() + ", scmTag=" + this.getScmTag() + ", buildOutputChecksum=" + this.getBuildOutputChecksum() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private Instant submitTime;
        private Instant startTime;
        private Instant endTime;
        private BuildProgress progress;
        private BuildStatus status;
        private String buildContentId;
        private Boolean temporaryBuild;
        private String scmUrl;
        private String scmRevision;
        private String scmTag;
        private String buildOutputChecksum;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder progress(BuildProgress progress) {
            this.progress = progress;
            return this;
        }

        public Builder status(BuildStatus status) {
            this.status = status;
            return this;
        }

        public Builder buildContentId(String buildContentId) {
            this.buildContentId = buildContentId;
            return this;
        }

        public Builder temporaryBuild(Boolean temporaryBuild) {
            this.temporaryBuild = temporaryBuild;
            return this;
        }

        public Builder scmUrl(String scmUrl) {
            this.scmUrl = scmUrl;
            return this;
        }

        public Builder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        public Builder scmTag(String scmTag) {
            this.scmTag = scmTag;
            return this;
        }

        public Builder buildOutputChecksum(String buildOutputChecksum) {
            this.buildOutputChecksum = buildOutputChecksum;
            return this;
        }

        public BuildRef build() {
            return new BuildRef(this.id, this.submitTime, this.startTime, this.endTime, this.progress, this.status, this.buildContentId, this.temporaryBuild, this.scmUrl, this.scmRevision, this.scmTag, this.buildOutputChecksum);
        }

        public String toString() {
            return "BuildRef.Builder(id=" + this.id + ", submitTime=" + this.submitTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", progress=" + this.progress + ", status=" + this.status + ", buildContentId=" + this.buildContentId + ", temporaryBuild=" + this.temporaryBuild + ", scmUrl=" + this.scmUrl + ", scmRevision=" + this.scmRevision + ", scmTag=" + this.scmTag + ", buildOutputChecksum=" + this.buildOutputChecksum + ")";
        }
    }
}

