/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class User
implements DTOEntity {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    protected final String id;
    protected final String username;

    User(String id, String username) {
        this.id = id;
        this.username = username;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).username(this.username);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    public String toString() {
        return "User(id=" + this.getId() + ", username=" + this.getUsername() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private String username;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public User build() {
            return new User(this.id, this.username);
        }

        public String toString() {
            return "User.Builder(id=" + this.id + ", username=" + this.username + ")";
        }
    }
}

