/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import org.jboss.pnc.dto.ArtifactRef;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.TargetRepository;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.BuildCategory;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Artifact
extends ArtifactRef {
    private final TargetRepository targetRepository;
    private final Build build;
    private final User creationUser;
    private final User modificationUser;

    private Artifact(TargetRepository targetRepository, Build build, String id, String identifier, String purl, ArtifactQuality artifactQuality, BuildCategory buildCategory, String md5, String sha1, String sha256, String filename, String deployPath, Instant importDate, String originUrl, Long size, String deployUrl, String publicUrl, User creationUser, User modificationUser, Instant creationTime, Instant modificationTime, String qualityLevelReason) {
        super(id, identifier, purl, artifactQuality, buildCategory, md5, sha1, sha256, filename, deployPath, importDate, originUrl, size, deployUrl, publicUrl, creationTime, modificationTime, qualityLevelReason);
        this.targetRepository = targetRepository;
        this.build = build;
        this.creationUser = creationUser;
        this.modificationUser = modificationUser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().targetRepository(this.targetRepository).build(this.build).id(this.id).identifier(this.identifier).purl(this.purl).artifactQuality(this.artifactQuality).buildCategory(this.buildCategory).md5(this.md5).sha1(this.sha1).sha256(this.sha256).filename(this.filename).deployPath(this.deployPath).importDate(this.importDate).originUrl(this.originUrl).size(this.size).deployUrl(this.deployUrl).publicUrl(this.publicUrl).creationUser(this.creationUser).modificationUser(this.modificationUser).creationTime(this.creationTime).modificationTime(this.modificationTime).qualityLevelReason(this.qualityLevelReason);
    }

    public TargetRepository getTargetRepository() {
        return this.targetRepository;
    }

    public Build getBuild() {
        return this.build;
    }

    public User getCreationUser() {
        return this.creationUser;
    }

    public User getModificationUser() {
        return this.modificationUser;
    }

    @Override
    public String toString() {
        return "Artifact(super=" + super.toString() + ", targetRepository=" + this.getTargetRepository() + ", build=" + this.getBuild() + ", creationUser=" + this.getCreationUser() + ", modificationUser=" + this.getModificationUser() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TargetRepository this$targetRepository = this.getTargetRepository();
        TargetRepository other$targetRepository = other.getTargetRepository();
        if (this$targetRepository == null ? other$targetRepository != null : !((Object)this$targetRepository).equals(other$targetRepository)) {
            return false;
        }
        Build this$build = this.getBuild();
        Build other$build = other.getBuild();
        if (this$build == null ? other$build != null : !((Object)this$build).equals(other$build)) {
            return false;
        }
        User this$creationUser = this.getCreationUser();
        User other$creationUser = other.getCreationUser();
        if (this$creationUser == null ? other$creationUser != null : !((Object)this$creationUser).equals(other$creationUser)) {
            return false;
        }
        User this$modificationUser = this.getModificationUser();
        User other$modificationUser = other.getModificationUser();
        return !(this$modificationUser == null ? other$modificationUser != null : !((Object)this$modificationUser).equals(other$modificationUser));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Artifact;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TargetRepository $targetRepository = this.getTargetRepository();
        result = result * 59 + ($targetRepository == null ? 43 : ((Object)$targetRepository).hashCode());
        Build $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        User $creationUser = this.getCreationUser();
        result = result * 59 + ($creationUser == null ? 43 : ((Object)$creationUser).hashCode());
        User $modificationUser = this.getModificationUser();
        result = result * 59 + ($modificationUser == null ? 43 : ((Object)$modificationUser).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private TargetRepository targetRepository;
        private Build build;
        private String id;
        private String identifier;
        private String purl;
        private ArtifactQuality artifactQuality;
        private BuildCategory buildCategory;
        private String md5;
        private String sha1;
        private String sha256;
        private String filename;
        private String deployPath;
        private Instant importDate;
        private String originUrl;
        private Long size;
        private String deployUrl;
        private String publicUrl;
        private User creationUser;
        private User modificationUser;
        private Instant creationTime;
        private Instant modificationTime;
        private String qualityLevelReason;

        Builder() {
        }

        public Builder targetRepository(TargetRepository targetRepository) {
            this.targetRepository = targetRepository;
            return this;
        }

        public Builder build(Build build) {
            this.build = build;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder purl(String purl) {
            this.purl = purl;
            return this;
        }

        public Builder artifactQuality(ArtifactQuality artifactQuality) {
            this.artifactQuality = artifactQuality;
            return this;
        }

        public Builder buildCategory(BuildCategory buildCategory) {
            this.buildCategory = buildCategory;
            return this;
        }

        public Builder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public Builder sha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        public Builder sha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder deployPath(String deployPath) {
            this.deployPath = deployPath;
            return this;
        }

        public Builder importDate(Instant importDate) {
            this.importDate = importDate;
            return this;
        }

        public Builder originUrl(String originUrl) {
            this.originUrl = originUrl;
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        public Builder deployUrl(String deployUrl) {
            this.deployUrl = deployUrl;
            return this;
        }

        public Builder publicUrl(String publicUrl) {
            this.publicUrl = publicUrl;
            return this;
        }

        public Builder creationUser(User creationUser) {
            this.creationUser = creationUser;
            return this;
        }

        public Builder modificationUser(User modificationUser) {
            this.modificationUser = modificationUser;
            return this;
        }

        public Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder qualityLevelReason(String qualityLevelReason) {
            this.qualityLevelReason = qualityLevelReason;
            return this;
        }

        public Artifact build() {
            return new Artifact(this.targetRepository, this.build, this.id, this.identifier, this.purl, this.artifactQuality, this.buildCategory, this.md5, this.sha1, this.sha256, this.filename, this.deployPath, this.importDate, this.originUrl, this.size, this.deployUrl, this.publicUrl, this.creationUser, this.modificationUser, this.creationTime, this.modificationTime, this.qualityLevelReason);
        }

        public String toString() {
            return "Artifact.Builder(targetRepository=" + this.targetRepository + ", build=" + this.build + ", id=" + this.id + ", identifier=" + this.identifier + ", purl=" + this.purl + ", artifactQuality=" + this.artifactQuality + ", buildCategory=" + this.buildCategory + ", md5=" + this.md5 + ", sha1=" + this.sha1 + ", sha256=" + this.sha256 + ", filename=" + this.filename + ", deployPath=" + this.deployPath + ", importDate=" + this.importDate + ", originUrl=" + this.originUrl + ", size=" + this.size + ", deployUrl=" + this.deployUrl + ", publicUrl=" + this.publicUrl + ", creationUser=" + this.creationUser + ", modificationUser=" + this.modificationUser + ", creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", qualityLevelReason=" + this.qualityLevelReason + ")";
        }
    }
}

