/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.Map;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.validation.constraints.RefHasId;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.BuildType;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildConfiguration
extends BuildConfigurationRef {
    @RefHasId(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final SCMRepository scmRepository;
    @RefHasId(groups={WhenCreatingNew.class})
    protected final ProjectRef project;
    @RefHasId(groups={WhenCreatingNew.class, WhenUpdating.class})
    protected final Environment environment;
    protected final Map<String, BuildConfigurationRef> dependencies;
    @RefHasId(groups={WhenCreatingNew.class, WhenUpdating.class}, optional=true)
    protected final ProductVersionRef productVersion;
    protected final Map<String, GroupConfigurationRef> groupConfigs;
    protected final Map<String, String> parameters;
    protected final User creationUser;
    protected final User modificationUser;

    protected BuildConfiguration(SCMRepository scmRepository, ProjectRef project, Environment environment, Map<String, BuildConfigurationRef> dependencies, ProductVersionRef productVersion, Map<String, GroupConfigurationRef> groupConfigs, Map<String, String> parameters, String id, String name, String description, String buildScript, String scmRevision, Instant creationTime, Instant modificationTime, BuildType buildType, User creationUser, User modificationUser, String defaultAlignmentParams, Boolean brewPullActive) {
        super(id, name, description, buildScript, scmRevision, creationTime, modificationTime, buildType, defaultAlignmentParams, brewPullActive);
        this.scmRepository = scmRepository;
        this.project = project;
        this.environment = environment;
        this.dependencies = dependencies;
        this.productVersion = productVersion;
        this.groupConfigs = groupConfigs;
        this.parameters = parameters;
        this.creationUser = creationUser;
        this.modificationUser = modificationUser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().scmRepository(this.scmRepository).project(this.project).environment(this.environment).dependencies(this.dependencies).productVersion(this.productVersion).groupConfigs(this.groupConfigs).parameters(this.parameters).id(this.id).name(this.name).description(this.description).buildScript(this.buildScript).scmRevision(this.scmRevision).creationTime(this.creationTime).modificationTime(this.modificationTime).buildType(this.buildType).creationUser(this.creationUser).modificationUser(this.modificationUser).defaultAlignmentParams(this.defaultAlignmentParams).brewPullActive(this.brewPullActive);
    }

    public SCMRepository getScmRepository() {
        return this.scmRepository;
    }

    public ProjectRef getProject() {
        return this.project;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Map<String, BuildConfigurationRef> getDependencies() {
        return this.dependencies;
    }

    public ProductVersionRef getProductVersion() {
        return this.productVersion;
    }

    public Map<String, GroupConfigurationRef> getGroupConfigs() {
        return this.groupConfigs;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public User getCreationUser() {
        return this.creationUser;
    }

    public User getModificationUser() {
        return this.modificationUser;
    }

    @Override
    public String toString() {
        return "BuildConfiguration(super=" + super.toString() + ", scmRepository=" + this.getScmRepository() + ", project=" + this.getProject() + ", environment=" + this.getEnvironment() + ", dependencies=" + this.getDependencies() + ", productVersion=" + this.getProductVersion() + ", groupConfigs=" + this.getGroupConfigs() + ", parameters=" + this.getParameters() + ", creationUser=" + this.getCreationUser() + ", modificationUser=" + this.getModificationUser() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfiguration)) {
            return false;
        }
        BuildConfiguration other = (BuildConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SCMRepository this$scmRepository = this.getScmRepository();
        SCMRepository other$scmRepository = other.getScmRepository();
        if (this$scmRepository == null ? other$scmRepository != null : !((Object)this$scmRepository).equals(other$scmRepository)) {
            return false;
        }
        ProjectRef this$project = this.getProject();
        ProjectRef other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        Map<String, BuildConfigurationRef> this$dependencies = this.getDependencies();
        Map<String, BuildConfigurationRef> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        ProductVersionRef this$productVersion = this.getProductVersion();
        ProductVersionRef other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !((Object)this$productVersion).equals(other$productVersion)) {
            return false;
        }
        Map<String, GroupConfigurationRef> this$groupConfigs = this.getGroupConfigs();
        Map<String, GroupConfigurationRef> other$groupConfigs = other.getGroupConfigs();
        if (this$groupConfigs == null ? other$groupConfigs != null : !((Object)this$groupConfigs).equals(other$groupConfigs)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        User this$creationUser = this.getCreationUser();
        User other$creationUser = other.getCreationUser();
        if (this$creationUser == null ? other$creationUser != null : !((Object)this$creationUser).equals(other$creationUser)) {
            return false;
        }
        User this$modificationUser = this.getModificationUser();
        User other$modificationUser = other.getModificationUser();
        return !(this$modificationUser == null ? other$modificationUser != null : !((Object)this$modificationUser).equals(other$modificationUser));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BuildConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SCMRepository $scmRepository = this.getScmRepository();
        result = result * 59 + ($scmRepository == null ? 43 : ((Object)$scmRepository).hashCode());
        ProjectRef $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        Map<String, BuildConfigurationRef> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        ProductVersionRef $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : ((Object)$productVersion).hashCode());
        Map<String, GroupConfigurationRef> $groupConfigs = this.getGroupConfigs();
        result = result * 59 + ($groupConfigs == null ? 43 : ((Object)$groupConfigs).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        User $creationUser = this.getCreationUser();
        result = result * 59 + ($creationUser == null ? 43 : ((Object)$creationUser).hashCode());
        User $modificationUser = this.getModificationUser();
        result = result * 59 + ($modificationUser == null ? 43 : ((Object)$modificationUser).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private SCMRepository scmRepository;
        private ProjectRef project;
        private Environment environment;
        private Map<String, BuildConfigurationRef> dependencies;
        private ProductVersionRef productVersion;
        private Map<String, GroupConfigurationRef> groupConfigs;
        private Map<String, String> parameters;
        private String id;
        private String name;
        private String description;
        private String buildScript;
        private String scmRevision;
        private Instant creationTime;
        private Instant modificationTime;
        private BuildType buildType;
        private User creationUser;
        private User modificationUser;
        private String defaultAlignmentParams;
        private Boolean brewPullActive;

        Builder() {
        }

        public Builder scmRepository(SCMRepository scmRepository) {
            this.scmRepository = scmRepository;
            return this;
        }

        public Builder project(ProjectRef project) {
            this.project = project;
            return this;
        }

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder dependencies(Map<String, BuildConfigurationRef> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public Builder productVersion(ProductVersionRef productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public Builder groupConfigs(Map<String, GroupConfigurationRef> groupConfigs) {
            this.groupConfigs = groupConfigs;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder buildScript(String buildScript) {
            this.buildScript = buildScript;
            return this;
        }

        public Builder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        public Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        public Builder creationUser(User creationUser) {
            this.creationUser = creationUser;
            return this;
        }

        public Builder modificationUser(User modificationUser) {
            this.modificationUser = modificationUser;
            return this;
        }

        public Builder defaultAlignmentParams(String defaultAlignmentParams) {
            this.defaultAlignmentParams = defaultAlignmentParams;
            return this;
        }

        public Builder brewPullActive(Boolean brewPullActive) {
            this.brewPullActive = brewPullActive;
            return this;
        }

        public BuildConfiguration build() {
            return new BuildConfiguration(this.scmRepository, this.project, this.environment, this.dependencies, this.productVersion, this.groupConfigs, this.parameters, this.id, this.name, this.description, this.buildScript, this.scmRevision, this.creationTime, this.modificationTime, this.buildType, this.creationUser, this.modificationUser, this.defaultAlignmentParams, this.brewPullActive);
        }

        public String toString() {
            return "BuildConfiguration.Builder(scmRepository=" + this.scmRepository + ", project=" + this.project + ", environment=" + this.environment + ", dependencies=" + this.dependencies + ", productVersion=" + this.productVersion + ", groupConfigs=" + this.groupConfigs + ", parameters=" + this.parameters + ", id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", buildScript=" + this.buildScript + ", scmRevision=" + this.scmRevision + ", creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", buildType=" + this.buildType + ", creationUser=" + this.creationUser + ", modificationUser=" + this.modificationUser + ", defaultAlignmentParams=" + this.defaultAlignmentParams + ", brewPullActive=" + this.brewPullActive + ")";
        }
    }
}

