package org.jboss.pnc.client.patch;

import java.lang.Exception;
import java.lang.String;
import java.util.Map;
import org.jboss.pnc.dto.Product;
import org.jboss.pnc.dto.ProductVersionRef;

public class ProductPatchBuilder extends PatchBase<ProductPatchBuilder, Product> {
  public ProductPatchBuilder() {
    super(org.jboss.pnc.dto.Product.class);
  }

  public ProductPatchBuilder addProductVersions(Map<String, ProductVersionRef> elements) throws
      PatchBuilderException {
    try {
      return add(elements, "productVersions");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductPatchBuilder replaceProductVersions(Map<String, ProductVersionRef> element) throws
      PatchBuilderException {
    try {
      return replace(element, "productVersions");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductPatchBuilder replaceName(String element) throws PatchBuilderException {
    try {
      return replace(element, "name");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductPatchBuilder replaceDescription(String element) throws PatchBuilderException {
    try {
      return replace(element, "description");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductPatchBuilder replaceAbbreviation(String element) throws PatchBuilderException {
    try {
      return replace(element, "abbreviation");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductPatchBuilder replaceProductManagers(String element) throws PatchBuilderException {
    try {
      return replace(element, "productManagers");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }

  public ProductPatchBuilder replaceProductPagesCode(String element) throws PatchBuilderException {
    try {
      return replace(element, "productPagesCode");
    } catch (Exception e) {
      throw new PatchBuilderException("Error creating patch.", e);
    }
  }
}
