/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.notification.Notification;
import org.jboss.pnc.enums.JobNotificationProgress;
import org.jboss.pnc.enums.JobNotificationType;

public class BuildConfigurationCreation
extends Notification {
    private static final String BC_CREATION_SUCCESS = "BC_CREATION_SUCCESS";
    private static final String BC_CREATION_ERROR = "BC_CREATION_ERROR";
    private final SCMRepository scmRepository;
    private final BuildConfigurationRef buildConfig;
    private final String taskId;

    private BuildConfigurationCreation(SCMRepository scmRepository, BuildConfigurationRef buildConfig, String taskId) {
        super(JobNotificationType.BUILD_CONFIG_CREATION, BC_CREATION_SUCCESS, JobNotificationProgress.FINISHED, JobNotificationProgress.IN_PROGRESS);
        this.scmRepository = scmRepository;
        this.buildConfig = buildConfig;
        this.taskId = taskId;
    }

    @JsonCreator
    private BuildConfigurationCreation(@JsonProperty(value="scmRepository") SCMRepository scmRepository, @JsonProperty(value="buildConfig") BuildConfigurationRef buildConfig, @JsonProperty(value="message") String message, @JsonProperty(value="taskId") String taskId) {
        super(JobNotificationType.BUILD_CONFIG_CREATION, BC_CREATION_ERROR, JobNotificationProgress.FINISHED, JobNotificationProgress.IN_PROGRESS, message);
        this.scmRepository = scmRepository;
        this.buildConfig = buildConfig;
        this.taskId = taskId;
    }

    public static BuildConfigurationCreation success(SCMRepository scmRepository, BuildConfigurationRef buildConfig, String taskId) {
        return new BuildConfigurationCreation(scmRepository, buildConfig, taskId);
    }

    public static BuildConfigurationCreation error(SCMRepository scmRepository, BuildConfigurationRef buildConfig, String errorMessage, String taskId) {
        return new BuildConfigurationCreation(scmRepository, buildConfig, errorMessage, taskId);
    }

    public SCMRepository getScmRepository() {
        return this.scmRepository;
    }

    public BuildConfigurationRef getBuildConfig() {
        return this.buildConfig;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfigurationCreation)) {
            return false;
        }
        BuildConfigurationCreation other = (BuildConfigurationCreation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCMRepository this$scmRepository = this.getScmRepository();
        SCMRepository other$scmRepository = other.getScmRepository();
        if (this$scmRepository == null ? other$scmRepository != null : !((Object)this$scmRepository).equals(other$scmRepository)) {
            return false;
        }
        BuildConfigurationRef this$buildConfig = this.getBuildConfig();
        BuildConfigurationRef other$buildConfig = other.getBuildConfig();
        if (this$buildConfig == null ? other$buildConfig != null : !((Object)this$buildConfig).equals(other$buildConfig)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        return !(this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BuildConfigurationCreation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCMRepository $scmRepository = this.getScmRepository();
        result = result * 59 + ($scmRepository == null ? 43 : ((Object)$scmRepository).hashCode());
        BuildConfigurationRef $buildConfig = this.getBuildConfig();
        result = result * 59 + ($buildConfig == null ? 43 : ((Object)$buildConfig).hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BuildConfigurationCreation(scmRepository=" + this.getScmRepository() + ", buildConfig=" + this.getBuildConfig() + ", taskId=" + this.getTaskId() + ")";
    }
}

