/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.constraints.SCMUrl;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SCMRepository
implements DTOEntity {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    protected final String id;
    @NotBlank(groups={WhenUpdating.class, WhenCreatingNew.class})
    @SCMUrl(groups={WhenUpdating.class, WhenCreatingNew.class})
    protected final String internalUrl;
    @SCMUrl(groups={WhenUpdating.class, WhenCreatingNew.class})
    protected final String externalUrl;
    protected final Boolean preBuildSyncEnabled;

    SCMRepository(String id, String internalUrl, String externalUrl, Boolean preBuildSyncEnabled) {
        this.id = id;
        this.internalUrl = internalUrl;
        this.externalUrl = externalUrl;
        this.preBuildSyncEnabled = preBuildSyncEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).internalUrl(this.internalUrl).externalUrl(this.externalUrl).preBuildSyncEnabled(this.preBuildSyncEnabled);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getInternalUrl() {
        return this.internalUrl;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public Boolean getPreBuildSyncEnabled() {
        return this.preBuildSyncEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCMRepository)) {
            return false;
        }
        SCMRepository other = (SCMRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$preBuildSyncEnabled = this.getPreBuildSyncEnabled();
        Boolean other$preBuildSyncEnabled = other.getPreBuildSyncEnabled();
        if (this$preBuildSyncEnabled == null ? other$preBuildSyncEnabled != null : !((Object)this$preBuildSyncEnabled).equals(other$preBuildSyncEnabled)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$internalUrl = this.getInternalUrl();
        String other$internalUrl = other.getInternalUrl();
        if (this$internalUrl == null ? other$internalUrl != null : !this$internalUrl.equals(other$internalUrl)) {
            return false;
        }
        String this$externalUrl = this.getExternalUrl();
        String other$externalUrl = other.getExternalUrl();
        return !(this$externalUrl == null ? other$externalUrl != null : !this$externalUrl.equals(other$externalUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SCMRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $preBuildSyncEnabled = this.getPreBuildSyncEnabled();
        result = result * 59 + ($preBuildSyncEnabled == null ? 43 : ((Object)$preBuildSyncEnabled).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $internalUrl = this.getInternalUrl();
        result = result * 59 + ($internalUrl == null ? 43 : $internalUrl.hashCode());
        String $externalUrl = this.getExternalUrl();
        result = result * 59 + ($externalUrl == null ? 43 : $externalUrl.hashCode());
        return result;
    }

    public String toString() {
        return "SCMRepository(id=" + this.getId() + ", internalUrl=" + this.getInternalUrl() + ", externalUrl=" + this.getExternalUrl() + ", preBuildSyncEnabled=" + this.getPreBuildSyncEnabled() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String id;
        private String internalUrl;
        private String externalUrl;
        private Boolean preBuildSyncEnabled;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder internalUrl(String internalUrl) {
            this.internalUrl = internalUrl;
            return this;
        }

        public Builder externalUrl(String externalUrl) {
            this.externalUrl = externalUrl;
            return this;
        }

        public Builder preBuildSyncEnabled(Boolean preBuildSyncEnabled) {
            this.preBuildSyncEnabled = preBuildSyncEnabled;
            return this;
        }

        public SCMRepository build() {
            return new SCMRepository(this.id, this.internalUrl, this.externalUrl, this.preBuildSyncEnabled);
        }

        public String toString() {
            return "SCMRepository.Builder(id=" + this.id + ", internalUrl=" + this.internalUrl + ", externalUrl=" + this.externalUrl + ", preBuildSyncEnabled=" + this.preBuildSyncEnabled + ")";
        }
    }
}

